/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.crypto;

import com.eucalyptus.component.auth.SystemCredentials;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.crypto.KeyStore;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.UrlBase64;

public class StringCrypto {
    private final String ALIAS = "eucalyptus";
    private final String PASSWORD = "eucalyptus";
    private static KeyStore keystore;
    private String asymmetricFormat = "RSA/ECB/PKCS1Padding";
    private String provider = "BC";

    public static byte[] cat(byte[] bs, byte[] bs2) {
        byte[] result = Arrays.copyOf(bs, bs.length + bs2.length);
        System.arraycopy(bs2, 0, result, bs.length, bs2.length);
        return result;
    }

    public StringCrypto() {
    }

    public StringCrypto(String format, String provider) {
        this.asymmetricFormat = format;
        this.provider = provider;
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (Security.getProvider(this.provider) == null) {
            throw new RuntimeException("cannot find security provider " + this.provider);
        }
        keystore = SystemCredentials.getKeyStore();
        if (keystore == null) {
            throw new RuntimeException("cannot load keystore or find the key");
        }
    }

    public byte[] encrypt(String password) throws GeneralSecurityException {
        PublicKey pk = keystore.getCertificate("eucalyptus").getPublicKey();
        Cipher cipher = Cipher.getInstance(this.asymmetricFormat, this.provider);
        cipher.init(1, (Key)pk, (SecureRandom)Crypto.getSecureRandomSupplier().get());
        byte[] passwordEncrypted = cipher.doFinal(password.getBytes());
        return UrlBase64.encode((byte[])passwordEncrypted);
    }

    public String decrypt(String passwordEncoded) throws GeneralSecurityException {
        byte[] passwordEncrypted = UrlBase64.decode((String)passwordEncoded);
        Key pk = keystore.getKey("eucalyptus", "eucalyptus");
        Cipher cipher = Cipher.getInstance(this.asymmetricFormat, this.provider);
        cipher.init(2, pk, (SecureRandom)Crypto.getSecureRandomSupplier().get());
        return new String(cipher.doFinal(passwordEncrypted));
    }

    public String decryptOpenssl(String passwordEncoded) throws GeneralSecurityException {
        byte[] passwordEncrypted = Base64.decodeBase64((byte[])passwordEncoded.getBytes());
        Key pk = keystore.getKey("eucalyptus", "eucalyptus");
        Cipher cipher = Cipher.getInstance(this.asymmetricFormat, this.provider);
        cipher.init(2, pk, (SecureRandom)Crypto.getSecureRandomSupplier().get());
        return new String(cipher.doFinal(passwordEncrypted));
    }

    public String decryptOpenssl(String format, String passwordEncoded) throws GeneralSecurityException {
        byte[] passwordEncrypted = Base64.decodeBase64((byte[])passwordEncoded.getBytes());
        Key pk = keystore.getKey("eucalyptus", "eucalyptus");
        Cipher cipher = Cipher.getInstance(format, this.provider);
        cipher.init(2, pk, (SecureRandom)Crypto.getSecureRandomSupplier().get());
        return new String(cipher.doFinal(passwordEncrypted));
    }
}

