/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.crypto;

import com.eucalyptus.auth.crypto.MD5Crypt;
import com.eucalyptus.auth.util.Hashes;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.auth.SystemCredentials;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.crypto.CertificateProvider;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.crypto.CryptoProvider;
import com.eucalyptus.crypto.Digest;
import com.eucalyptus.crypto.HmacProvider;
import com.eucalyptus.crypto.Signatures;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.google.common.primitives.Ints;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Calendar;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.util.encoders.UrlBase64;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.bouncycastle.x509.extension.SubjectKeyIdentifierStructure;

public final class DefaultCryptoProvider
implements CryptoProvider,
CertificateProvider,
HmacProvider {
    public static String KEY_ALGORITHM = "RSA";
    private static final String KEY_SIGNING_ALGORITHM = "SHA512WithRSA";
    private static final int KEY_SIZE = 2048;
    public static String PROVIDER = "BC";
    private static final String PRIVATE_KEY_FORMAT = System.getProperty(DefaultCryptoProvider.class.getName() + ".privateKeyFormat", "");
    private static Logger LOG = Logger.getLogger(DefaultCryptoProvider.class);

    public String generateHashedPassword(String password) {
        byte[] data = Digest.MD5.get().digest(password.getBytes());
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString().toLowerCase();
    }

    public String generateAlphanumericId(int length, String prefix) {
        return prefix + this.generateRandomAlphanumeric(length - prefix.length()).toUpperCase();
    }

    public String generateSecretKey() {
        return this.generateRandomAlphanumeric(40);
    }

    public String generateSessionToken() {
        return this.generateRandomAlphanumeric(80);
    }

    private String generateRandomAlphanumeric(int length) {
        StringBuilder randomBuilder = new StringBuilder(length + 90);
        while (randomBuilder.length() < length) {
            randomBuilder.append(this.generateRandomAlphanumeric());
        }
        return randomBuilder.toString().substring(0, length);
    }

    private String generateRandomAlphanumeric() {
        return Hashes.getRandom(64).replaceAll("\\p{Punct}", "");
    }

    public String getDigestBase64(String input, Digest hash) {
        byte[] inputBytes = input.getBytes();
        MessageDigest digest = hash.get();
        digest.update(inputBytes);
        byte[] digestBytes = digest.digest();
        return new String(UrlBase64.encode((byte[])digestBytes));
    }

    public X509Certificate generateServiceCertificate(KeyPair keys, String serviceName) {
        X500Principal x500 = new X500Principal(String.format("CN=%s, OU=Eucalyptus, O=Cloud, C=US", serviceName));
        return this.generateCertificate(keys, x500, x500, null);
    }

    public X509Certificate generateCertificate(KeyPair keys, String userName) {
        return this.generateCertificate(keys, new X500Principal(String.format("CN=%s, OU=Eucalyptus, O=User, C=US", userName)));
    }

    public X509Certificate generateCertificate(KeyPair keys, X500Principal dn) {
        return this.generateCertificate(keys, dn, dn, null);
    }

    public X509Certificate generateCertificate(KeyPair keys, X500Principal subjectDn, X500Principal signer, PrivateKey signingKey) {
        Calendar cal = Calendar.getInstance();
        cal.add(1, 5);
        return this.generateCertificate(keys, subjectDn, signer, signingKey, cal.getTime());
    }

    public X509Certificate generateCertificate(PublicKey key, X500Principal subjectDn, X500Principal signer, PrivateKey signingKey, Date notAfter) {
        if (signingKey == null) {
            LOG.error((Object)"No signing key is provided");
            return null;
        }
        if (signer == null) {
            LOG.error((Object)"No signiner principal is specified");
            return null;
        }
        if (subjectDn == null) {
            LOG.error((Object)"No subject principal is specified");
            return null;
        }
        if (key == null) {
            LOG.error((Object)"No requesting key is specified");
            return null;
        }
        EventRecord.caller(DefaultCryptoProvider.class, (EventType)EventType.GENERATE_CERTIFICATE, (Object[])new Object[]{signer.toString(), subjectDn.toString()}).info();
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        certGen.setSerialNumber(BigInteger.valueOf(System.nanoTime()).shiftLeft(4).add(BigInteger.valueOf((long)Math.rint(Math.random() * 1000.0))));
        certGen.setIssuerDN(signer);
        certGen.addExtension((DERObjectIdentifier)X509Extensions.BasicConstraints, true, (ASN1Encodable)new BasicConstraints(true));
        try {
            certGen.addExtension((DERObjectIdentifier)X509Extensions.SubjectKeyIdentifier, false, (ASN1Encodable)new SubjectKeyIdentifierStructure(key));
        }
        catch (InvalidKeyException e) {
            LOG.error((Object)"Error adding subject key identifier extension.", (Throwable)e);
        }
        Calendar cal = Calendar.getInstance();
        certGen.setNotBefore(cal.getTime());
        certGen.setNotAfter(notAfter);
        certGen.setSubjectDN(subjectDn);
        certGen.setPublicKey(key);
        certGen.setSignatureAlgorithm(KEY_SIGNING_ALGORITHM);
        try {
            X509Certificate cert = certGen.generate(signingKey, PROVIDER);
            cert.checkValidity();
            return cert;
        }
        catch (Exception e) {
            LOG.fatal((Object)e, (Throwable)e);
            return null;
        }
    }

    public X509Certificate generateCertificate(KeyPair keys, X500Principal subjectDn, X500Principal signer, PrivateKey signingKey, Date notAfter) {
        signer = signingKey == null ? signer : subjectDn;
        signingKey = signingKey == null ? keys.getPrivate() : signingKey;
        EventRecord.caller(DefaultCryptoProvider.class, (EventType)EventType.GENERATE_CERTIFICATE, (Object[])new Object[]{signer.toString(), subjectDn.toString()}).info();
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        certGen.setSerialNumber(BigInteger.valueOf(System.nanoTime()).shiftLeft(4).add(BigInteger.valueOf((long)Math.rint(Math.random() * 1000.0))));
        certGen.setIssuerDN(signer);
        certGen.addExtension((DERObjectIdentifier)X509Extensions.BasicConstraints, true, (ASN1Encodable)new BasicConstraints(true));
        try {
            certGen.addExtension((DERObjectIdentifier)X509Extensions.SubjectKeyIdentifier, false, (ASN1Encodable)new SubjectKeyIdentifierStructure(keys.getPublic()));
        }
        catch (InvalidKeyException e) {
            LOG.error((Object)"Error adding subject key identifier extension.", (Throwable)e);
        }
        Calendar cal = Calendar.getInstance();
        certGen.setNotBefore(cal.getTime());
        certGen.setNotAfter(notAfter);
        certGen.setSubjectDN(subjectDn);
        certGen.setPublicKey(keys.getPublic());
        certGen.setSignatureAlgorithm(KEY_SIGNING_ALGORITHM);
        try {
            X509Certificate cert = certGen.generate(signingKey, PROVIDER);
            cert.checkValidity();
            return cert;
        }
        catch (Exception e) {
            LOG.fatal((Object)e, (Throwable)e);
            return null;
        }
    }

    public KeyPair generateKeyPair() {
        KeyPairGenerator keyGen = null;
        try {
            EventRecord.caller(DefaultCryptoProvider.class, (EventType)EventType.GENERATE_KEYPAIR, (Object[])new Object[0]);
            keyGen = KeyPairGenerator.getInstance(KEY_ALGORITHM, PROVIDER);
            SecureRandom random = (SecureRandom)Crypto.getSecureRandomSupplier().get();
            keyGen.initialize(2048, random);
            KeyPair keyPair = keyGen.generateKeyPair();
            return keyPair;
        }
        catch (Exception e) {
            LOG.fatal((Object)e, (Throwable)e);
            return null;
        }
    }

    public byte[] getEncoded(PrivateKey privateKey) {
        if ("pkcs8".equals(PRIVATE_KEY_FORMAT)) {
            try {
                return KeyFactory.getInstance(KEY_ALGORITHM, PROVIDER).getKeySpec(privateKey, PKCS8EncodedKeySpec.class).getEncoded();
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
        return privateKey.getEncoded();
    }

    public String generateSystemSignature() {
        return this.generateSystemToken(((Eucalyptus)ComponentIds.lookup(Eucalyptus.class)).name().getBytes());
    }

    public String generateSystemToken(byte[] data) {
        PrivateKey pk = SystemCredentials.lookup(Eucalyptus.class).getPrivateKey();
        return Signatures.SHA256withRSA.trySign(pk, data);
    }

    public String generateId(String prefix) {
        byte[] idBytes = new byte[4];
        ((SecureRandom)Crypto.getSecureRandomSupplier().get()).nextBytes(idBytes);
        return String.format("%s-%08x", prefix, Ints.fromByteArray((byte[])idBytes));
    }

    public String getFingerPrint(Key privKey) {
        return this.getFingerPrint(privKey.getEncoded());
    }

    public String getFingerPrint(byte[] data) {
        try {
            byte[] fp = Digest.SHA1.get().digest(data);
            StringBuffer sb = new StringBuffer();
            for (byte b : fp) {
                sb.append(String.format("%02X:", b));
            }
            return sb.substring(0, sb.length() - 1).toLowerCase();
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public String generateLinuxSaltedPassword(String password) {
        return MD5Crypt.crypt(password);
    }

    public boolean verifyLinuxSaltedPassword(String clear, String hashed) {
        return MD5Crypt.verifyPassword(clear, hashed);
    }
}

