/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth.checker;

import com.eucalyptus.auth.checker.InvalidValueException;
import com.eucalyptus.auth.checker.ValueChecker;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.HashSet;

public class ValueCheckerFactory {
    public static final HashSet<Character> USERGROUPNAME_EXTRA = new HashSet<Character>(Arrays.asList(Character.valueOf('+'), Character.valueOf('='), Character.valueOf(','), Character.valueOf('.'), Character.valueOf('@'), Character.valueOf('-')));
    public static final HashSet<Character> USERGROUPNAME_AD = new HashSet<Character>(Arrays.asList(Character.valueOf('_'), Character.valueOf(' ')));
    public static final String INVALID_USERGROUPNAME_CHARSET_REGEX = "[^a-zA-Z0-9+=,.@\\-_ ]";
    public static final String INVALID_ACCOUNTNAME_CHARSET_REGEX = "[^a-z0-9\\-]";
    public static final HashSet<Character> POLICYNAME_EXCLUDE = new HashSet<Character>(Arrays.asList(Character.valueOf('/'), Character.valueOf('\\'), Character.valueOf('*'), Character.valueOf('?'), Character.valueOf(' ')));
    public static final HashSet<Character> PASSWORD_SPECIAL = new HashSet<Character>(Arrays.asList(Character.valueOf('`'), Character.valueOf('~'), Character.valueOf('!'), Character.valueOf('@'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('^'), Character.valueOf('&'), Character.valueOf('*'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('-'), Character.valueOf('_'), Character.valueOf('='), Character.valueOf('+'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('\\'), Character.valueOf('|'), Character.valueOf(';'), Character.valueOf(':'), Character.valueOf('\''), Character.valueOf('\"'), Character.valueOf(','), Character.valueOf('.'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('/'), Character.valueOf('?')));
    public static final HashSet<Character> NAME_SEPARATORS = new HashSet<Character>(Arrays.asList(Character.valueOf(';')));
    public static final String PASSWORDS_NOT_MATCH = "Passwords do not match";
    public static final String PASSWORD_NOT_CHANGED = "New password must not be the same as old password";
    public static final int PASSWORD_MINIMAL_LENGTH = 6;

    public static ValueChecker createNonEmptyValueChecker() {
        return new ValueChecker(){

            @Override
            public String check(String value) throws InvalidValueException {
                if (Strings.isNullOrEmpty((String)value)) {
                    throw new InvalidValueException("Content can not be empty");
                }
                return value;
            }
        };
    }

    public static ValueSaver createValueSaver() {
        return new ValueSaver();
    }

    public static ValueChecker createEqualityChecker(final String errorMessage, ValueSaver valueSaver) {
        return new SavedValueChecker(valueSaver){

            @Override
            public String check(String value, String savedValue) throws InvalidValueException {
                if (!Strings.nullToEmpty((String)savedValue).equals(value)) {
                    throw new InvalidValueException(errorMessage);
                }
                return value;
            }
        };
    }

    public static ValueChecker createInequalityChecker(final String errorMessage, ValueSaver valueSaver) {
        return new SavedValueChecker(valueSaver){

            @Override
            public String check(String value, String savedValue) throws InvalidValueException {
                if (Strings.nullToEmpty((String)savedValue).equals(value)) {
                    throw new InvalidValueException(errorMessage);
                }
                return value;
            }
        };
    }

    public static ValueChecker createAccountNameChecker() {
        return new ValueChecker(){

            @Override
            public String check(String value) throws InvalidValueException {
                if (Strings.isNullOrEmpty((String)value)) {
                    throw new InvalidValueException("Account name can not be empty");
                }
                if (value.startsWith("-")) {
                    throw new InvalidValueException("Account name can not start with hyphen");
                }
                if (value.contains("--")) {
                    throw new InvalidValueException("Account name can not have two consecutive hyphens");
                }
                for (int i = 0; i < value.length(); ++i) {
                    char c = value.charAt(i);
                    if ((Character.isLetterOrDigit(c) || c == '-') && !Character.isUpperCase(c)) continue;
                    throw new InvalidValueException("Containing invalid character for account name: " + c);
                }
                return value;
            }
        };
    }

    public static ValueChecker createUserAndGroupNamesChecker() {
        return new ValueChecker(){

            @Override
            public String check(String value) throws InvalidValueException {
                if (Strings.isNullOrEmpty((String)value)) {
                    throw new InvalidValueException("User or group names can not be empty");
                }
                for (int i = 0; i < value.length(); ++i) {
                    char c = value.charAt(i);
                    if (Character.isLetterOrDigit(c) || USERGROUPNAME_EXTRA.contains(Character.valueOf(c)) || USERGROUPNAME_AD.contains(Character.valueOf(c)) || NAME_SEPARATORS.contains(Character.valueOf(c))) continue;
                    throw new InvalidValueException("Containing invalid character for user or group names: " + c);
                }
                return value;
            }
        };
    }

    public static ValueChecker createUserAndGroupNameChecker() {
        return new ValueChecker(){

            @Override
            public String check(String value) throws InvalidValueException {
                if (Strings.isNullOrEmpty((String)value)) {
                    throw new InvalidValueException("User or group name can not be empty");
                }
                for (int i = 0; i < value.length(); ++i) {
                    char c = value.charAt(i);
                    if (Character.isLetterOrDigit(c) || USERGROUPNAME_EXTRA.contains(Character.valueOf(c)) || USERGROUPNAME_AD.contains(Character.valueOf(c))) continue;
                    throw new InvalidValueException("Containing invalid character for user or group name: " + c);
                }
                return value;
            }
        };
    }

    public static ValueChecker createPathChecker() {
        return new ValueChecker(){

            @Override
            public String check(String value) throws InvalidValueException {
                if (value == null || value != null && !value.startsWith("/")) {
                    throw new InvalidValueException("Path must start with /");
                }
                for (int i = 0; i < value.length(); ++i) {
                    char c = value.charAt(i);
                    if (c >= '!' && c <= '~') continue;
                    throw new InvalidValueException("Invalid path character: " + c);
                }
                return value;
            }
        };
    }

    public static ValueChecker createPolicyNameChecker() {
        return new ValueChecker(){

            @Override
            public String check(String value) throws InvalidValueException {
                if (Strings.isNullOrEmpty((String)value)) {
                    throw new InvalidValueException("User or group names can not be empty");
                }
                for (int i = 0; i < value.length(); ++i) {
                    char c = value.charAt(i);
                    if (!POLICYNAME_EXCLUDE.contains(Character.valueOf(c))) continue;
                    throw new InvalidValueException("Containing invalid character for user or group names: " + c);
                }
                return value;
            }
        };
    }

    public static ValueChecker createPasswordChecker() {
        return new ValueChecker(){

            @Override
            public String check(String value) throws InvalidValueException {
                if (Strings.isNullOrEmpty((String)value)) {
                    throw new InvalidValueException("Password can not be empty");
                }
                int digit = 0;
                int lowerCase = 0;
                int upperCase = 0;
                int special = 0;
                for (int i = 0; i < value.length(); ++i) {
                    char c = value.charAt(i);
                    if (Character.isDigit(c)) {
                        ++digit;
                        continue;
                    }
                    if (Character.isLetter(c) && Character.isLowerCase(c)) {
                        ++lowerCase;
                        continue;
                    }
                    if (Character.isLetter(c) && Character.isUpperCase(c)) {
                        ++upperCase;
                        continue;
                    }
                    if (!PASSWORD_SPECIAL.contains(Character.valueOf(c))) continue;
                    ++special;
                }
                int length = value.length();
                if (length < 6) {
                    throw new InvalidValueException("Password length must be at least 6 characters");
                }
                int score = 1;
                if (length >= 12) {
                    score += 4;
                } else if (length >= 8) {
                    score += 2;
                }
                if (lowerCase > 0 && upperCase > 0) {
                    ++score;
                }
                if (digit > 1) {
                    score += 2;
                } else if (digit > 0) {
                    ++score;
                }
                if (special > 1) {
                    score += 3;
                } else if (special > 0) {
                    score += 2;
                }
                if (score < 2) {
                    return "weak";
                }
                if (score < 4) {
                    return "medium";
                }
                if (score < 6) {
                    return "strong";
                }
                return "stronger";
            }
        };
    }

    public static ValueChecker createEmailChecker() {
        return new ValueChecker(){

            @Override
            public String check(String value) throws InvalidValueException {
                if (Strings.isNullOrEmpty((String)value)) {
                    throw new InvalidValueException("Email address can not be empty");
                }
                String[] parts = value.split("@");
                if (parts.length < 2 || Strings.isNullOrEmpty((String)parts[0]) || Strings.isNullOrEmpty((String)parts[1])) {
                    throw new InvalidValueException("Does not look like a valid email address: missing user or host");
                }
                if (value.split("\\s+").length > 1) {
                    throw new InvalidValueException("Email address can not have spaces");
                }
                return value;
            }
        };
    }

    public static ValueChecker checkerForAll(final ValueChecker ... checkers) {
        return new ValueChecker(){

            @Override
            public String check(String value) throws InvalidValueException {
                String currentValue = value;
                for (ValueChecker checker : checkers) {
                    currentValue = checker == null ? value : checker.check(value);
                }
                return currentValue;
            }
        };
    }

    public static abstract class SavedValueChecker
    implements ValueChecker {
        private final ValueSaver valueSaver;

        public SavedValueChecker(ValueSaver valueSaver) {
            this.valueSaver = valueSaver;
        }

        @Override
        public final String check(String value) throws InvalidValueException {
            return this.check(value, this.valueSaver.getValue());
        }

        protected abstract String check(String var1, String var2) throws InvalidValueException;
    }

    public static class ValueSaver
    implements ValueChecker {
        private String value;

        ValueSaver() {
        }

        String getValue() {
            return this.value;
        }

        @Override
        public String check(String value) throws InvalidValueException {
            this.value = value;
            return this.value;
        }
    }
}

