/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.ServerCertificate;
import com.eucalyptus.auth.entities.ServerCertificateEntity;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.component.auth.SystemCredentials;
import com.eucalyptus.component.id.Euare;
import com.eucalyptus.crypto.Ciphers;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.crypto.util.PEMFiles;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.NoSuchElementException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.util.encoders.Base64;

public class ServerCertificates {
    public static boolean isCertValid(String certBody, String pk, String certChain) {
        try {
            X509Certificate cert = PEMFiles.getCert((byte[])certBody.getBytes(Charsets.UTF_8));
            if (cert == null) {
                throw new EucalyptusCloudException("Malformed cert");
            }
            KeyPair kp = PEMFiles.getKeyPair((byte[])pk.getBytes(Charsets.UTF_8));
            if (kp == null) {
                throw new EucalyptusCloudException("Malformed pk");
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static void updateServerCertificate(OwnerFullName user, String certName, String newCertName, String newCertPath) throws NoSuchElementException, AuthException {
        try (TransactionResource db = Entities.transactionFor(ServerCertificateEntity.class);){
            ServerCertificateEntity found = (ServerCertificateEntity)((Object)Entities.uniqueResult((Object)((Object)ServerCertificateEntity.named(user, certName))));
            try {
                if (newCertName != null && newCertName.length() > 0 && !certName.equals(newCertName)) {
                    found.setCertName(newCertName);
                }
            }
            catch (Exception ex) {
                throw new AuthException("Server certificate name is invalid");
            }
            try {
                if (newCertPath != null && newCertPath.length() > 0) {
                    found.setCertPath(newCertPath);
                }
            }
            catch (Exception ex) {
                throw new AuthException("Server certificate path is invalid");
            }
            Entities.persist((Object)((Object)found));
            db.commit();
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public static enum ToServerCertificate implements Function<ServerCertificateEntity, ServerCertificate>
    {
        INSTANCE;


        public ServerCertificate apply(ServerCertificateEntity entity) {
            try {
                ServerCertificate cert = new ServerCertificate(Accounts.lookupAccountById((String)entity.getOwnerAccountNumber()), entity.getCertName(), entity.getCreationTimestamp());
                cert.setCertificatePath(entity.getCertPath());
                cert.setCertificateBody(entity.getCertBody());
                cert.setCertificateChain(entity.getCertChain());
                cert.setCertificateId(entity.getCertId());
                byte[] encText = Base64.decode((String)entity.getPrivateKey());
                byte[] iv = Arrays.copyOfRange(encText, 0, 32);
                byte[] encPk = Arrays.copyOfRange(encText, 32, encText.length);
                byte[] symKeyWrapped = Base64.decode((String)entity.getSessionKey());
                PrivateKey euarePk = SystemCredentials.lookup(Euare.class).getPrivateKey();
                Cipher cipher = Ciphers.RSA_PKCS1.get();
                cipher.init(4, (Key)euarePk, (SecureRandom)Crypto.getSecureRandomSupplier().get());
                SecretKey sessionKey = (SecretKey)cipher.unwrap(symKeyWrapped, "AES/GCM/NoPadding", 3);
                cipher = Ciphers.AES_GCM.get();
                cipher.init(2, (Key)sessionKey, new IvParameterSpec(iv), (SecureRandom)Crypto.getSecureRandomSupplier().get());
                cert.setPrivateKey(new String(cipher.doFinal(encPk)));
                return cert;
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    @RestrictedTypes.Resolver(value=ServerCertificateEntity.class)
    public static enum Lookup implements Function<String, ServerCertificateEntity>
    {
        INSTANCE;


        public ServerCertificateEntity apply(String arn) {
            try {
                if (!arn.startsWith("arn:aws:iam::")) {
                    throw new EucalyptusCloudException("malformed arn");
                }
                String token = arn.substring("arn:aws:iam::".length());
                String acctId = token.substring(0, token.indexOf(":server-certificate"));
                Account acct = Accounts.lookupAccountById((String)acctId);
                User adminUser = acct.lookupAdmin();
                String prefix = String.format("arn:aws:iam::%s:server-certificate", acctId);
                if (!arn.startsWith(prefix)) {
                    throw new EucalyptusCloudException("malformed arn");
                }
                String pathAndName = arn.replace(prefix, "");
                String certName = pathAndName.substring(pathAndName.lastIndexOf("/") + 1);
                ServerCertificateEntity found = null;
                try (TransactionResource db2 = Entities.transactionFor(ServerCertificateEntity.class);){
                    found = (ServerCertificateEntity)((Object)Entities.uniqueResult((Object)((Object)ServerCertificateEntity.named((OwnerFullName)UserFullName.getInstance((User)adminUser, (String[])new String[0]), certName))));
                    db2.rollback();
                }
                catch (NoSuchElementException db2) {
                }
                catch (Exception ex) {
                    throw ex;
                }
                return found;
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }
}

