/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.AuthenticationLimitProvider;
import com.eucalyptus.auth.LdapException;
import com.eucalyptus.auth.ldap.LdapSync;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.crypto.Crypto;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import javax.security.auth.login.CredentialExpiredException;

public class PasswordAuthentication {
    public static final String INVALID_USERNAME_OR_PASSWORD = "Invalid username or password";
    public static final String PASSWORD_CHANGE_NOT_SUPPORTED = "Changing password is not supported for this user";

    public static void authenticate(User user, String password) throws AuthException, CredentialExpiredException {
        boolean checkExpiration = true;
        if (PasswordAuthentication.authenticateWithLdap(user)) {
            try {
                LdapSync.authenticate(user, password);
                checkExpiration = false;
            }
            catch (LdapException e) {
                throw new AuthException(INVALID_USERNAME_OR_PASSWORD);
            }
        } else if (!Crypto.verifyPassword((String)password, (String)user.getPassword())) {
            throw new AuthException(INVALID_USERNAME_OR_PASSWORD);
        }
        if (checkExpiration) {
            PasswordAuthentication.checkPasswordExpiration(user);
        }
    }

    public static boolean authenticateWithLdap(User user) {
        return LdapSync.enabled() && !user.isSystemAdmin() && !user.isAccountAdmin();
    }

    public static void authenticate(User user, String password, String newPassword) throws AuthException, CredentialExpiredException {
        if (newPassword == null) {
            PasswordAuthentication.authenticate(user, password);
        } else {
            if (PasswordAuthentication.authenticateWithLdap(user)) {
                throw new AuthException(PASSWORD_CHANGE_NOT_SUPPORTED);
            }
            try {
                PasswordAuthentication.authenticate(user, password);
                PasswordAuthentication.updatePassword(user, newPassword);
            }
            catch (CredentialExpiredException ex) {
                PasswordAuthentication.updatePassword(user, newPassword);
            }
        }
    }

    private static void updatePassword(User user, String newPassword) throws AuthException {
        if (Strings.isNullOrEmpty((String)newPassword) || user.getName().equals(newPassword)) {
            throw new AuthException("Invalid password");
        }
        String newEncrypted = Crypto.generateEncryptedPassword((String)newPassword);
        user.setPassword(newEncrypted);
        user.setPasswordExpires(Long.valueOf(System.currentTimeMillis() + AuthenticationLimitProvider.Values.getDefaultPasswordExpiry()));
    }

    private static void checkPasswordExpiration(User user) throws CredentialExpiredException {
        if ((Long)Objects.firstNonNull((Object)user.getPasswordExpires(), (Object)Long.MAX_VALUE) < System.currentTimeMillis()) {
            throw new CredentialExpiredException();
        }
    }
}

