/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.DatabaseAccessKeyProxy;
import com.eucalyptus.auth.DatabaseAccountProxy;
import com.eucalyptus.auth.DatabaseAuthUtils;
import com.eucalyptus.auth.DatabaseAuthorizationProxy;
import com.eucalyptus.auth.DatabaseCertificateProxy;
import com.eucalyptus.auth.DatabaseGroupProxy;
import com.eucalyptus.auth.DatabasePolicyProxy;
import com.eucalyptus.auth.Debugging;
import com.eucalyptus.auth.PolicyParseException;
import com.eucalyptus.auth.checker.InvalidValueException;
import com.eucalyptus.auth.checker.ValueChecker;
import com.eucalyptus.auth.checker.ValueCheckerFactory;
import com.eucalyptus.auth.entities.AccessKeyEntity;
import com.eucalyptus.auth.entities.AccountEntity;
import com.eucalyptus.auth.entities.AuthorizationEntity;
import com.eucalyptus.auth.entities.CertificateEntity;
import com.eucalyptus.auth.entities.ConditionEntity;
import com.eucalyptus.auth.entities.GroupEntity;
import com.eucalyptus.auth.entities.PolicyEntity;
import com.eucalyptus.auth.entities.StatementEntity;
import com.eucalyptus.auth.entities.UserEntity;
import com.eucalyptus.auth.policy.PolicyParser;
import com.eucalyptus.auth.principal.AccessKey;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.AccountScopedPrincipal;
import com.eucalyptus.auth.principal.Authorization;
import com.eucalyptus.auth.principal.Certificate;
import com.eucalyptus.auth.principal.Group;
import com.eucalyptus.auth.principal.Policy;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.auth.util.X509CertHelper;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.util.Tx;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class DatabaseUserProxy
implements User {
    private static final long serialVersionUID = 1L;
    private static Logger LOG = Logger.getLogger(DatabaseUserProxy.class);
    private static final ValueChecker NAME_CHECKER = ValueCheckerFactory.createUserAndGroupNameChecker();
    private static final ValueChecker PATH_CHECKER = ValueCheckerFactory.createPathChecker();
    private static final ValueChecker POLICY_NAME_CHECKER = ValueCheckerFactory.createPolicyNameChecker();
    private UserEntity delegate;
    private transient Supplier<String> accountNumberSupplier = DatabaseAuthUtils.getAccountNumberSupplier((AccountScopedPrincipal)this);
    private transient Supplier<Map<String, String>> userInfoSupplier = this.getUserInfoSupplier();
    private transient Boolean isSystemAdmin = null;

    public DatabaseUserProxy(UserEntity delegate) {
        this.delegate = delegate;
    }

    public DatabaseUserProxy(UserEntity delegate, String accountNumber) {
        this.delegate = delegate;
        this.accountNumberSupplier = Suppliers.ofInstance((Object)accountNumber);
    }

    public DatabaseUserProxy(UserEntity delegate, String accountNumber, Map<String, String> info) {
        this.delegate = delegate;
        this.accountNumberSupplier = Suppliers.ofInstance((Object)accountNumber);
        this.userInfoSupplier = Suppliers.ofInstance(info);
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        try {
            DatabaseAuthUtils.invokeUnique(UserEntity.class, "userId", this.delegate.getUserId(), new Tx<UserEntity>(){

                public void fire(UserEntity t) {
                    sb.append(t.toString());
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to toString for " + this.delegate);
        }
        return sb.toString();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getUserId() {
        return this.delegate.getUserId();
    }

    public void setName(String name) throws AuthException {
        try {
            NAME_CHECKER.check(name);
        }
        catch (InvalidValueException e) {
            Debugging.logError(LOG, e, "Invalid user name " + name);
            throw new AuthException("Invalid name", (Throwable)e);
        }
        try {
            this.getAccount().lookupUserByName(name);
        }
        catch (AuthException e) {
            try (TransactionResource db = Entities.transactionFor(UserEntity.class);){
                UserEntity user = DatabaseAuthUtils.getUnique(UserEntity.class, "userId", this.delegate.getUserId());
                user.setName(name);
                for (GroupEntity g : user.getGroups()) {
                    if (!g.isUserGroup().booleanValue()) continue;
                    g.setName(DatabaseAuthUtils.getUserGroupName(name));
                    break;
                }
                db.commit();
            }
            catch (Exception t) {
                Debugging.logError(LOG, t, "Failed to setName for " + this.delegate);
                throw new AuthException((Throwable)t);
            }
            return;
        }
        throw new AuthException("User already exists");
    }

    public String getPath() {
        return this.delegate.getPath();
    }

    public void setPath(final String path) throws AuthException {
        try {
            PATH_CHECKER.check(path);
        }
        catch (InvalidValueException e) {
            Debugging.logError(LOG, e, "Invalid path " + path);
            throw new AuthException("Invalid path", (Throwable)e);
        }
        try {
            DatabaseAuthUtils.invokeUnique(UserEntity.class, "userId", this.delegate.getUserId(), new Tx<UserEntity>(){

                public void fire(UserEntity t) {
                    t.setPath(path);
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to setPath for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
    }

    public Date getCreateDate() {
        return this.delegate.getCreationTimestamp();
    }

    public User.RegistrationStatus getRegistrationStatus() {
        return this.delegate.getRegistrationStatus();
    }

    public void setRegistrationStatus(final User.RegistrationStatus stat) throws AuthException {
        try {
            DatabaseAuthUtils.invokeUnique(UserEntity.class, "userId", this.delegate.getUserId(), new Tx<UserEntity>(){

                public void fire(UserEntity t) {
                    t.setRegistrationStatus(stat);
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to setRegistrationStatus for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
    }

    public Boolean isEnabled() {
        return this.delegate.isEnabled();
    }

    public void setEnabled(final Boolean enabled) throws AuthException {
        try {
            DatabaseAuthUtils.invokeUnique(UserEntity.class, "userId", this.delegate.getUserId(), new Tx<UserEntity>(){

                public void fire(UserEntity t) {
                    t.setEnabled(enabled);
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to setEnabled for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
    }

    public String getToken() {
        return this.delegate.getToken();
    }

    public void setToken(final String token) throws AuthException {
        try {
            DatabaseAuthUtils.invokeUnique(UserEntity.class, "userId", this.delegate.getUserId(), new Tx<UserEntity>(){

                public void fire(UserEntity t) {
                    t.setToken(token);
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to setToken for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
    }

    public String resetToken() throws AuthException {
        String original = this.delegate.getToken();
        this.setToken(Crypto.generateSessionToken());
        return original;
    }

    public String getConfirmationCode() {
        return this.delegate.getConfirmationCode();
    }

    public void setConfirmationCode(final String code) throws AuthException {
        try {
            DatabaseAuthUtils.invokeUnique(UserEntity.class, "userId", this.delegate.getUserId(), new Tx<UserEntity>(){

                public void fire(UserEntity t) {
                    t.setConfirmationCode(code);
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to setConfirmationCode for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
    }

    public void createConfirmationCode() throws AuthException {
        this.setConfirmationCode(Crypto.generateSessionToken());
    }

    public String getPassword() {
        return this.delegate.getPassword();
    }

    public void setPassword(final String password) throws AuthException {
        try {
            DatabaseAuthUtils.invokeUnique(UserEntity.class, "userId", this.delegate.getUserId(), new Tx<UserEntity>(){

                public void fire(UserEntity t) {
                    t.setPassword(password);
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to setPassword for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
    }

    public Long getPasswordExpires() {
        return this.delegate.getPasswordExpires();
    }

    public void setPasswordExpires(final Long time) throws AuthException {
        try {
            DatabaseAuthUtils.invokeUnique(UserEntity.class, "userId", this.delegate.getUserId(), new Tx<UserEntity>(){

                public void fire(UserEntity t) {
                    t.setPasswordExpires(time);
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to setPasswordExpires for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
    }

    public String getInfo(String key) throws AuthException {
        return DatabaseAuthUtils.extract(this.userInfoSupplier).get(key.toLowerCase());
    }

    public Map<String, String> getInfo() throws AuthException {
        return DatabaseAuthUtils.extract(this.userInfoSupplier);
    }

    public void setInfo(final String key, final String value) throws AuthException {
        if (Strings.isNullOrEmpty((String)key)) {
            throw new AuthException("Empty key");
        }
        try {
            DatabaseAuthUtils.invokeUnique(UserEntity.class, "userId", this.delegate.getUserId(), new Tx<UserEntity>(){

                public void fire(UserEntity t) {
                    t.getInfo().put(key.toLowerCase(), value);
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to setInfo for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
    }

    public void removeInfo(final String key) throws AuthException {
        if (Strings.isNullOrEmpty((String)key)) {
            throw new AuthException("Empty key");
        }
        try {
            DatabaseAuthUtils.invokeUnique(UserEntity.class, "userId", this.delegate.getUserId(), new Tx<UserEntity>(){

                public void fire(UserEntity t) {
                    t.getInfo().remove(key.toLowerCase());
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to removeInfo for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
    }

    public void setInfo(final Map<String, String> newInfo) throws AuthException {
        if (newInfo == null) {
            throw new AuthException("Empty user info map");
        }
        try {
            DatabaseAuthUtils.invokeUnique(UserEntity.class, "userId", this.delegate.getUserId(), new Tx<UserEntity>(){

                public void fire(UserEntity t) {
                    t.getInfo().clear();
                    for (Map.Entry entry : newInfo.entrySet()) {
                        t.getInfo().put(((String)entry.getKey()).toLowerCase(), (String)entry.getValue());
                    }
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to setInfo for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
    }

    public List<AccessKey> getKeys() throws AuthException {
        final ArrayList results = Lists.newArrayList();
        try {
            DatabaseAuthUtils.invokeUnique(UserEntity.class, "userId", this.delegate.getUserId(), new Tx<UserEntity>(){

                public void fire(UserEntity t) {
                    for (AccessKeyEntity k : t.getKeys()) {
                        results.add(new DatabaseAccessKeyProxy(k));
                    }
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to getKeys for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
        return results;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccessKey getKey(String keyId) throws AuthException {
        try (TransactionResource db = Entities.transactionFor(AccessKeyEntity.class);){
            AccessKeyEntity key = DatabaseAuthUtils.getUnique(AccessKeyEntity.class, "accessKey", keyId);
            db.commit();
            DatabaseAccessKeyProxy databaseAccessKeyProxy = new DatabaseAccessKeyProxy(key);
            return databaseAccessKeyProxy;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to get access key " + keyId);
            throw new AuthException("No such access key");
        }
    }

    public void removeKey(String keyId) throws AuthException {
        if (Strings.isNullOrEmpty((String)keyId)) {
            throw new AuthException("Empty access key id");
        }
        try (TransactionResource db = Entities.transactionFor(UserEntity.class);){
            UserEntity user = DatabaseAuthUtils.getUnique(UserEntity.class, "userId", this.delegate.getUserId());
            AccessKeyEntity keyEntity = DatabaseAuthUtils.getUnique(AccessKeyEntity.class, "accessKey", keyId);
            user.getKeys().remove(keyEntity);
            Entities.delete((Object)keyEntity);
            db.commit();
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to get delete key " + keyId);
            throw new AuthException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccessKey createKey() throws AuthException {
        try (TransactionResource db = Entities.transactionFor(UserEntity.class);){
            UserEntity user = DatabaseAuthUtils.getUnique(UserEntity.class, "userId", this.delegate.getUserId());
            AccessKeyEntity keyEntity = new AccessKeyEntity(user);
            keyEntity.setActive(true);
            Entities.persist((Object)keyEntity);
            user.getKeys().add(keyEntity);
            db.commit();
            DatabaseAccessKeyProxy databaseAccessKeyProxy = new DatabaseAccessKeyProxy(keyEntity);
            return databaseAccessKeyProxy;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to get create new access key: " + e.getMessage());
            throw new AuthException((Throwable)e);
        }
    }

    public List<Certificate> getCertificates() throws AuthException {
        final ArrayList results = Lists.newArrayList();
        try {
            DatabaseAuthUtils.invokeUnique(UserEntity.class, "userId", this.delegate.getUserId(), new Tx<UserEntity>(){

                public void fire(UserEntity t) {
                    for (CertificateEntity c : t.getCertificates()) {
                        results.add(new DatabaseCertificateProxy(c));
                    }
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to getCertificates for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
        return results;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Certificate getCertificate(String certificateId) throws AuthException {
        try (TransactionResource db = Entities.transactionFor(CertificateEntity.class);){
            CertificateEntity cert = DatabaseAuthUtils.getUnique(CertificateEntity.class, "certificateId", certificateId);
            db.commit();
            DatabaseCertificateProxy databaseCertificateProxy = new DatabaseCertificateProxy(cert);
            return databaseCertificateProxy;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to get signing certificate " + certificateId);
            throw new AuthException("No such certificate");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Certificate addCertificate(X509Certificate cert) throws AuthException {
        try (TransactionResource db = Entities.transactionFor(UserEntity.class);){
            UserEntity user = DatabaseAuthUtils.getUnique(UserEntity.class, "userId", this.delegate.getUserId());
            CertificateEntity certEntity = new CertificateEntity(X509CertHelper.fromCertificate((X509Certificate)cert));
            certEntity.setActive(true);
            certEntity.setRevoked(false);
            Entities.persist((Object)certEntity);
            certEntity.setUser(user);
            user.getCertificates().add(certEntity);
            db.commit();
            DatabaseCertificateProxy databaseCertificateProxy = new DatabaseCertificateProxy(certEntity);
            return databaseCertificateProxy;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to get add certificate " + cert);
            throw new AuthException((Throwable)e);
        }
    }

    public void removeCertificate(String certificateId) throws AuthException {
        if (Strings.isNullOrEmpty((String)certificateId)) {
            throw new AuthException("Empty certificate id");
        }
        try (TransactionResource db = Entities.transactionFor(CertificateEntity.class);){
            CertificateEntity certificateEntity = DatabaseAuthUtils.getUnique(CertificateEntity.class, "certificateId", certificateId);
            certificateEntity.setRevoked(true);
            db.commit();
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to get delete certificate " + certificateId);
            throw new AuthException((Throwable)e);
        }
    }

    public List<Group> getGroups() throws AuthException {
        final ArrayList results = Lists.newArrayList();
        try {
            DatabaseAuthUtils.invokeUnique(UserEntity.class, "userId", this.delegate.getUserId(), new Tx<UserEntity>(){

                public void fire(UserEntity t) {
                    for (GroupEntity g : t.getGroups()) {
                        results.add(new DatabaseGroupProxy(g));
                    }
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to getGroups for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
        return results;
    }

    public String getAccountNumber() throws AuthException {
        return DatabaseAuthUtils.extract(this.accountNumberSupplier);
    }

    public Account getAccount() throws AuthException {
        final ArrayList results = Lists.newArrayList();
        try {
            DatabaseAuthUtils.invokeUnique(UserEntity.class, "userId", this.delegate.getUserId(), new Tx<UserEntity>(){

                public void fire(UserEntity t) {
                    if (t.getGroups().size() < 1) {
                        throw new RuntimeException("Unexpected group number of the user");
                    }
                    AccountEntity account = t.getGroups().get(0).getAccount();
                    Entities.initialize((Object)account);
                    results.add(new DatabaseAccountProxy(account));
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to getAccount for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
        return (Account)results.get(0);
    }

    public boolean isSystemAdmin() {
        if (this.isSystemAdmin != null) {
            return this.isSystemAdmin;
        }
        try {
            Account account = this.getAccount();
            this.accountNumberSupplier = Suppliers.ofInstance((Object)account.getAccountNumber());
            this.isSystemAdmin = Accounts.isSystemAccount((String)account.getName());
            return this.isSystemAdmin;
        }
        catch (AuthException e) {
            LOG.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public boolean isSystemUser() {
        return this.isSystemAdmin();
    }

    public boolean isAccountAdmin() {
        return DatabaseAuthUtils.isAccountAdmin(this.getName());
    }

    private GroupEntity getUserGroupEntity(UserEntity userEntity) {
        GroupEntity groupEntity = null;
        for (GroupEntity g : userEntity.getGroups()) {
            if (!g.isUserGroup().booleanValue()) continue;
            groupEntity = g;
            break;
        }
        return groupEntity;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Policy> getPolicies() throws AuthException {
        ArrayList results = Lists.newArrayList();
        try (TransactionResource db = Entities.transactionFor(UserEntity.class);){
            UserEntity user = DatabaseAuthUtils.getUnique(UserEntity.class, "userId", this.delegate.getUserId());
            GroupEntity group = this.getUserGroupEntity(user);
            if (group == null) {
                throw new RuntimeException("Can't find user group for user " + this.delegate.getName());
            }
            for (PolicyEntity p : group.getPolicies()) {
                results.add(new DatabasePolicyProxy(p));
            }
            db.commit();
            ArrayList arrayList = results;
            return arrayList;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to get policies for " + this.delegate);
            throw new AuthException("Failed to get policies", (Throwable)e);
        }
    }

    public Policy addPolicy(String name, String policy) throws AuthException, PolicyParseException {
        return this.storePolicy(name, policy, false);
    }

    public Policy putPolicy(String name, String policy) throws AuthException, PolicyParseException {
        return this.storePolicy(name, policy, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Policy storePolicy(String name, String policy, boolean allowUpdate) throws AuthException, PolicyParseException {
        try {
            POLICY_NAME_CHECKER.check(name);
        }
        catch (InvalidValueException e) {
            Debugging.logError(LOG, e, "Invalid policy name " + name);
            throw new AuthException("Invalid name", (Throwable)e);
        }
        if (DatabaseAuthUtils.policyNameinList(name, this.getPolicies()) && !allowUpdate) {
            Debugging.logError(LOG, null, "Policy name already used: " + name);
            throw new AuthException("Invalid name");
        }
        PolicyEntity parsedPolicy = PolicyParser.getInstance().parse(policy);
        if (this.isAccountAdmin() && parsedPolicy.containsAllowEffect()) {
            throw new PolicyParseException("Policy with Allow effect can not be assigned to account/account admin");
        }
        parsedPolicy.setName(name);
        try (TransactionResource db = Entities.transactionFor(UserEntity.class);){
            UserEntity userEntity = DatabaseAuthUtils.getUnique(UserEntity.class, "userId", this.delegate.getUserId());
            GroupEntity groupEntity = this.getUserGroupEntity(userEntity);
            if (groupEntity == null) {
                throw new RuntimeException("Can't find user group for user " + this.delegate.getName());
            }
            PolicyEntity remove = DatabaseAuthUtils.removeGroupPolicy(groupEntity, name);
            if (remove != null) {
                Entities.delete((Object)remove);
            }
            Entities.persist((Object)parsedPolicy);
            parsedPolicy.setGroup(groupEntity);
            for (StatementEntity statement : parsedPolicy.getStatements()) {
                Entities.persist((Object)statement);
                statement.setPolicy(parsedPolicy);
                for (AuthorizationEntity auth : statement.getAuthorizations()) {
                    Entities.persist((Object)auth);
                    auth.setStatement(statement);
                }
                for (ConditionEntity cond : statement.getConditions()) {
                    Entities.persist((Object)cond);
                    cond.setStatement(statement);
                }
            }
            groupEntity.getPolicies().add(parsedPolicy);
            db.commit();
            DatabasePolicyProxy databasePolicyProxy = new DatabasePolicyProxy(parsedPolicy);
            return databasePolicyProxy;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to attach policy for " + this.delegate.getName());
            throw new AuthException("Failed to attach policy", (Throwable)e);
        }
    }

    public void removePolicy(String name) throws AuthException {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new AuthException("Empty policy name");
        }
        try (TransactionResource db = Entities.transactionFor(UserEntity.class);){
            UserEntity user = DatabaseAuthUtils.getUnique(UserEntity.class, "userId", this.delegate.getUserId());
            GroupEntity group = this.getUserGroupEntity(user);
            if (group == null) {
                throw new RuntimeException("Can't find user group for user " + this.delegate.getName());
            }
            PolicyEntity policy = DatabaseAuthUtils.removeGroupPolicy(group, name);
            if (policy != null) {
                Entities.delete((Object)policy);
            }
            db.commit();
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to remove policy " + name + " in " + this.delegate);
            throw new AuthException("Failed to remove policy", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Authorization> lookupAuthorizations(String resourceType) throws AuthException {
        String userId = this.delegate.getUserId();
        try (TransactionResource db = Entities.transactionFor(AuthorizationEntity.class);){
            List authorizations = resourceType == null ? Entities.createCriteria(AuthorizationEntity.class).setCacheable(true).add((Criterion)Restrictions.eq((String)"effect", (Object)Authorization.EffectType.Allow)).createCriteria("statement").setCacheable(true).createCriteria("policy").setCacheable(true).createCriteria("group").setCacheable(true).createCriteria("users").setCacheable(true).add((Criterion)Restrictions.eq((String)"userId", (Object)userId)).list() : Entities.createCriteria(AuthorizationEntity.class).setCacheable(true).add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"type", (Object)resourceType), (Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"effect", (Object)Authorization.EffectType.Allow), (Criterion)Restrictions.eq((String)"effect", (Object)Authorization.EffectType.Deny)))).createCriteria("statement").setCacheable(true).createCriteria("policy").setCacheable(true).createCriteria("group").setCacheable(true).createCriteria("users").setCacheable(true).add((Criterion)Restrictions.eq((String)"userId", (Object)userId)).list();
            db.commit();
            ArrayList results = Lists.newArrayList();
            for (AuthorizationEntity auth : authorizations) {
                results.add(new DatabaseAuthorizationProxy(auth));
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to lookup authorization for user with ID " + userId + ", type=" + resourceType);
            throw new AuthException("Failed to lookup auth", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Authorization> lookupQuotas(String resourceType) throws AuthException {
        String userId = this.delegate.getUserId();
        try (TransactionResource db = Entities.transactionFor(AuthorizationEntity.class);){
            List authorizations = Entities.createCriteria(AuthorizationEntity.class).setCacheable(true).add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"type", (Object)resourceType), (Criterion)Restrictions.eq((String)"effect", (Object)Authorization.EffectType.Limit))).createCriteria("statement").setCacheable(true).createCriteria("policy").setCacheable(true).createCriteria("group").setCacheable(true).createCriteria("users").add((Criterion)Restrictions.eq((String)"userId", (Object)userId)).list();
            db.commit();
            ArrayList results = Lists.newArrayList();
            for (AuthorizationEntity auth : authorizations) {
                results.add(new DatabaseAuthorizationProxy(auth));
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to lookup quotas for user with ID " + userId + ", type=" + resourceType);
            throw new AuthException("Failed to lookup quota", (Throwable)e);
        }
    }

    private Supplier<Map<String, String>> getUserInfoSupplier() {
        return new Supplier<Map<String, String>>(){

            public Map<String, String> get() {
                final HashMap results = Maps.newHashMap();
                try {
                    DatabaseAuthUtils.invokeUnique(UserEntity.class, "userId", DatabaseUserProxy.this.delegate.getUserId(), new Tx<UserEntity>(){

                        public void fire(UserEntity t) {
                            results.putAll(t.getInfo());
                        }
                    });
                }
                catch (ExecutionException e) {
                    Debugging.logError(LOG, e, "Failed to getInfo for " + DatabaseUserProxy.this.delegate);
                    throw new RuntimeException(new AuthException((Throwable)e).fillInStackTrace());
                }
                return results;
            }
        };
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.accountNumberSupplier = DatabaseAuthUtils.getAccountNumberSupplier((AccountScopedPrincipal)this);
        this.userInfoSupplier = this.getUserInfoSupplier();
    }
}

