/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.DatabaseAccountProxy;
import com.eucalyptus.auth.DatabaseAuthUtils;
import com.eucalyptus.auth.DatabaseAuthorizationProxy;
import com.eucalyptus.auth.DatabaseInstanceProfileProxy;
import com.eucalyptus.auth.DatabasePolicyProxy;
import com.eucalyptus.auth.Debugging;
import com.eucalyptus.auth.PolicyParseException;
import com.eucalyptus.auth.checker.InvalidValueException;
import com.eucalyptus.auth.checker.ValueChecker;
import com.eucalyptus.auth.checker.ValueCheckerFactory;
import com.eucalyptus.auth.entities.AuthorizationEntity;
import com.eucalyptus.auth.entities.InstanceProfileEntity;
import com.eucalyptus.auth.entities.PolicyEntity;
import com.eucalyptus.auth.entities.RoleEntity;
import com.eucalyptus.auth.policy.PolicyParser;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.auth.principal.AccountScopedPrincipal;
import com.eucalyptus.auth.principal.Authorization;
import com.eucalyptus.auth.principal.InstanceProfile;
import com.eucalyptus.auth.principal.Policy;
import com.eucalyptus.auth.principal.Role;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.Tx;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class DatabaseRoleProxy
implements Role {
    private static final long serialVersionUID = 1L;
    private static Logger LOG = Logger.getLogger(DatabaseRoleProxy.class);
    private static final ValueChecker POLICY_NAME_CHECKER = ValueCheckerFactory.createPolicyNameChecker();
    private RoleEntity delegate;
    private transient Supplier<String> accountNumberSupplier = DatabaseAuthUtils.getAccountNumberSupplier((AccountScopedPrincipal)this);

    public DatabaseRoleProxy(RoleEntity delegate) {
        this.delegate = delegate;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public OwnerFullName getOwner() {
        try {
            return AccountFullName.getInstance((String)this.getAccount().getAccountNumber(), (String[])new String[0]);
        }
        catch (AuthException e) {
            throw Exceptions.toUndeclared((Throwable)e);
        }
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        try {
            DatabaseAuthUtils.invokeUnique(RoleEntity.class, "roleId", this.delegate.getRoleId(), new Tx<RoleEntity>(){

                public void fire(RoleEntity t) {
                    sb.append(t.toString());
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to toString for " + this.delegate);
        }
        return sb.toString();
    }

    public String getRoleId() {
        return this.delegate.getRoleId();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getPath() {
        return this.delegate.getPath();
    }

    public String getSecret() {
        return this.delegate.getSecret();
    }

    public Policy getPolicy() {
        try {
            return this.getAssumeRolePolicy();
        }
        catch (Exception e) {
            throw Exceptions.toUndeclared((Throwable)e);
        }
    }

    public Policy getAssumeRolePolicy() throws AuthException {
        final ArrayList results = Lists.newArrayList();
        this.dbCallback("getAssumeRolePolicy", new Callback<RoleEntity>(){

            public void fire(RoleEntity roleEntity) {
                results.add(new DatabasePolicyProxy(roleEntity.getAssumeRolePolicy()));
            }
        });
        return (Policy)results.get(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Policy setAssumeRolePolicy(String policy) throws AuthException, PolicyParseException {
        PolicyEntity parsedPolicy = PolicyParser.getResourceInstance().parse(policy);
        parsedPolicy.setName("assume-role-policy-for-" + this.getRoleId());
        try (TransactionResource db = Entities.transactionFor(RoleEntity.class);){
            RoleEntity roleEntity = this.getRoleEntity();
            PolicyEntity oldAssumeRolePolicy = roleEntity.getAssumeRolePolicy();
            roleEntity.setAssumeRolePolicy(parsedPolicy);
            Entities.delete((Object)oldAssumeRolePolicy);
            PolicyEntity persistedPolicyEntity = (PolicyEntity)Entities.persist((Object)parsedPolicy);
            db.commit();
            DatabasePolicyProxy databasePolicyProxy = new DatabasePolicyProxy(persistedPolicyEntity);
            return databasePolicyProxy;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to set assume role policy for " + this.delegate.getName());
            throw new AuthException("Failed to set assume role policy", (Throwable)e);
        }
    }

    public Date getCreationTimestamp() {
        return this.delegate.getCreationTimestamp();
    }

    public String getAccountNumber() throws AuthException {
        return DatabaseAuthUtils.extract(this.accountNumberSupplier);
    }

    public Account getAccount() throws AuthException {
        final ArrayList results = Lists.newArrayList();
        this.dbCallback("getAccount", new Callback<RoleEntity>(){

            public void fire(RoleEntity roleEntity) {
                results.add(new DatabaseAccountProxy(roleEntity.getAccount()));
            }
        });
        return (Account)results.get(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Policy> getPolicies() throws AuthException {
        ArrayList results = Lists.newArrayList();
        try (TransactionResource db = Entities.transactionFor(RoleEntity.class);){
            RoleEntity role = this.getRoleEntity();
            for (PolicyEntity policyEntity : role.getPolicies()) {
                results.add(new DatabasePolicyProxy(policyEntity));
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to get policies for " + this.delegate);
            throw new AuthException("Failed to get policies", (Throwable)e);
        }
    }

    public Policy addPolicy(String name, String policy) throws AuthException, PolicyParseException {
        return this.storePolicy(name, policy, false);
    }

    public Policy putPolicy(String name, String policy) throws AuthException, PolicyParseException {
        return this.storePolicy(name, policy, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Policy storePolicy(String name, String policy, boolean allowUpdate) throws AuthException, PolicyParseException {
        this.check(POLICY_NAME_CHECKER, "Invalid name", name);
        if (DatabaseAuthUtils.policyNameinList(name, this.getPolicies()) && !allowUpdate) {
            Debugging.logError(LOG, null, "Policy name already used: " + name);
            throw new AuthException("Invalid name");
        }
        PolicyEntity parsedPolicy = PolicyParser.getInstance().parse(policy);
        parsedPolicy.setName(name);
        try (TransactionResource db = Entities.transactionFor(RoleEntity.class);){
            RoleEntity roleEntity = this.getRoleEntity();
            PolicyEntity remove = DatabaseAuthUtils.removeNamedPolicy(roleEntity.getPolicies(), name);
            if (remove != null) {
                Entities.delete((Object)remove);
            }
            parsedPolicy.setRole(roleEntity);
            roleEntity.getPolicies().add(parsedPolicy);
            PolicyEntity persistedPolicyEntity = (PolicyEntity)Entities.persist((Object)parsedPolicy);
            db.commit();
            DatabasePolicyProxy databasePolicyProxy = new DatabasePolicyProxy(persistedPolicyEntity);
            return databasePolicyProxy;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to attach policy for " + this.delegate.getName());
            throw new AuthException("Failed to attach policy", (Throwable)e);
        }
    }

    public void removePolicy(String name) throws AuthException {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new AuthException("Empty policy name");
        }
        try (TransactionResource db = Entities.transactionFor(RoleEntity.class);){
            RoleEntity roleEntity = this.getRoleEntity();
            PolicyEntity policy = DatabaseAuthUtils.removeNamedPolicy(roleEntity.getPolicies(), name);
            if (policy != null) {
                Entities.delete((Object)policy);
            }
            db.commit();
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to remove policy " + name + " in " + this.delegate);
            throw new AuthException("Failed to remove policy", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<InstanceProfile> getInstanceProfiles() throws AuthException {
        ArrayList results = Lists.newArrayList();
        try (TransactionResource db = Entities.transactionFor(InstanceProfileEntity.class);){
            List instanceProfiles = Entities.createCriteria(InstanceProfileEntity.class).createCriteria("role").add((Criterion)Restrictions.eq((String)"name", (Object)this.delegate.getName())).setCacheable(true).list();
            for (InstanceProfileEntity instanceProfile : instanceProfiles) {
                results.add(new DatabaseInstanceProfileProxy(instanceProfile));
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to get instance profiles for " + this.delegate.getName());
            throw new AuthException("Failed to get instance profiles", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Authorization> lookupAuthorizations(String resourceType) throws AuthException {
        try (TransactionResource db = Entities.transactionFor(AuthorizationEntity.class);){
            List authorizations = resourceType == null ? Entities.createCriteria(AuthorizationEntity.class).add((Criterion)Restrictions.eq((String)"effect", (Object)Authorization.EffectType.Allow)).createCriteria("statement").createCriteria("policy").createCriteria("role").add((Criterion)Restrictions.eq((String)"roleId", (Object)this.getRoleId())).setCacheable(true).list() : Entities.createCriteria(AuthorizationEntity.class).add((Criterion)Restrictions.and((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"type", (Object)resourceType), (Criterion)Restrictions.eq((String)"type", (Object)"*")), (Criterion)Restrictions.in((String)"effect", EnumSet.of(Authorization.EffectType.Allow, Authorization.EffectType.Deny)))).createCriteria("statement").createCriteria("policy").createCriteria("role").add((Criterion)Restrictions.eq((String)"roleId", (Object)this.getRoleId())).setCacheable(true).list();
            ArrayList results = Lists.newArrayList();
            for (AuthorizationEntity auth : authorizations) {
                results.add(new DatabaseAuthorizationProxy(auth));
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to lookup authorization for user with ID " + this.getRoleId() + ", type=" + resourceType);
            throw new AuthException("Failed to lookup auth", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Authorization> lookupQuotas(String resourceType) throws AuthException {
        try (TransactionResource db = Entities.transactionFor(AuthorizationEntity.class);){
            List authorizations = Entities.createCriteria(AuthorizationEntity.class).add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"type", (Object)resourceType), (Criterion)Restrictions.eq((String)"effect", (Object)Authorization.EffectType.Limit))).createCriteria("statement").createCriteria("policy").createCriteria("role").add((Criterion)Restrictions.eq((String)"roleId", (Object)this.getRoleId())).setCacheable(true).list();
            ArrayList results = Lists.newArrayList();
            for (AuthorizationEntity auth : authorizations) {
                results.add(new DatabaseAuthorizationProxy(auth));
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to lookup quotas for user with ID " + this.getRoleId() + ", type=" + resourceType);
            throw new AuthException("Failed to lookup quota", (Throwable)e);
        }
    }

    private void check(ValueChecker checker, String error, String value) throws AuthException {
        try {
            checker.check(value);
        }
        catch (InvalidValueException e) {
            Debugging.logError(LOG, e, error + " " + value);
            throw new AuthException(error, (Throwable)e);
        }
    }

    private void dbCallback(String description, final Callback<RoleEntity> updateCallback) throws AuthException {
        try {
            DatabaseAuthUtils.invokeUnique(RoleEntity.class, "roleId", this.getRoleId(), new Tx<RoleEntity>(){

                public void fire(RoleEntity roleEntity) {
                    updateCallback.fire((Object)roleEntity);
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to " + description + " for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
    }

    private RoleEntity getRoleEntity() throws Exception {
        return DatabaseAuthUtils.getUnique(RoleEntity.class, "roleId", this.getRoleId());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.accountNumberSupplier = DatabaseAuthUtils.getAccountNumberSupplier((AccountScopedPrincipal)this);
    }
}

