/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.DatabaseAuthorizationProxy;
import com.eucalyptus.auth.DatabaseGroupProxy;
import com.eucalyptus.auth.Debugging;
import com.eucalyptus.auth.entities.AuthorizationEntity;
import com.eucalyptus.auth.entities.PolicyEntity;
import com.eucalyptus.auth.entities.StatementEntity;
import com.eucalyptus.auth.principal.Authorization;
import com.eucalyptus.auth.principal.Group;
import com.eucalyptus.auth.principal.Policy;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.Tx;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;

public class DatabasePolicyProxy
implements Policy {
    private static final long serialVersionUID = 1L;
    private static Logger LOG = Logger.getLogger(DatabasePolicyProxy.class);
    private PolicyEntity delegate;

    public DatabasePolicyProxy(PolicyEntity delegate) {
        this.delegate = delegate;
    }

    public String getPolicyId() {
        return this.delegate.getPolicyId();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getText() {
        return this.delegate.getText();
    }

    public String getVersion() {
        return this.delegate.getPolicyVersion();
    }

    public Group getGroup() throws AuthException {
        final ArrayList results = Lists.newArrayList();
        try {
            Transactions.one((Object)PolicyEntity.newInstanceWithId(this.delegate.getPolicyId()), (Callback)new Tx<PolicyEntity>(){

                public void fire(PolicyEntity t) {
                    results.add(new DatabaseGroupProxy(t.getGroup()));
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to getGroup for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
        return (Group)results.get(0);
    }

    public List<Authorization> getAuthorizations() throws AuthException {
        final ArrayList results = Lists.newArrayList();
        try {
            Transactions.one((Object)PolicyEntity.newInstanceWithId(this.delegate.getPolicyId()), (Callback)new Tx<PolicyEntity>(){

                public void fire(PolicyEntity t) {
                    for (StatementEntity statementEntity : t.getStatements()) {
                        for (AuthorizationEntity authorizationEntity : statementEntity.getAuthorizations()) {
                            results.add(new DatabaseAuthorizationProxy(authorizationEntity));
                        }
                    }
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to getAuthorizations for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
        return results;
    }
}

