/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.DatabaseAccountProxy;
import com.eucalyptus.auth.DatabaseAuthUtils;
import com.eucalyptus.auth.DatabaseRoleProxy;
import com.eucalyptus.auth.Debugging;
import com.eucalyptus.auth.entities.InstanceProfileEntity;
import com.eucalyptus.auth.entities.RoleEntity;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.InstanceProfile;
import com.eucalyptus.auth.principal.Role;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.Tx;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class DatabaseInstanceProfileProxy
implements InstanceProfile {
    private static Logger LOG = Logger.getLogger(DatabaseInstanceProfileProxy.class);
    private InstanceProfileEntity delegate;

    public DatabaseInstanceProfileProxy(InstanceProfileEntity delegate) {
        this.delegate = delegate;
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        try {
            DatabaseAuthUtils.invokeUnique(InstanceProfileEntity.class, "instanceProfileId", this.delegate.getInstanceProfileId(), new Tx<InstanceProfileEntity>(){

                public void fire(InstanceProfileEntity t) {
                    sb.append(t.toString());
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to toString for " + this.delegate);
        }
        return sb.toString();
    }

    public Account getAccount() throws AuthException {
        final ArrayList results = Lists.newArrayList();
        this.dbCallback("getAccount", new Callback<InstanceProfileEntity>(){

            public void fire(InstanceProfileEntity instanceProfileEntity) {
                results.add(new DatabaseAccountProxy(instanceProfileEntity.getAccount()));
            }
        });
        return (Account)results.get(0);
    }

    public String getInstanceProfileId() {
        return this.delegate.getInstanceProfileId();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getPath() {
        return this.delegate.getPath();
    }

    public Role getRole() throws AuthException {
        final ArrayList results = Lists.newArrayList();
        this.dbCallback("getRole", new Callback<InstanceProfileEntity>(){

            public void fire(InstanceProfileEntity instanceProfileEntity) {
                if (instanceProfileEntity.getRole() == null) {
                    results.add(null);
                } else {
                    results.add(new DatabaseRoleProxy(instanceProfileEntity.getRole()));
                }
            }
        });
        return (Role)results.get(0);
    }

    public void setRole(@Nullable Role role) throws AuthException {
        try (TransactionResource db = Entities.transactionFor(InstanceProfileEntity.class);){
            InstanceProfileEntity instanceProfileEntity = DatabaseAuthUtils.getUnique(InstanceProfileEntity.class, "instanceProfileId", this.getInstanceProfileId());
            RoleEntity roleEntity = role == null ? null : DatabaseAuthUtils.getUnique(RoleEntity.class, "roleId", role.getRoleId());
            instanceProfileEntity.setRole(roleEntity);
            db.commit();
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to assign role for " + this.delegate.getName());
            throw new AuthException("Failed to assign role", (Throwable)e);
        }
    }

    public Date getCreationTimestamp() {
        return this.delegate.getCreationTimestamp();
    }

    private void dbCallback(String description, final Callback<InstanceProfileEntity> updateCallback) throws AuthException {
        try {
            DatabaseAuthUtils.invokeUnique(InstanceProfileEntity.class, "instanceProfileId", this.getInstanceProfileId(), new Tx<InstanceProfileEntity>(){

                public void fire(InstanceProfileEntity instanceProfileEntity) {
                    updateCallback.fire((Object)instanceProfileEntity);
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to " + description + " for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
    }
}

