/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.DatabaseAccountProxy;
import com.eucalyptus.auth.DatabaseAuthUtils;
import com.eucalyptus.auth.DatabasePolicyProxy;
import com.eucalyptus.auth.DatabaseUserProxy;
import com.eucalyptus.auth.Debugging;
import com.eucalyptus.auth.PolicyParseException;
import com.eucalyptus.auth.checker.InvalidValueException;
import com.eucalyptus.auth.checker.ValueChecker;
import com.eucalyptus.auth.checker.ValueCheckerFactory;
import com.eucalyptus.auth.entities.AuthorizationEntity;
import com.eucalyptus.auth.entities.ConditionEntity;
import com.eucalyptus.auth.entities.GroupEntity;
import com.eucalyptus.auth.entities.PolicyEntity;
import com.eucalyptus.auth.entities.StatementEntity;
import com.eucalyptus.auth.entities.UserEntity;
import com.eucalyptus.auth.policy.PolicyParser;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.AccountScopedPrincipal;
import com.eucalyptus.auth.principal.Group;
import com.eucalyptus.auth.principal.Policy;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.util.Tx;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class DatabaseGroupProxy
implements Group {
    private static final long serialVersionUID = 1L;
    private static final ValueChecker NAME_CHECKER = ValueCheckerFactory.createUserAndGroupNameChecker();
    private static final ValueChecker PATH_CHECKER = ValueCheckerFactory.createPathChecker();
    private static final ValueChecker POLICY_NAME_CHECKER = ValueCheckerFactory.createPolicyNameChecker();
    private static Logger LOG = Logger.getLogger(DatabaseGroupProxy.class);
    private GroupEntity delegate;
    private transient Supplier<String> accountNumberSupplier = DatabaseAuthUtils.getAccountNumberSupplier((AccountScopedPrincipal)this);

    public DatabaseGroupProxy(GroupEntity delegate) {
        this.delegate = delegate;
    }

    public DatabaseGroupProxy(GroupEntity delegate, String accountNumber) {
        this.delegate = delegate;
        this.accountNumberSupplier = Suppliers.ofInstance((Object)accountNumber);
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        try {
            DatabaseAuthUtils.invokeUnique(GroupEntity.class, "groupId", this.delegate.getGroupId(), new Tx<GroupEntity>(){

                public void fire(GroupEntity t) {
                    sb.append(t.toString());
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to toString for " + this.delegate);
        }
        return sb.toString();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public void setName(final String name) throws AuthException {
        try {
            NAME_CHECKER.check(name);
        }
        catch (InvalidValueException e) {
            Debugging.logError(LOG, e, "Invalid group name " + name);
            throw new AuthException("Invalid name", (Throwable)e);
        }
        try {
            this.getAccount().lookupGroupByName(name);
        }
        catch (AuthException ae) {
            try {
                DatabaseAuthUtils.invokeUnique(GroupEntity.class, "groupId", this.delegate.getGroupId(), new Tx<GroupEntity>(){

                    public void fire(GroupEntity t) {
                        t.setName(name);
                    }
                });
            }
            catch (ExecutionException e) {
                Debugging.logError(LOG, e, "Failed to setName for " + this.delegate);
                throw new AuthException((Throwable)e);
            }
            return;
        }
        throw new AuthException("Group already exists");
    }

    public String getPath() {
        return this.delegate.getPath();
    }

    public void setPath(final String path) throws AuthException {
        try {
            PATH_CHECKER.check(path);
        }
        catch (InvalidValueException e) {
            Debugging.logError(LOG, e, "Invalid path " + path);
            throw new AuthException("Invalid path", (Throwable)e);
        }
        try {
            DatabaseAuthUtils.invokeUnique(GroupEntity.class, "groupId", this.delegate.getGroupId(), new Tx<GroupEntity>(){

                public void fire(GroupEntity t) {
                    t.setPath(path);
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to setPath for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
    }

    public Date getCreateDate() {
        return this.delegate.getCreationTimestamp();
    }

    public Boolean isUserGroup() {
        return this.delegate.isUserGroup();
    }

    public void setUserGroup(final Boolean userGroup) throws AuthException {
        try {
            DatabaseAuthUtils.invokeUnique(GroupEntity.class, "groupId", this.delegate.getGroupId(), new Tx<GroupEntity>(){

                public void fire(GroupEntity t) {
                    t.setUserGroup(userGroup);
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to setUserGroup for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
    }

    public void addUserByName(String userName) throws AuthException {
        try (TransactionResource db = Entities.transactionFor(GroupEntity.class);){
            GroupEntity groupEntity = DatabaseAuthUtils.getUnique(GroupEntity.class, "groupId", this.delegate.getGroupId());
            UserEntity userEntity = DatabaseAuthUtils.getUniqueUser(userName, groupEntity.getAccount().getName());
            groupEntity.getUsers().add(userEntity);
            userEntity.getGroups().add(groupEntity);
            db.commit();
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to add user " + userName + " to group " + this.delegate);
            throw new AuthException((Throwable)e);
        }
    }

    public void removeUserByName(String userName) throws AuthException {
        try (TransactionResource db = Entities.transactionFor(GroupEntity.class);){
            GroupEntity groupEntity = DatabaseAuthUtils.getUnique(GroupEntity.class, "groupId", this.delegate.getGroupId());
            UserEntity userEntity = DatabaseAuthUtils.getUniqueUser(userName, groupEntity.getAccount().getName());
            groupEntity.getUsers().remove(userEntity);
            userEntity.getGroups().remove(groupEntity);
            db.commit();
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to remove user " + userName + " from group " + this.delegate);
            throw new AuthException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasUser(String userName) throws AuthException {
        try (TransactionResource db = Entities.transactionFor(UserEntity.class);){
            List users = Entities.createCriteria(UserEntity.class).setCacheable(true).add((Criterion)Restrictions.eq((String)"name", (Object)userName)).createCriteria("groups").setCacheable(true).add((Criterion)Restrictions.eq((String)"groupId", (Object)this.delegate.getGroupId())).list();
            db.commit();
            boolean bl = users.size() > 0;
            return bl;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to check membership for group " + this.delegate);
            throw new AuthException((Throwable)e);
        }
    }

    public List<Policy> getPolicies() {
        final ArrayList results = Lists.newArrayList();
        try {
            DatabaseAuthUtils.invokeUnique(GroupEntity.class, "groupId", this.delegate.getGroupId(), new Tx<GroupEntity>(){

                public void fire(GroupEntity t) {
                    for (PolicyEntity p : t.getPolicies()) {
                        results.add(new DatabasePolicyProxy(p));
                    }
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to getPolicies for " + this.delegate);
        }
        return results;
    }

    public Policy addPolicy(String name, String policy) throws AuthException, PolicyParseException {
        return this.storePolicy(name, policy, false);
    }

    public Policy putPolicy(String name, String policy) throws AuthException, PolicyParseException {
        return this.storePolicy(name, policy, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Policy storePolicy(String name, String policy, boolean allowUpdate) throws AuthException, PolicyParseException {
        try {
            POLICY_NAME_CHECKER.check(name);
        }
        catch (InvalidValueException e) {
            Debugging.logError(LOG, e, "Invalid policy name " + name);
            throw new AuthException("Invalid name", (Throwable)e);
        }
        if (DatabaseAuthUtils.policyNameinList(name, this.getPolicies()) && !allowUpdate) {
            Debugging.logError(LOG, null, "Policy name already used: " + name);
            throw new AuthException("Invalid name");
        }
        PolicyEntity parsedPolicy = PolicyParser.getInstance().parse(policy);
        parsedPolicy.setName(name);
        try (TransactionResource db = Entities.transactionFor(GroupEntity.class);){
            GroupEntity groupEntity = DatabaseAuthUtils.getUnique(GroupEntity.class, "groupId", this.delegate.getGroupId());
            PolicyEntity remove = DatabaseAuthUtils.removeGroupPolicy(groupEntity, name);
            if (remove != null) {
                Entities.delete((Object)remove);
            }
            Entities.persist((Object)parsedPolicy);
            parsedPolicy.setGroup(groupEntity);
            for (StatementEntity statement : parsedPolicy.getStatements()) {
                Entities.persist((Object)statement);
                statement.setPolicy(parsedPolicy);
                for (AuthorizationEntity auth : statement.getAuthorizations()) {
                    Entities.persist((Object)auth);
                    auth.setStatement(statement);
                }
                for (ConditionEntity cond : statement.getConditions()) {
                    Entities.persist((Object)cond);
                    cond.setStatement(statement);
                }
            }
            groupEntity.getPolicies().add(parsedPolicy);
            db.commit();
            DatabasePolicyProxy databasePolicyProxy = new DatabasePolicyProxy(parsedPolicy);
            return databasePolicyProxy;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to attach policy for " + this.delegate.getName());
            throw new AuthException("Failed to attach policy", (Throwable)e);
        }
    }

    public void removePolicy(String name) throws AuthException {
        if (name == null) {
            throw new AuthException("Empty policy name");
        }
        try (TransactionResource db = Entities.transactionFor(GroupEntity.class);){
            GroupEntity group = DatabaseAuthUtils.getUnique(GroupEntity.class, "groupId", this.delegate.getGroupId());
            PolicyEntity policy = DatabaseAuthUtils.removeGroupPolicy(group, name);
            if (policy != null) {
                Entities.delete((Object)policy);
            }
            db.commit();
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to remove policy " + name + " in " + this.delegate);
            throw new AuthException("Failed to remove policy", (Throwable)e);
        }
    }

    public List<User> getUsers() {
        final ArrayList results = Lists.newArrayList();
        try {
            DatabaseAuthUtils.invokeUnique(GroupEntity.class, "groupId", this.delegate.getGroupId(), new Tx<GroupEntity>(){

                public void fire(GroupEntity t) {
                    for (UserEntity u : t.getUsers()) {
                        results.add(new DatabaseUserProxy(u));
                    }
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to getUsers for " + this.delegate);
        }
        return results;
    }

    public String getAccountNumber() throws AuthException {
        return DatabaseAuthUtils.extract(this.accountNumberSupplier);
    }

    public Account getAccount() {
        final ArrayList results = Lists.newArrayList();
        try {
            DatabaseAuthUtils.invokeUnique(GroupEntity.class, "groupId", this.delegate.getGroupId(), new Tx<GroupEntity>(){

                public void fire(GroupEntity t) {
                    Entities.initialize((Object)t.getAccount());
                    results.add(new DatabaseAccountProxy(t.getAccount()));
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to getAccount for " + this.delegate);
        }
        return (Account)results.get(0);
    }

    public String getGroupId() {
        return this.delegate.getGroupId();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.accountNumberSupplier = DatabaseAuthUtils.getAccountNumberSupplier((AccountScopedPrincipal)this);
    }
}

