/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.Debugging;
import com.eucalyptus.auth.entities.ConditionEntity;
import com.eucalyptus.auth.principal.Condition;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.Tx;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;

public class DatabaseConditionProxy
implements Condition {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(DatabaseConditionProxy.class);
    private ConditionEntity delegate;

    public DatabaseConditionProxy(ConditionEntity delegate) {
        this.delegate = delegate;
    }

    public String getType() {
        return this.delegate.getType();
    }

    public String getKey() {
        return this.delegate.getKey();
    }

    public Set<String> getValues() throws AuthException {
        final HashSet results = Sets.newHashSet();
        try {
            Transactions.one((Object)ConditionEntity.newInstanceWithId(this.delegate.getConditionId()), (Callback)new Tx<ConditionEntity>(){

                public void fire(ConditionEntity t) {
                    results.addAll(t.getValues());
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to getValues for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
        return results;
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        try {
            Transactions.one((Object)ConditionEntity.newInstanceWithId(this.delegate.getConditionId()), (Callback)new Tx<ConditionEntity>(){

                public void fire(ConditionEntity t) {
                    sb.append(t.toString());
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to toString for " + this.delegate);
        }
        return sb.toString();
    }
}

