/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.DatabaseAuthUtils;
import com.eucalyptus.auth.DatabaseUserProxy;
import com.eucalyptus.auth.Debugging;
import com.eucalyptus.auth.entities.CertificateEntity;
import com.eucalyptus.auth.principal.Certificate;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.auth.util.X509CertHelper;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.util.Tx;
import com.google.common.collect.Lists;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;

public class DatabaseCertificateProxy
implements Certificate {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(DatabaseCertificateProxy.class);
    private CertificateEntity delegate;

    public DatabaseCertificateProxy(CertificateEntity delegate) {
        this.delegate = delegate;
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        try {
            DatabaseAuthUtils.invokeUnique(CertificateEntity.class, "certificateId", this.delegate.getCertificateId(), new Tx<CertificateEntity>(){

                public void fire(CertificateEntity t) {
                    sb.append(t.toString());
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to toString for " + this.delegate);
        }
        return sb.toString();
    }

    public String getCertificateId() {
        return this.delegate.getCertificateId();
    }

    public Boolean isActive() {
        return this.delegate.isActive();
    }

    public void setActive(final Boolean active) throws AuthException {
        try {
            DatabaseAuthUtils.invokeUnique(CertificateEntity.class, "certificateId", this.delegate.getCertificateId(), new Tx<CertificateEntity>(){

                public void fire(CertificateEntity t) {
                    t.setActive(active);
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to setActive for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
    }

    public Boolean isRevoked() {
        return this.delegate.isRevoked();
    }

    public void setRevoked(final Boolean revoked) throws AuthException {
        try {
            DatabaseAuthUtils.invokeUnique(CertificateEntity.class, "certificateId", this.delegate.getCertificateId(), new Tx<CertificateEntity>(){

                public void fire(CertificateEntity t) {
                    t.setRevoked(revoked);
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to setRevoked for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
    }

    public Date getCreateDate() {
        return this.delegate.getCreateDate();
    }

    public void setCreateDate(final Date createDate) throws AuthException {
        try {
            DatabaseAuthUtils.invokeUnique(CertificateEntity.class, "certificateId", this.delegate.getCertificateId(), new Tx<CertificateEntity>(){

                public void fire(CertificateEntity t) {
                    t.setCreateDate(createDate);
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to setCreateDate for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
    }

    public User getUser() throws AuthException {
        final ArrayList results = Lists.newArrayList();
        try {
            DatabaseAuthUtils.invokeUnique(CertificateEntity.class, "certificateId", this.delegate.getCertificateId(), new Tx<CertificateEntity>(){

                public void fire(CertificateEntity t) {
                    Entities.initialize((Object)t.getUser());
                    results.add(new DatabaseUserProxy(t.getUser()));
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to getUser for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
        return (User)results.get(0);
    }

    public X509Certificate getX509Certificate() {
        return X509CertHelper.toCertificate((String)this.delegate.getPem());
    }

    public void setX509Certificate(final X509Certificate x509) throws AuthException {
        try {
            DatabaseAuthUtils.invokeUnique(CertificateEntity.class, "certificateId", this.delegate.getCertificateId(), new Tx<CertificateEntity>(){

                public void fire(CertificateEntity t) {
                    t.setPem(X509CertHelper.fromCertificate((X509Certificate)x509));
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to setX509Certificate for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
    }

    public String getPem() {
        return this.delegate.getPem();
    }
}

