/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.DatabaseConditionProxy;
import com.eucalyptus.auth.DatabaseGroupProxy;
import com.eucalyptus.auth.DatabasePrincipalProxy;
import com.eucalyptus.auth.Debugging;
import com.eucalyptus.auth.entities.AuthorizationEntity;
import com.eucalyptus.auth.entities.ConditionEntity;
import com.eucalyptus.auth.principal.Authorization;
import com.eucalyptus.auth.principal.Condition;
import com.eucalyptus.auth.principal.Group;
import com.eucalyptus.auth.principal.Principal;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.Tx;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;

public class DatabaseAuthorizationProxy
implements Authorization {
    private static final long serialVersionUID = 1L;
    private static Logger LOG = Logger.getLogger(DatabaseAuthorizationProxy.class);
    private AuthorizationEntity delegate;

    public DatabaseAuthorizationProxy(AuthorizationEntity delegate) {
        this.delegate = delegate;
    }

    public Authorization.EffectType getEffect() {
        return this.delegate.getEffect();
    }

    public List<Condition> getConditions() {
        final ArrayList results = Lists.newArrayList();
        try {
            Transactions.one((Object)AuthorizationEntity.newInstanceWithId(this.delegate.getAuthorizationId()), (Callback)new Tx<AuthorizationEntity>(){

                public void fire(AuthorizationEntity t) {
                    for (ConditionEntity c : t.getStatement().getConditions()) {
                        results.add(new DatabaseConditionProxy(c));
                    }
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to getConditions for " + this.delegate);
        }
        return results;
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        try {
            Transactions.one((Object)AuthorizationEntity.newInstanceWithId(this.delegate.getAuthorizationId()), (Callback)new Tx<AuthorizationEntity>(){

                public void fire(AuthorizationEntity t) {
                    sb.append(t.toString());
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to toString for " + this.delegate);
        }
        return sb.toString();
    }

    public Boolean isNotAction() {
        return this.delegate.isNotAction();
    }

    public Boolean isNotResource() {
        return this.delegate.isNotResource();
    }

    public String getAccount() {
        return this.delegate.getAccount();
    }

    public String getType() {
        return this.delegate.getType();
    }

    public Set<String> getActions() {
        final HashSet results = Sets.newHashSet();
        try {
            Transactions.one((Object)AuthorizationEntity.newInstanceWithId(this.delegate.getAuthorizationId()), (Callback)new Tx<AuthorizationEntity>(){

                public void fire(AuthorizationEntity t) {
                    results.addAll(t.getActions());
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to getActions for " + this.delegate);
        }
        return results;
    }

    public Set<String> getResources() {
        final HashSet results = Sets.newHashSet();
        try {
            Transactions.one((Object)AuthorizationEntity.newInstanceWithId(this.delegate.getAuthorizationId()), (Callback)new Tx<AuthorizationEntity>(){

                public void fire(AuthorizationEntity t) {
                    results.addAll(t.getResources());
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to getResources for " + this.delegate);
        }
        return results;
    }

    public Group getGroup() {
        final ArrayList results = Lists.newArrayList();
        try {
            Transactions.one((Object)AuthorizationEntity.newInstanceWithId(this.delegate.getAuthorizationId()), (Callback)new Tx<AuthorizationEntity>(){

                public void fire(AuthorizationEntity t) {
                    results.add(new DatabaseGroupProxy(t.getStatement().getPolicy().getGroup()));
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to getGroup for " + this.delegate);
        }
        return (Group)results.get(0);
    }

    public Authorization.Scope getScope() throws AuthException {
        Group group = this.getGroup();
        if (!group.isUserGroup().booleanValue()) {
            return Authorization.Scope.GROUP;
        }
        User user = (User)group.getUsers().get(0);
        if (user == null) {
            throw new RuntimeException("Empty user group " + group.getName());
        }
        if (user.isAccountAdmin()) {
            return Authorization.Scope.ACCOUNT;
        }
        return Authorization.Scope.USER;
    }

    public String getScopeId() throws AuthException {
        Group group = this.getGroup();
        switch (this.getScope()) {
            case ACCOUNT: {
                return group.getAccount().getAccountNumber();
            }
            case GROUP: {
                return group.getGroupId();
            }
            case USER: {
                return ((User)group.getUsers().get(0)).getUserId();
            }
        }
        throw new RuntimeException("Should not reach here: unrecognized scope.");
    }

    public Principal getPrincipal() {
        final ArrayList results = Lists.newArrayList();
        try {
            Transactions.one((Object)AuthorizationEntity.newInstanceWithId(this.delegate.getAuthorizationId()), (Callback)new Tx<AuthorizationEntity>(){

                public void fire(AuthorizationEntity authorizationEntity) {
                    if (authorizationEntity.getStatement().getPrincipal() != null) {
                        Entities.initialize(authorizationEntity.getStatement().getPrincipal().getValues());
                    }
                    results.add(new DatabasePrincipalProxy(authorizationEntity.getStatement().getPrincipal()));
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to getPrincipal for " + this.delegate);
        }
        return (Principal)results.get(0);
    }
}

