/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.entities.AccountEntity;
import com.eucalyptus.auth.entities.GroupEntity;
import com.eucalyptus.auth.entities.InstanceProfileEntity;
import com.eucalyptus.auth.entities.PolicyEntity;
import com.eucalyptus.auth.entities.RoleEntity;
import com.eucalyptus.auth.entities.UserEntity;
import com.eucalyptus.auth.principal.AccountScopedPrincipal;
import com.eucalyptus.auth.principal.Policy;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionCallbackException;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class DatabaseAuthUtils {
    public static boolean isAccountAdmin(String userName) {
        return "admin".equals(userName);
    }

    public static String getUserGroupName(String userName) {
        return "_" + userName;
    }

    public static boolean isUserGroupName(String groupName) {
        return groupName.startsWith("_");
    }

    public static UserEntity getUniqueUser(String userName, String accountName) throws Exception {
        UserEntity result = (UserEntity)Entities.createCriteria(UserEntity.class).setCacheable(true).add((Criterion)Restrictions.eq((String)"name", (Object)userName)).createCriteria("groups").setCacheable(true).add((Criterion)Restrictions.eq((String)"userGroup", (Object)true)).createCriteria("account").setCacheable(true).add((Criterion)Restrictions.eq((String)"name", (Object)accountName)).uniqueResult();
        if (result == null) {
            throw new NoSuchElementException("Can not find user " + userName + " in " + accountName);
        }
        return result;
    }

    public static GroupEntity getUniqueGroup(String groupName, String accountName) throws Exception {
        GroupEntity result = (GroupEntity)Entities.createCriteria(GroupEntity.class).setCacheable(true).add((Criterion)Restrictions.eq((String)"name", (Object)groupName)).createCriteria("account").setCacheable(true).add((Criterion)Restrictions.eq((String)"name", (Object)accountName)).uniqueResult();
        if (result == null) {
            throw new NoSuchElementException("Can not find group " + groupName + " in " + accountName);
        }
        return result;
    }

    public static InstanceProfileEntity getUniqueInstanceProfile(String instanceProfileName, String accountName) throws Exception {
        InstanceProfileEntity result = (InstanceProfileEntity)Entities.createCriteria(InstanceProfileEntity.class).add((Criterion)Restrictions.eq((String)"name", (Object)instanceProfileName)).createCriteria("account").add((Criterion)Restrictions.eq((String)"name", (Object)accountName)).setCacheable(true).uniqueResult();
        if (result == null) {
            throw new NoSuchElementException("Can not find instance profile " + instanceProfileName + " in " + accountName);
        }
        return result;
    }

    public static RoleEntity getUniqueRole(String roleName, String accountName) throws Exception {
        RoleEntity result = (RoleEntity)Entities.createCriteria(RoleEntity.class).add((Criterion)Restrictions.eq((String)"name", (Object)roleName)).createCriteria("account").add((Criterion)Restrictions.eq((String)"name", (Object)accountName)).setCacheable(true).uniqueResult();
        if (result == null) {
            throw new NoSuchElementException("Can not find role " + roleName + " in " + accountName);
        }
        return result;
    }

    public static AccountEntity getUniqueAccount(String accountName) throws Exception {
        return DatabaseAuthUtils.getUnique(AccountEntity.class, "name", accountName);
    }

    public static PolicyEntity getUniquePolicy(String policyName, String groupId) throws Exception {
        PolicyEntity result = (PolicyEntity)Entities.createCriteria(PolicyEntity.class).setCacheable(true).add((Criterion)Restrictions.eq((String)"name", (Object)policyName)).createCriteria("group").setCacheable(true).add((Criterion)Restrictions.eq((String)"groupId", (Object)groupId)).uniqueResult();
        if (result == null) {
            throw new NoSuchElementException("Can not find policy " + policyName + " for group " + groupId);
        }
        return result;
    }

    public static PolicyEntity removeGroupPolicy(GroupEntity group, String name) throws Exception {
        return DatabaseAuthUtils.removeNamedPolicy(group.getPolicies(), name);
    }

    public static PolicyEntity removeNamedPolicy(List<PolicyEntity> policyEntities, String name) throws Exception {
        PolicyEntity policy = null;
        for (PolicyEntity p : policyEntities) {
            if (!name.equals(p.getName())) continue;
            policy = p;
        }
        if (policy != null) {
            policyEntities.remove(policy);
        }
        return policy;
    }

    public static void checkUserName(String userName) throws AuthException {
        if (userName == null || "".equals(userName)) {
            throw new AuthException("Empty user name");
        }
        for (int i = 0; i < userName.length(); ++i) {
            char c = userName.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '+' || c == '=' || c == ',' || c == '.' || c == '@' || c == '-') continue;
            throw new AuthException("Invalid character in user name: " + c);
        }
    }

    public static void checkPath(String path) throws AuthException {
        if (path != null && !path.startsWith("/")) {
            throw new AuthException("Invalid path: " + path);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkUserExists(String userName, String accountName) throws AuthException {
        if (userName == null) throw new AuthException("Empty user name or account name");
        if (accountName == null) {
            throw new AuthException("Empty user name or account name");
        }
        try (TransactionResource db = Entities.transactionFor(UserEntity.class);){
            UserEntity result = (UserEntity)Entities.createCriteria(UserEntity.class).setCacheable(true).add((Criterion)Restrictions.eq((String)"name", (Object)userName)).createCriteria("groups").setCacheable(true).add((Criterion)Restrictions.eq((String)"userGroup", (Object)true)).createCriteria("account").setCacheable(true).add((Criterion)Restrictions.eq((String)"name", (Object)accountName)).uniqueResult();
            db.commit();
            boolean bl = result != null;
            return bl;
        }
        catch (Exception e) {
            throw new AuthException("Failed to find user", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkRoleExists(String roleName, String accountName) throws AuthException {
        if (roleName == null) throw new AuthException("Empty user name or account name");
        if (accountName == null) {
            throw new AuthException("Empty user name or account name");
        }
        try (TransactionResource db = Entities.transactionFor(RoleEntity.class);){
            RoleEntity result = (RoleEntity)Entities.createCriteria(RoleEntity.class).add((Criterion)Restrictions.eq((String)"name", (Object)roleName)).createCriteria("account").add((Criterion)Restrictions.eq((String)"name", (Object)accountName)).setCacheable(true).uniqueResult();
            boolean bl = result != null;
            return bl;
        }
        catch (Exception e) {
            throw new AuthException("Failed to find role", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkAccountExists(String accountName) throws AuthException {
        if (accountName == null) {
            throw new AuthException("Empty account name");
        }
        try (TransactionResource db = Entities.transactionFor(AccountEntity.class);){
            AccountEntity result = (AccountEntity)Entities.createCriteria(AccountEntity.class).setCacheable(true).add((Criterion)Restrictions.eq((String)"name", (Object)accountName)).uniqueResult();
            db.commit();
            boolean bl = result != null;
            return bl;
        }
        catch (Exception e) {
            throw new AuthException("Failed to find account", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkGroupExists(String groupName, String accountName) throws AuthException {
        if (groupName == null) {
            throw new AuthException("Empty group name");
        }
        if (accountName == null) {
            throw new AuthException("Empty account name");
        }
        try (TransactionResource db = Entities.transactionFor(GroupEntity.class);){
            GroupEntity result = (GroupEntity)Entities.createCriteria(GroupEntity.class).setCacheable(true).add((Criterion)Restrictions.eq((String)"name", (Object)groupName)).createCriteria("account").setCacheable(true).add((Criterion)Restrictions.eq((String)"name", (Object)accountName)).uniqueResult();
            db.commit();
            boolean bl = result != null;
            return bl;
        }
        catch (Exception e) {
            throw new AuthException("Failed to find group", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkInstanceProfileExists(String instanceProfileName, String accountName) throws AuthException {
        if (instanceProfileName == null) throw new AuthException("Empty instance profile name or account name");
        if (accountName == null) {
            throw new AuthException("Empty instance profile name or account name");
        }
        try (TransactionResource db = Entities.transactionFor(InstanceProfileEntity.class);){
            InstanceProfileEntity result = (InstanceProfileEntity)Entities.createCriteria(InstanceProfileEntity.class).add((Criterion)Restrictions.eq((String)"name", (Object)instanceProfileName)).createCriteria("account").add((Criterion)Restrictions.eq((String)"name", (Object)accountName)).setCacheable(true).uniqueResult();
            boolean bl = result != null;
            return bl;
        }
        catch (Exception e) {
            throw new AuthException("Failed to find instance profile", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAccountEmpty(String accountName) throws AuthException {
        try (TransactionResource db = Entities.transactionFor(GroupEntity.class);){
            long groups = Entities.count((Object)new GroupEntity(), (Criterion)Restrictions.eq((String)"account.name", (Object)accountName), Collections.singletonMap("account", "account"));
            long roles = Entities.count((Object)new RoleEntity(), (Criterion)Restrictions.eq((String)"account.name", (Object)accountName), Collections.singletonMap("account", "account"));
            boolean bl = roles + groups == 0L;
            return bl;
        }
        catch (Exception e) {
            throw new AuthException("Error checking if account is empty", (Throwable)e);
        }
    }

    public static boolean policyNameinList(String name, List<Policy> policies) {
        if (policies != null) {
            for (Policy p : policies) {
                if (!p.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> T getUnique(Class<T> entityClass, String property, Object value) throws Exception {
        Object result = Entities.createCriteria(entityClass).setCacheable(true).add((Criterion)Restrictions.eq((String)property, (Object)value)).uniqueResult();
        if (result == null) {
            throw new NoSuchElementException("No " + entityClass.getCanonicalName() + " with " + property + "=" + value);
        }
        return (T)result;
    }

    public static <T> void invokeUnique(Class<T> entityClass, String property, Object value, Callback<T> c) throws TransactionException {
        try (TransactionResource db = Entities.transactionFor(entityClass);){
            T result = DatabaseAuthUtils.getUnique(entityClass, property, value);
            if (c != null) {
                c.fire(result);
            }
            db.commit();
        }
        catch (Exception e) {
            throw new TransactionCallbackException((Throwable)e);
        }
    }

    static Supplier<String> getAccountNumberSupplier(final AccountScopedPrincipal principal) {
        return Suppliers.memoize((Supplier)new Supplier<String>(){

            public String get() {
                try {
                    return principal.getAccount().getAccountNumber();
                }
                catch (AuthException e) {
                    throw Exceptions.toUndeclared((Throwable)e);
                }
            }
        });
    }

    public static <T> T extract(Supplier<T> supplier) throws AuthException {
        try {
            return (T)supplier.get();
        }
        catch (RuntimeException e) {
            throw Exceptions.rethrow((RuntimeException)e, AuthException.class);
        }
    }
}

