/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.DatabaseAccessKeyProxy;
import com.eucalyptus.auth.DatabaseAccountProxy;
import com.eucalyptus.auth.DatabaseAuthUtils;
import com.eucalyptus.auth.DatabaseCertificateProxy;
import com.eucalyptus.auth.DatabaseGroupProxy;
import com.eucalyptus.auth.DatabaseRoleProxy;
import com.eucalyptus.auth.DatabaseUserProxy;
import com.eucalyptus.auth.Debugging;
import com.eucalyptus.auth.InvalidAccessKeyAuthException;
import com.eucalyptus.auth.api.AccountProvider;
import com.eucalyptus.auth.checker.InvalidValueException;
import com.eucalyptus.auth.checker.ValueChecker;
import com.eucalyptus.auth.checker.ValueCheckerFactory;
import com.eucalyptus.auth.entities.AccessKeyEntity;
import com.eucalyptus.auth.entities.AccountEntity;
import com.eucalyptus.auth.entities.CertificateEntity;
import com.eucalyptus.auth.entities.GroupEntity;
import com.eucalyptus.auth.entities.RoleEntity;
import com.eucalyptus.auth.entities.UserEntity;
import com.eucalyptus.auth.principal.AccessKey;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.Certificate;
import com.eucalyptus.auth.principal.Group;
import com.eucalyptus.auth.principal.Role;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.auth.util.X509CertHelper;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;
import org.hibernate.FetchMode;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class DatabaseAuthProvider
implements AccountProvider {
    private static Logger LOG = Logger.getLogger(DatabaseAuthProvider.class);
    private static final ValueChecker ACCOUNT_NAME_CHECKER = ValueCheckerFactory.createAccountNameChecker();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public User lookupUserByName(String userName) throws AuthException {
        if (userName == null) {
            throw new AuthException("Empty user ID");
        }
        try (TransactionResource db = Entities.transactionFor(UserEntity.class);){
            UserEntity user = DatabaseAuthUtils.getUnique(UserEntity.class, "name", userName);
            db.commit();
            DatabaseUserProxy databaseUserProxy = new DatabaseUserProxy(user);
            return databaseUserProxy;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to find user by ID " + userName);
            throw new AuthException("No such user", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public User lookupUserById(String userId) throws AuthException {
        if (userId == null) {
            throw new AuthException("Empty user ID");
        }
        try (TransactionResource db = Entities.transactionFor(UserEntity.class);){
            UserEntity user = DatabaseAuthUtils.getUnique(UserEntity.class, "userId", userId);
            db.commit();
            DatabaseUserProxy databaseUserProxy = new DatabaseUserProxy(user);
            return databaseUserProxy;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to find user by ID " + userId);
            throw new AuthException("No such user", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public User lookupUserByAccessKeyId(String keyId) throws AuthException {
        if (keyId == null) throw new AuthException("Empty key ID");
        if ("".equals(keyId)) {
            throw new AuthException("Empty key ID");
        }
        try (TransactionResource db = Entities.transactionFor(UserEntity.class);){
            UserEntity result = (UserEntity)Entities.createCriteria(UserEntity.class).setCacheable(true).add((Criterion)Restrictions.eq((String)"enabled", (Object)true)).createCriteria("keys").setCacheable(true).add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"accessKey", (Object)keyId), (Criterion)Restrictions.eq((String)"active", (Object)true))).setReadOnly(true).uniqueResult();
            if (result == null) {
                throw new NoSuchElementException("Can not find user with key " + keyId);
            }
            DatabaseUserProxy databaseUserProxy = new DatabaseUserProxy(result);
            return databaseUserProxy;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to find user with access key ID : " + keyId);
            throw new AuthException("No such user", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public User lookupUserByCertificate(X509Certificate cert) throws AuthException {
        if (cert == null) {
            throw new AuthException("Empty input cert");
        }
        try (TransactionResource db = Entities.transactionFor(UserEntity.class);){
            UserEntity result = (UserEntity)Entities.createCriteria(UserEntity.class).setCacheable(true).add((Criterion)Restrictions.eq((String)"enabled", (Object)true)).createCriteria("certificates").setCacheable(true).add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"pem", (Object)X509CertHelper.fromCertificate((X509Certificate)cert)), (Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"active", (Object)true), (Criterion)Restrictions.eq((String)"revoked", (Object)false)))).setReadOnly(true).uniqueResult();
            if (result == null) {
                throw new NoSuchElementException("Can not find user with specific cert");
            }
            DatabaseUserProxy databaseUserProxy = new DatabaseUserProxy(result);
            return databaseUserProxy;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to find user with certificate : " + cert);
            throw new AuthException("No such user", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Group lookupGroupById(String groupId) throws AuthException {
        if (groupId == null) {
            throw new AuthException("Empty group ID");
        }
        try (TransactionResource db = Entities.transactionFor(GroupEntity.class);){
            GroupEntity group = DatabaseAuthUtils.getUnique(GroupEntity.class, "groupId", groupId);
            db.commit();
            DatabaseGroupProxy databaseGroupProxy = new DatabaseGroupProxy(group);
            return databaseGroupProxy;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to find group by ID " + groupId);
            throw new AuthException("No such group", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Role lookupRoleById(String roleId) throws AuthException {
        if (roleId == null) {
            throw new AuthException("Empty role ID");
        }
        try (TransactionResource db = Entities.transactionFor(RoleEntity.class);){
            RoleEntity role = DatabaseAuthUtils.getUnique(RoleEntity.class, "roleId", roleId);
            DatabaseRoleProxy databaseRoleProxy = new DatabaseRoleProxy(role);
            return databaseRoleProxy;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to find role by ID " + roleId);
            throw new AuthException("No such role", (Throwable)e);
        }
    }

    public Account addAccount(String accountName) throws AuthException {
        try {
            ACCOUNT_NAME_CHECKER.check(accountName);
        }
        catch (InvalidValueException e) {
            Debugging.logError(LOG, e, "Invalid account name " + accountName);
            throw new AuthException("Invalid name", (Throwable)e);
        }
        if (DatabaseAuthUtils.checkAccountExists(accountName)) {
            throw new AuthException("Account already exists");
        }
        return this.doAddAccount(accountName);
    }

    public Account addSystemAccount(String accountName) throws AuthException {
        if (!accountName.startsWith("(eucalyptus)")) {
            throw new AuthException("Invalid name");
        }
        try {
            ACCOUNT_NAME_CHECKER.check(accountName.substring("(eucalyptus)".length()));
        }
        catch (InvalidValueException e) {
            Debugging.logError(LOG, e, "Invalid account name " + accountName);
            throw new AuthException("Invalid name", (Throwable)e);
        }
        Account account = null;
        try {
            account = this.lookupAccountByName(accountName);
        }
        catch (AuthException authException) {
            // empty catch block
        }
        if (account == null) {
            AccountEntity accountEntity = new AccountEntity(accountName);
            try (TransactionResource db = Entities.transactionFor(AccountEntity.class);){
                Entities.persist((Object)accountEntity);
                db.commit();
                account = new DatabaseAccountProxy(accountEntity);
            }
            catch (Exception e) {
                Debugging.logError(LOG, e, "Failed to add account " + accountName);
                throw new AuthException("Can not create account", (Throwable)e);
            }
        }
        return account;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Account doAddAccount(String accountName) throws AuthException {
        AccountEntity account = new AccountEntity(accountName);
        try (TransactionResource db = Entities.transactionFor(AccountEntity.class);){
            Entities.persist((Object)account);
            db.commit();
            DatabaseAccountProxy databaseAccountProxy = new DatabaseAccountProxy(account);
            return databaseAccountProxy;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to add account " + accountName);
            throw new AuthException("Can not create account", (Throwable)e);
        }
    }

    public void deleteAccount(String accountName, boolean forceDeleteSystem, boolean recursive) throws AuthException {
        if (accountName == null) {
            throw new AuthException("Empty account name");
        }
        if (!forceDeleteSystem && Accounts.isSystemAccount((String)accountName)) {
            throw new AuthException("Can not delete system account");
        }
        if (!recursive && !DatabaseAuthUtils.isAccountEmpty(accountName)) {
            throw new AuthException("Account still has groups and can not be deleted");
        }
        try (TransactionResource db = Entities.transactionFor(AccountEntity.class);){
            AccountEntity account;
            if (recursive) {
                List users = Entities.createCriteria(UserEntity.class).setCacheable(true).createCriteria("groups").setCacheable(true).add((Criterion)Restrictions.eq((String)"userGroup", (Object)true)).createCriteria("account").setCacheable(true).add((Criterion)Restrictions.eq((String)"name", (Object)accountName)).list();
                for (UserEntity u : users) {
                    Entities.delete((Object)u);
                }
                List roles = Entities.createCriteria(RoleEntity.class).setCacheable(true).createCriteria("account").setCacheable(true).add((Criterion)Restrictions.eq((String)"name", (Object)accountName)).list();
                for (RoleEntity r : roles) {
                    Entities.delete((Object)r);
                }
                List groups = Entities.createCriteria(GroupEntity.class).setCacheable(true).createCriteria("account").setCacheable(true).add((Criterion)Restrictions.eq((String)"name", (Object)accountName)).list();
                for (GroupEntity g : groups) {
                    Entities.delete((Object)g);
                }
            }
            if ((account = (AccountEntity)Entities.createCriteria(AccountEntity.class).setCacheable(true).add((Criterion)Restrictions.eq((String)"name", (Object)accountName)).uniqueResult()) == null) {
                throw new NoSuchElementException("Can not find account " + accountName);
            }
            Entities.delete((Object)account);
            db.commit();
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to delete account " + accountName);
            throw new AuthException("No such account", (Throwable)e);
        }
    }

    public Set<String> resolveAccountNumbersForName(String accountNameLike) throws AuthException {
        HashSet results = Sets.newHashSet();
        try (TransactionResource db = Entities.transactionFor(AccountEntity.class);){
            for (AccountEntity account : Entities.query((Object)new AccountEntity(accountNameLike))) {
                results.add(account.getAccountNumber());
            }
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to resolve account numbers");
            throw new AuthException("Failed to resolve account numbers", (Throwable)e);
        }
        return results;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<User> listAllUsers() throws AuthException {
        ArrayList results = Lists.newArrayList();
        try (TransactionResource db = Entities.transactionFor(UserEntity.class);){
            List users = Entities.query((Object)new UserEntity());
            db.commit();
            for (UserEntity u : users) {
                results.add(new DatabaseUserProxy(u));
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to get all users");
            throw new AuthException("Failed to get all users", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Account> listAllAccounts() throws AuthException {
        ArrayList results = Lists.newArrayList();
        try (TransactionResource db = Entities.transactionFor(AccountEntity.class);){
            for (AccountEntity account : Entities.query((Object)new AccountEntity(), (boolean)true)) {
                results.add(new DatabaseAccountProxy(account));
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to get accounts");
            throw new AuthException("Failed to accounts", (Throwable)e);
        }
    }

    public boolean shareSameAccount(String userId1, String userId2) {
        if (userId1 == null || userId2 == null) {
            return false;
        }
        if (userId1.equals(userId2)) {
            return true;
        }
        try {
            User user1 = this.lookupUserById(userId1);
            User user2 = this.lookupUserById(userId2);
            if (user1.getAccount().getAccountNumber().equals(user2.getAccount().getAccountNumber())) {
                return true;
            }
        }
        catch (AuthException e) {
            LOG.warn((Object)"User(s) can not be found", (Throwable)e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Certificate lookupCertificate(X509Certificate cert) throws AuthException {
        if (cert == null) {
            throw new AuthException("Empty input cert");
        }
        try (TransactionResource db = Entities.transactionFor(CertificateEntity.class);){
            CertificateEntity certEntity = DatabaseAuthUtils.getUnique(CertificateEntity.class, "pem", X509CertHelper.fromCertificate((X509Certificate)cert));
            db.commit();
            DatabaseCertificateProxy databaseCertificateProxy = new DatabaseCertificateProxy(certEntity);
            return databaseCertificateProxy;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to lookup cert " + cert);
            throw new AuthException("No such certificate", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Account lookupAccountByName(String accountName) throws AuthException {
        if (accountName == null) {
            throw new AuthException("Empty account name");
        }
        try (TransactionResource db = Entities.transactionFor(CertificateEntity.class);){
            AccountEntity result = (AccountEntity)Entities.createCriteria(AccountEntity.class).setCacheable(true).add((Criterion)Restrictions.eq((String)"name", (Object)accountName)).setReadOnly(true).uniqueResult();
            if (result == null) {
                throw new AuthException("No such account");
            }
            DatabaseAccountProxy databaseAccountProxy = new DatabaseAccountProxy(result);
            return databaseAccountProxy;
        }
        catch (AuthException e) {
            Debugging.logError(LOG, e, "No matching account " + accountName);
            throw e;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to find account " + accountName);
            throw new AuthException("No such account", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Account lookupAccountById(String accountId) throws AuthException {
        if (accountId == null) {
            throw new AuthException("Empty account ID");
        }
        try (TransactionResource db = Entities.transactionFor(AccountEntity.class);){
            AccountEntity account = DatabaseAuthUtils.getUnique(AccountEntity.class, "accountNumber", accountId);
            db.commit();
            DatabaseAccountProxy databaseAccountProxy = new DatabaseAccountProxy(account);
            return databaseAccountProxy;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to find account " + accountId);
            throw new AuthException("Failed to find account", (Throwable)e);
        }
    }

    public Account lookupAccountByCanonicalId(String canonicalId) throws AuthException {
        if (canonicalId == null || "".equals(canonicalId)) {
            throw new AuthException("Empty canonical ID");
        }
        EntityTransaction tran = Entities.get(AccountEntity.class);
        try {
            AccountEntity example = new AccountEntity();
            example.setCanonicalId(canonicalId);
            List results = Entities.query((Object)example);
            if (results != null && results.size() > 0) {
                AccountEntity found = (AccountEntity)results.get(0);
                tran.commit();
                return new DatabaseAccountProxy(found);
            }
            tran.rollback();
            LOG.warn((Object)("Failed to find account by canonical ID " + canonicalId));
            throw new AuthException("No such user");
        }
        catch (Exception e) {
            tran.rollback();
            Debugging.logError(LOG, e, "Error occurred looking for account by canonical ID " + canonicalId);
            throw new AuthException("No such user", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccessKey lookupAccessKeyById(String keyId) throws AuthException {
        if (keyId == null) {
            throw new AuthException("Empty access key ID");
        }
        try (TransactionResource db = Entities.transactionFor(AccessKeyEntity.class);){
            AccessKeyEntity keyEntity = DatabaseAuthUtils.getUnique(AccessKeyEntity.class, "accessKey", keyId);
            db.commit();
            DatabaseAccessKeyProxy databaseAccessKeyProxy = new DatabaseAccessKeyProxy(keyEntity);
            return databaseAccessKeyProxy;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to find access key with ID " + keyId);
            throw new InvalidAccessKeyAuthException("Failed to find access key", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public User lookupUserByConfirmationCode(String code) throws AuthException {
        if (code == null) {
            throw new AuthException("Empty confirmation code to search");
        }
        try (TransactionResource db = Entities.transactionFor(UserEntity.class);){
            UserEntity result = (UserEntity)Entities.createCriteria(UserEntity.class).setCacheable(true).add((Criterion)Restrictions.eq((String)"confirmationCode", (Object)code)).setReadOnly(true).uniqueResult();
            if (result == null) {
                throw new AuthException("No such user");
            }
            DatabaseUserProxy databaseUserProxy = new DatabaseUserProxy(result);
            return databaseUserProxy;
        }
        catch (AuthException e) {
            Debugging.logError(LOG, e, "Failed to find user by confirmation code " + code);
            throw e;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to find user by confirmation code " + code);
            throw new AuthException("No such user", (Throwable)e);
        }
    }

    public User lookupUserByEmailAddress(String email) throws AuthException {
        if (email == null || "".equals(email)) {
            throw new AuthException("Empty email address to search");
        }
        EntityTransaction tx = Entities.get(UserEntity.class);
        try {
            UserEntity match = (UserEntity)Entities.createCriteria(UserEntity.class).setCacheable(true).createAlias("info", "i").add((Criterion)Restrictions.eq((String)"i.elements", (Object)email).ignoreCase()).setFetchMode("info", FetchMode.JOIN).setReadOnly(true).uniqueResult();
            if (match == null) {
                throw new AuthException("No such user");
            }
            boolean emailMatched = false;
            Map<String, String> info = match.getInfo();
            if (info != null) {
                for (Map.Entry<String, String> entry : info.entrySet()) {
                    if (entry.getKey() == null || !"email".equals(entry.getKey()) || entry.getValue() == null || !email.equalsIgnoreCase(entry.getValue())) continue;
                    emailMatched = true;
                    break;
                }
            }
            if (!emailMatched) {
                throw new AuthException("No such user");
            }
            DatabaseUserProxy databaseUserProxy = new DatabaseUserProxy(match);
            return databaseUserProxy;
        }
        catch (AuthException e) {
            Debugging.logError(LOG, e, "Failed to find user by email address " + email);
            throw e;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to find user by email address " + email);
            throw new AuthException("No such user", (Throwable)e);
        }
        finally {
            tx.rollback();
        }
    }
}

