/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthenticationProperties;
import com.eucalyptus.auth.DatabaseAuthProvider;
import com.eucalyptus.auth.Permissions;
import com.eucalyptus.auth.api.AccountProvider;
import com.eucalyptus.auth.api.PolicyEngine;
import com.eucalyptus.auth.ldap.LdapSync;
import com.eucalyptus.auth.policy.PolicyEngineImpl;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.Role;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.Bootstrapper;
import com.eucalyptus.bootstrap.Provides;
import com.eucalyptus.bootstrap.RunDuring;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.RestrictedTypes;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.log4j.Logger;

@Provides(value=Empyrean.class)
@RunDuring(value=Bootstrap.Stage.UserCredentialsInit)
public class DatabaseAuthBootstrapper
extends Bootstrapper {
    private static Logger LOG = Logger.getLogger(DatabaseAuthBootstrapper.class);

    public boolean load() throws Exception {
        DatabaseAuthProvider dbAuth = new DatabaseAuthProvider();
        Accounts.setAccountProvider((AccountProvider)dbAuth);
        Permissions.setPolicyEngine((PolicyEngine)new PolicyEngineImpl(new Supplier<Boolean>(){

            public Boolean get() {
                return AuthenticationProperties.SYSTEM_ACCOUNT_QUOTA_ENABLED;
            }
        }));
        return true;
    }

    public boolean start() throws Exception {
        if (((Eucalyptus)ComponentIds.lookup(Eucalyptus.class)).isAvailableLocally().booleanValue()) {
            this.ensureSystemAdminExists();
            this.ensureSystemRolesExist();
            this.ensureUserInfoNormalized();
            this.ensureBlockStorageAccountExists();
            this.ensureCloudFormationAccountExists();
            this.ensureExecReadAccountExists();
            LdapSync.start();
        }
        return true;
    }

    private void ensureUserInfoNormalized() {
        try {
            Account account = Accounts.lookupAccountByName((String)"eucalyptus");
            User sysadmin = account.lookupUserByName("admin");
            if (sysadmin.getInfo().containsKey("Email")) {
                Threads.newThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            LOG.debug((Object)"Starting to normalize user info for all users");
                            Accounts.normalizeUserInfo();
                        }
                        catch (Exception e) {
                            LOG.error((Object)e, (Throwable)e);
                        }
                    }
                }).start();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
    }

    public boolean enable() throws Exception {
        return true;
    }

    public boolean stop() throws Exception {
        return true;
    }

    public void destroy() throws Exception {
    }

    public boolean disable() throws Exception {
        return true;
    }

    public boolean check() throws Exception {
        return LdapSync.check();
    }

    private void ensureSystemAdminExists() throws Exception {
        try {
            Account account = Accounts.lookupAccountByName((String)"eucalyptus");
            account.lookupUserByName("admin");
        }
        catch (Exception e) {
            LOG.debug((Object)"System admin does not exist. Adding it now.");
            try {
                Account system = Accounts.addSystemAccount();
                User admin = system.addUser("admin", "/", true, null);
                admin.createKey();
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
    }

    private void ensureSystemRolesExist() throws Exception {
        try {
            Account account = Accounts.lookupAccountByName((String)"eucalyptus");
            List roles = account.getRoles();
            List roleNames = Lists.transform((List)roles, (Function)RestrictedTypes.toDisplayName());
            for (SystemRoleProvider provider : ServiceLoader.load(SystemRoleProvider.class)) {
                if (roleNames.contains(provider.getName())) continue;
                this.addSystemRole(account, provider);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error checking system roles.", (Throwable)e);
        }
    }

    private void addSystemRole(Account account, SystemRoleProvider provider) {
        LOG.info((Object)String.format("Creating system role: %s", provider.getName()));
        try {
            String name = provider.getName();
            String path = provider.getPath();
            String assumeRolePolicy = provider.getAssumeRolePolicy();
            String policy = provider.getPolicy();
            Role role = account.addRole(name, path, assumeRolePolicy);
            role.addPolicy(name, policy);
        }
        catch (Exception e) {
            LOG.error((Object)String.format("Error adding system role: %s", provider.getName()), (Throwable)e);
        }
    }

    private void ensureBlockStorageAccountExists() throws Exception {
        try {
            Accounts.lookupAccountByName((String)"(eucalyptus)blockstorage");
        }
        catch (Exception e) {
            try {
                Accounts.addSystemAccountWithAdmin((String)"(eucalyptus)blockstorage");
            }
            catch (Exception e1) {
                LOG.error((Object)"Error during account creation for (eucalyptus)blockstorage", (Throwable)e1);
            }
        }
    }

    private void ensureCloudFormationAccountExists() throws Exception {
        try {
            Accounts.lookupAccountByName((String)"(eucalyptus)cloudformation");
        }
        catch (Exception e) {
            try {
                Accounts.addSystemAccountWithAdmin((String)"(eucalyptus)cloudformation");
            }
            catch (Exception e1) {
                LOG.error((Object)"Error during account creation for (eucalyptus)cloudformation", (Throwable)e1);
            }
        }
    }

    private void ensureExecReadAccountExists() throws Exception {
        try {
            Accounts.lookupAccountByName((String)"(eucalyptus)aws-exec-read");
        }
        catch (Exception e) {
            try {
                Accounts.addSystemAccountWithAdmin((String)"(eucalyptus)aws-exec-read");
                LOG.info((Object)"Created (eucalyptus)aws-exec-read account");
            }
            catch (Exception e1) {
                LOG.error((Object)"Error during account creation for (eucalyptus)aws-exec-read", (Throwable)e1);
            }
        }
    }

    public static interface SystemRoleProvider {
        public String getName();

        public String getPath();

        public String getAssumeRolePolicy();

        public String getPolicy();
    }
}

