/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.AuthenticationLimitProvider;
import com.eucalyptus.auth.DatabaseAuthProvider;
import com.eucalyptus.auth.DatabaseAuthUtils;
import com.eucalyptus.auth.DatabaseAuthorizationProxy;
import com.eucalyptus.auth.DatabaseGroupProxy;
import com.eucalyptus.auth.DatabaseInstanceProfileProxy;
import com.eucalyptus.auth.DatabaseRoleProxy;
import com.eucalyptus.auth.DatabaseUserProxy;
import com.eucalyptus.auth.Debugging;
import com.eucalyptus.auth.PolicyParseException;
import com.eucalyptus.auth.ServerCertificate;
import com.eucalyptus.auth.ServerCertificates;
import com.eucalyptus.auth.checker.InvalidValueException;
import com.eucalyptus.auth.checker.ValueChecker;
import com.eucalyptus.auth.checker.ValueCheckerFactory;
import com.eucalyptus.auth.entities.AccountEntity;
import com.eucalyptus.auth.entities.AuthorizationEntity;
import com.eucalyptus.auth.entities.CertificateEntity;
import com.eucalyptus.auth.entities.GroupEntity;
import com.eucalyptus.auth.entities.InstanceProfileEntity;
import com.eucalyptus.auth.entities.PolicyEntity;
import com.eucalyptus.auth.entities.RoleEntity;
import com.eucalyptus.auth.entities.ServerCertificateEntity;
import com.eucalyptus.auth.entities.UserEntity;
import com.eucalyptus.auth.policy.PolicyParser;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.auth.principal.Authorization;
import com.eucalyptus.auth.principal.Group;
import com.eucalyptus.auth.principal.InstanceProfile;
import com.eucalyptus.auth.principal.Role;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.component.auth.SystemCredentials;
import com.eucalyptus.component.id.Euare;
import com.eucalyptus.crypto.Ciphers;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.crypto.Digest;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.Tx;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class DatabaseAccountProxy
implements Account {
    private static final long serialVersionUID = 1L;
    private static Logger LOG = Logger.getLogger(DatabaseAccountProxy.class);
    private static final ValueChecker ACCOUNT_NAME_CHECKER = ValueCheckerFactory.createAccountNameChecker();
    private static final ValueChecker USER_GROUP_NAME_CHECKER = ValueCheckerFactory.createUserAndGroupNameChecker();
    private static final ValueChecker PATH_CHECKER = ValueCheckerFactory.createPathChecker();
    private AccountEntity delegate;

    public DatabaseAccountProxy(AccountEntity delegate) {
        this.delegate = delegate;
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getDisplayName() {
        return Accounts.getAccountFullName((Account)this);
    }

    public OwnerFullName getOwner() {
        return AccountFullName.getInstance((Account)this, (String[])new String[0]);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public String getAccountNumber() {
        return this.delegate.getAccountNumber();
    }

    public String getCanonicalId() {
        return this.delegate.getCanonicalId();
    }

    public void setName(final String name) throws AuthException {
        try {
            ACCOUNT_NAME_CHECKER.check(name);
        }
        catch (InvalidValueException e) {
            Debugging.logError(LOG, e, "Invalid account name " + name);
            throw new AuthException("Invalid name", (Throwable)e);
        }
        try {
            new DatabaseAuthProvider().lookupAccountByName(name);
        }
        catch (AuthException ae) {
            try {
                DatabaseAuthUtils.invokeUnique(AccountEntity.class, "accountNumber", this.delegate.getAccountNumber(), new Tx<AccountEntity>(){

                    public void fire(AccountEntity t) {
                        t.setName(name);
                    }
                });
            }
            catch (Exception e) {
                Debugging.logError(LOG, e, "Failed to setName for " + this.delegate);
                throw new AuthException((Throwable)e);
            }
            return;
        }
        throw new AuthException("Account already exists");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<User> getUsers() throws AuthException {
        ArrayList results = Lists.newArrayList();
        try (TransactionResource db = Entities.transactionFor(GroupEntity.class);){
            List users = Entities.createCriteria(UserEntity.class).setCacheable(true).createCriteria("groups").setCacheable(true).add((Criterion)Restrictions.eq((String)"userGroup", (Object)true)).createCriteria("account").setCacheable(true).add((Criterion)Restrictions.eq((String)"name", (Object)this.delegate.getName())).list();
            db.commit();
            for (UserEntity u : users) {
                results.add(new DatabaseUserProxy(u));
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to get users for " + this.delegate.getName());
            throw new AuthException("Failed to get users for account", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Group> getGroups() throws AuthException {
        ArrayList results = Lists.newArrayList();
        try (TransactionResource db = Entities.transactionFor(GroupEntity.class);){
            List groups = Entities.createCriteria(GroupEntity.class).setCacheable(true).add((Criterion)Restrictions.eq((String)"userGroup", (Object)false)).createCriteria("account").setCacheable(true).add((Criterion)Restrictions.eq((String)"name", (Object)this.delegate.getName())).list();
            db.commit();
            for (GroupEntity g : groups) {
                results.add(new DatabaseGroupProxy(g));
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to get groups for " + this.delegate.getName());
            throw new AuthException("Failed to get groups", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Role> getRoles() throws AuthException {
        ArrayList results = Lists.newArrayList();
        try (TransactionResource db = Entities.transactionFor(RoleEntity.class);){
            List roles = Entities.createCriteria(RoleEntity.class).createCriteria("account").add((Criterion)Restrictions.eq((String)"name", (Object)this.delegate.getName())).setCacheable(true).list();
            for (RoleEntity role : roles) {
                results.add(new DatabaseRoleProxy(role));
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to get roles for " + this.delegate.getName());
            throw new AuthException("Failed to get roles", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<InstanceProfile> getInstanceProfiles() throws AuthException {
        ArrayList results = Lists.newArrayList();
        try (TransactionResource db = Entities.transactionFor(InstanceProfileEntity.class);){
            List instanceProfiles = Entities.createCriteria(InstanceProfileEntity.class).createCriteria("account").add((Criterion)Restrictions.eq((String)"name", (Object)this.delegate.getName())).setCacheable(true).list();
            for (InstanceProfileEntity instanceProfile : instanceProfiles) {
                results.add(new DatabaseInstanceProfileProxy(instanceProfile));
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to get instance profiles for " + this.delegate.getName());
            throw new AuthException("Failed to get instance profiles", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public User addUser(String userName, String path, boolean enabled, Map<String, String> info) throws AuthException {
        try {
            USER_GROUP_NAME_CHECKER.check(userName);
        }
        catch (InvalidValueException e) {
            Debugging.logError(LOG, e, "Invalid user name " + userName);
            throw new AuthException("Invalid name", (Throwable)e);
        }
        try {
            PATH_CHECKER.check(path);
        }
        catch (InvalidValueException e) {
            Debugging.logError(LOG, e, "Invalid path " + path);
            throw new AuthException("Invalid path", (Throwable)e);
        }
        if (DatabaseAuthUtils.checkUserExists(userName, this.delegate.getName())) {
            throw new AuthException("User already exists");
        }
        UserEntity newUser = new UserEntity(userName);
        newUser.setPath(path);
        newUser.setEnabled(enabled);
        newUser.setPasswordExpires(System.currentTimeMillis() + AuthenticationLimitProvider.Values.getDefaultPasswordExpiry());
        newUser.setRegistrationStatus(User.RegistrationStatus.CONFIRMED);
        if (info != null) {
            newUser.getInfo().putAll(info);
        }
        newUser.setToken(Crypto.generateSessionToken());
        GroupEntity newGroup = new GroupEntity(DatabaseAuthUtils.getUserGroupName(userName));
        newGroup.setUserGroup(true);
        try (TransactionResource db = Entities.transactionFor(AccountEntity.class);){
            AccountEntity account = DatabaseAuthUtils.getUnique(AccountEntity.class, "name", this.delegate.getName());
            newGroup = (GroupEntity)Entities.mergeDirect((Object)newGroup);
            newUser = (UserEntity)Entities.mergeDirect((Object)newUser);
            newGroup.setAccount(account);
            newGroup.getUsers().add(newUser);
            newUser.getGroups().add(newGroup);
            db.commit();
            DatabaseUserProxy databaseUserProxy = new DatabaseUserProxy(newUser);
            return databaseUserProxy;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to add user: " + userName + " in " + this.delegate.getName());
            throw new AuthException("Can not create user", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean userHasResourceAttached(String userName, String accountName) throws AuthException {
        try (TransactionResource db = Entities.transactionFor(UserEntity.class);){
            UserEntity user = DatabaseAuthUtils.getUniqueUser(userName, accountName);
            GroupEntity userGroup = DatabaseAuthUtils.getUniqueGroup(DatabaseAuthUtils.getUserGroupName(userName), accountName);
            boolean result = user.getGroups().size() > 1 || user.getKeys().size() > 0 || DatabaseAccountProxy.getCurrentCertificateNumber(user.getCertificates()) > 0 || userGroup.getPolicies().size() > 0;
            db.commit();
            boolean bl = result;
            return bl;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to check user " + userName + " in " + accountName);
            throw new AuthException("No such user", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean roleHasResourceAttached(String roleName, String accountName) throws AuthException {
        try (TransactionResource db = Entities.transactionFor(RoleEntity.class);){
            RoleEntity roleEntity = DatabaseAuthUtils.getUniqueRole(roleName, accountName);
            boolean bl = !roleEntity.getPolicies().isEmpty() || !roleEntity.getInstanceProfiles().isEmpty();
            return bl;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to check role " + roleName + " in " + accountName);
            throw new AuthException("No such role", (Throwable)e);
        }
    }

    private static int getCurrentCertificateNumber(List<CertificateEntity> certs) {
        int num = 0;
        for (CertificateEntity cert : certs) {
            if (cert.isRevoked().booleanValue()) continue;
            ++num;
        }
        return num;
    }

    public void deleteUser(String userName, boolean forceDeleteAdmin, boolean recursive) throws AuthException {
        String accountName = this.delegate.getName();
        if (userName == null) {
            throw new AuthException("Empty user name");
        }
        if (!forceDeleteAdmin && DatabaseAuthUtils.isAccountAdmin(userName)) {
            throw new AuthException("Can not delete account admin");
        }
        if (!recursive && this.userHasResourceAttached(userName, accountName)) {
            throw new AuthException("User has resources attached and can not be deleted");
        }
        try (TransactionResource db = Entities.transactionFor(UserEntity.class);){
            UserEntity user = DatabaseAuthUtils.getUniqueUser(userName, accountName);
            for (GroupEntity ge : user.getGroups()) {
                if (ge.isUserGroup().booleanValue()) {
                    Entities.delete((Object)ge);
                    continue;
                }
                ge.getUsers().remove(user);
            }
            Entities.delete((Object)user);
            db.commit();
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to delete user: " + userName + " in " + accountName);
            throw new AuthException("No such user", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Role addRole(String roleName, String path, String assumeRolePolicy) throws AuthException, PolicyParseException {
        try {
            USER_GROUP_NAME_CHECKER.check(roleName);
        }
        catch (InvalidValueException e) {
            Debugging.logError(LOG, e, "Invalid role name " + roleName);
            throw new AuthException("Invalid name", (Throwable)e);
        }
        try {
            PATH_CHECKER.check(path);
        }
        catch (InvalidValueException e) {
            Debugging.logError(LOG, e, "Invalid path " + path);
            throw new AuthException("Invalid path", (Throwable)e);
        }
        if (DatabaseAuthUtils.checkRoleExists(roleName, this.delegate.getName())) {
            throw new AuthException("Role already exists");
        }
        PolicyEntity parsedPolicy = PolicyParser.getResourceInstance().parse(assumeRolePolicy);
        try (TransactionResource db = Entities.transactionFor(AccountEntity.class);){
            AccountEntity account = DatabaseAuthUtils.getUnique(AccountEntity.class, "name", this.delegate.getName());
            RoleEntity newRole = new RoleEntity(roleName);
            newRole.setRoleId(Crypto.generateAlphanumericId((int)21, (String)"ARO"));
            newRole.setPath(path);
            newRole.setAccount(account);
            newRole.setAssumeRolePolicy(parsedPolicy);
            parsedPolicy.setName("assume-role-policy-for-" + newRole.getRoleId());
            RoleEntity persistedRole = (RoleEntity)Entities.persist((Object)newRole);
            db.commit();
            DatabaseRoleProxy databaseRoleProxy = new DatabaseRoleProxy(persistedRole);
            return databaseRoleProxy;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to add role: " + roleName + " in " + this.delegate.getName());
            throw new AuthException("Can not create role", (Throwable)e);
        }
    }

    public void deleteRole(String roleName) throws AuthException {
        String accountName = this.delegate.getName();
        if (roleName == null) {
            throw new AuthException("Empty role name");
        }
        if (this.roleHasResourceAttached(roleName, accountName)) {
            throw new AuthException("Role has resources attached and can not be deleted");
        }
        try (TransactionResource db = Entities.transactionFor(RoleEntity.class);){
            RoleEntity role = DatabaseAuthUtils.getUniqueRole(roleName, accountName);
            Entities.delete((Object)role);
            db.commit();
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to delete role: " + roleName + " in " + accountName);
            throw new AuthException("No such role", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Group addGroup(String groupName, String path) throws AuthException {
        try {
            USER_GROUP_NAME_CHECKER.check(groupName);
        }
        catch (InvalidValueException e) {
            Debugging.logError(LOG, e, "Invalid group name " + groupName);
            throw new AuthException("Invalid name", (Throwable)e);
        }
        try {
            PATH_CHECKER.check(path);
        }
        catch (InvalidValueException e) {
            Debugging.logError(LOG, e, "Invalid path " + path);
            throw new AuthException("Invalid path", (Throwable)e);
        }
        if (DatabaseAuthUtils.checkGroupExists(groupName, this.delegate.getName())) {
            throw new AuthException("Group already exists");
        }
        try (TransactionResource db = Entities.transactionFor(AccountEntity.class);){
            AccountEntity account = DatabaseAuthUtils.getUnique(AccountEntity.class, "name", this.delegate.getName());
            GroupEntity group = new GroupEntity(groupName);
            group.setPath(path);
            group.setUserGroup(false);
            group.setAccount(account);
            Entities.persist((Object)group);
            db.commit();
            DatabaseGroupProxy databaseGroupProxy = new DatabaseGroupProxy(group);
            return databaseGroupProxy;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to add group " + groupName + " in " + this.delegate.getName());
            throw new AuthException("Can not create group", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean groupHasResourceAttached(String groupName, String accountName) throws AuthException {
        try (TransactionResource db = Entities.transactionFor(GroupEntity.class);){
            GroupEntity group = DatabaseAuthUtils.getUniqueGroup(groupName, accountName);
            boolean hasResAttached = group.getUsers().size() > 0 || group.getPolicies().size() > 0;
            db.commit();
            boolean bl = hasResAttached;
            return bl;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to check group " + groupName + " in " + accountName);
            throw new AuthException("No such group", (Throwable)e);
        }
    }

    public void deleteGroup(String groupName, boolean recursive) throws AuthException {
        String accountName = this.delegate.getName();
        if (groupName == null) {
            throw new AuthException("Empty group name");
        }
        if (DatabaseAuthUtils.isUserGroupName(groupName)) {
            throw new AuthException("Can not delete user group");
        }
        if (!recursive && this.groupHasResourceAttached(groupName, accountName)) {
            throw new AuthException("Group has resources attached and can not be deleted");
        }
        try (TransactionResource db = Entities.transactionFor(GroupEntity.class);){
            GroupEntity group = DatabaseAuthUtils.getUniqueGroup(groupName, accountName);
            Entities.delete((Object)group);
            db.commit();
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to delete group " + groupName + " in " + accountName);
            throw new AuthException("No such group", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InstanceProfile addInstanceProfile(String instanceProfileName, String path) throws AuthException {
        try {
            USER_GROUP_NAME_CHECKER.check(instanceProfileName);
        }
        catch (InvalidValueException e) {
            Debugging.logError(LOG, e, "Invalid instance profile name " + instanceProfileName);
            throw new AuthException("Invalid name", (Throwable)e);
        }
        try {
            PATH_CHECKER.check(path);
        }
        catch (InvalidValueException e) {
            Debugging.logError(LOG, e, "Invalid path " + path);
            throw new AuthException("Invalid path", (Throwable)e);
        }
        if (DatabaseAuthUtils.checkInstanceProfileExists(instanceProfileName, this.delegate.getName())) {
            throw new AuthException("Instance profile already exists");
        }
        try (TransactionResource db = Entities.transactionFor(AccountEntity.class);){
            AccountEntity account = DatabaseAuthUtils.getUnique(AccountEntity.class, "name", this.delegate.getName());
            InstanceProfileEntity newInstanceProfile = new InstanceProfileEntity(instanceProfileName);
            newInstanceProfile.setPath(path);
            newInstanceProfile.setAccount(account);
            InstanceProfileEntity persistedInstanceProfile = (InstanceProfileEntity)Entities.persist((Object)newInstanceProfile);
            db.commit();
            DatabaseInstanceProfileProxy databaseInstanceProfileProxy = new DatabaseInstanceProfileProxy(persistedInstanceProfile);
            return databaseInstanceProfileProxy;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to add instance profile: " + instanceProfileName + " in " + this.delegate.getName());
            throw new AuthException("Can not create instance profile", (Throwable)e);
        }
    }

    public void deleteInstanceProfile(String instanceProfileName) throws AuthException {
        String accountName = this.delegate.getName();
        if (instanceProfileName == null) {
            throw new AuthException("Empty instance profile name");
        }
        try (TransactionResource db = Entities.transactionFor(InstanceProfileEntity.class);){
            InstanceProfileEntity instanceProfileEntity = DatabaseAuthUtils.getUniqueInstanceProfile(instanceProfileName, accountName);
            Entities.delete((Object)instanceProfileEntity);
            db.commit();
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to delete instance profile: " + instanceProfileName + " in " + accountName);
            throw new AuthException("No such instance profile", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Group lookupGroupByName(String groupName) throws AuthException {
        String accountName = this.delegate.getName();
        if (groupName == null) {
            throw new AuthException("Empty group name");
        }
        try (TransactionResource db = Entities.transactionFor(GroupEntity.class);){
            GroupEntity group = DatabaseAuthUtils.getUniqueGroup(groupName, accountName);
            db.commit();
            DatabaseGroupProxy databaseGroupProxy = new DatabaseGroupProxy(group);
            return databaseGroupProxy;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to get group " + groupName + " for " + accountName);
            throw new AuthException("No such group", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InstanceProfile lookupInstanceProfileByName(String instanceProfileName) throws AuthException {
        String accountName = this.delegate.getName();
        if (instanceProfileName == null) {
            throw new AuthException("Empty instance profile name");
        }
        try (TransactionResource db = Entities.transactionFor(InstanceProfileEntity.class);){
            InstanceProfileEntity instanceProfileEntity = DatabaseAuthUtils.getUniqueInstanceProfile(instanceProfileName, accountName);
            DatabaseInstanceProfileProxy databaseInstanceProfileProxy = new DatabaseInstanceProfileProxy(instanceProfileEntity);
            return databaseInstanceProfileProxy;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to get instance profile " + instanceProfileName + " for " + accountName);
            throw new AuthException("No such instance profile", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Role lookupRoleByName(String roleName) throws AuthException {
        String accountName = this.delegate.getName();
        if (roleName == null) {
            throw new AuthException("Empty role name");
        }
        try (TransactionResource db = Entities.transactionFor(RoleEntity.class);){
            RoleEntity roleEntity = DatabaseAuthUtils.getUniqueRole(roleName, accountName);
            DatabaseRoleProxy databaseRoleProxy = new DatabaseRoleProxy(roleEntity);
            return databaseRoleProxy;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to get role " + roleName + " for " + accountName);
            throw new AuthException("No such role", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public User lookupUserByName(String userName) throws AuthException {
        String accountName = this.delegate.getName();
        if (userName == null) {
            throw new AuthException("Empty user name");
        }
        try (TransactionResource db = Entities.transactionFor(UserEntity.class);){
            UserEntity user = DatabaseAuthUtils.getUniqueUser(userName, accountName);
            db.commit();
            DatabaseUserProxy databaseUserProxy = new DatabaseUserProxy(user);
            return databaseUserProxy;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to find user: " + userName + " in " + accountName);
            throw new AuthException("No such user", (Throwable)e);
        }
    }

    public User lookupAdmin() throws AuthException {
        return this.lookupUserByName("admin");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Authorization> lookupAccountGlobalAuthorizations(String resourceType) throws AuthException {
        String accountId = this.delegate.getAccountNumber();
        if (resourceType == null) {
            throw new AuthException("Empty resource type");
        }
        try (TransactionResource db = Entities.transactionFor(AuthorizationEntity.class);){
            List authorizations = Entities.createCriteria(AuthorizationEntity.class).setCacheable(true).add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"type", (Object)resourceType), (Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"effect", (Object)Authorization.EffectType.Allow), (Criterion)Restrictions.eq((String)"effect", (Object)Authorization.EffectType.Deny)))).createCriteria("statement").setCacheable(true).createCriteria("policy").setCacheable(true).createCriteria("group").setCacheable(true).add((Criterion)Restrictions.eq((String)"name", (Object)DatabaseAuthUtils.getUserGroupName("admin"))).createCriteria("account").setCacheable(true).add((Criterion)Restrictions.eq((String)"accountNumber", (Object)accountId)).list();
            db.commit();
            ArrayList results = Lists.newArrayList();
            for (AuthorizationEntity auth : authorizations) {
                results.add(new DatabaseAuthorizationProxy(auth));
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to lookup global authorization for account " + accountId + ", type=" + resourceType);
            throw new AuthException("Failed to lookup account global auth", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Authorization> lookupAccountGlobalQuotas(String resourceType) throws AuthException {
        String accountId = this.delegate.getAccountNumber();
        if (resourceType == null) {
            throw new AuthException("Empty resource type");
        }
        try (TransactionResource db = Entities.transactionFor(AuthorizationEntity.class);){
            List authorizations = Entities.createCriteria(AuthorizationEntity.class).setCacheable(true).add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"type", (Object)resourceType), (Criterion)Restrictions.eq((String)"effect", (Object)Authorization.EffectType.Limit))).createCriteria("statement").setCacheable(true).createCriteria("policy").setCacheable(true).createCriteria("group").setCacheable(true).add((Criterion)Restrictions.eq((String)"name", (Object)DatabaseAuthUtils.getUserGroupName("admin"))).createCriteria("account").setCacheable(true).add((Criterion)Restrictions.eq((String)"accountNumber", (Object)accountId)).list();
            db.commit();
            ArrayList results = Lists.newArrayList();
            for (AuthorizationEntity auth : authorizations) {
                results.add(new DatabaseAuthorizationProxy(auth));
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        catch (Exception e) {
            Debugging.logError(LOG, e, "Failed to lookup global quota for account " + accountId + ", type=" + resourceType);
            throw new AuthException("Failed to lookup account global quota", (Throwable)e);
        }
    }

    public ServerCertificate addServerCertificate(String certName, String certBody, String certChain, String certPath, String pk) throws AuthException {
        if (!ServerCertificateEntity.isCertificateNameValid(certName)) {
            throw new AuthException("Server certificate name is invalid");
        }
        if (!ServerCertificateEntity.isCertificatePathValid(certPath)) {
            throw new AuthException("Server certificate path is invalid");
        }
        if (!ServerCertificates.isCertValid(certBody, pk, certChain)) {
            throw new AuthException("Server certificate/private-key is malformed");
        }
        String encPk = null;
        String sessionKey = null;
        try {
            MessageDigest digest = Digest.SHA256.get();
            byte[] salt = new byte[32];
            ((SecureRandom)Crypto.getSecureRandomSupplier().get()).nextBytes(salt);
            digest.update(salt);
            SecretKeySpec symmKey = new SecretKeySpec(digest.digest(), "AES");
            Cipher cipher = Ciphers.AES_GCM.get();
            byte[] iv = new byte[32];
            ((SecureRandom)Crypto.getSecureRandomSupplier().get()).nextBytes(iv);
            cipher.init(1, (Key)symmKey, new IvParameterSpec(iv), (SecureRandom)Crypto.getSecureRandomSupplier().get());
            byte[] cipherText = cipher.doFinal(pk.getBytes());
            encPk = new String(Base64.encode((byte[])Arrays.concatenate((byte[])iv, (byte[])cipherText)));
            PublicKey euarePublicKey = SystemCredentials.lookup(Euare.class).getCertificate().getPublicKey();
            cipher = Ciphers.RSA_PKCS1.get();
            cipher.init(3, (Key)euarePublicKey, (SecureRandom)Crypto.getSecureRandomSupplier().get());
            byte[] wrappedKeyBytes = cipher.wrap(symmKey);
            sessionKey = new String(Base64.encode((byte[])wrappedKeyBytes));
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to encrypt key", (Throwable)e);
            throw Exceptions.toUndeclared((Throwable)e);
        }
        try {
            ServerCertificate found = this.lookupServerCertificate(certName);
            if (found != null) {
                throw new AuthException("Server certificate with the same name already exists");
            }
        }
        catch (NoSuchElementException found) {
        }
        catch (AuthException ex) {
            if (!"No server certificate with the requested name exist".equals(ex.getMessage())) {
                throw ex;
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        String certId = Crypto.generateAlphanumericId((int)21, (String)"ASC");
        ServerCertificateEntity entity = null;
        try (TransactionResource db = Entities.transactionFor(ServerCertificateEntity.class);){
            UserFullName accountAdmin = UserFullName.getInstance((User)this.lookupAdmin(), (String[])new String[0]);
            entity = new ServerCertificateEntity((OwnerFullName)accountAdmin, certName);
            entity.setCertBody(certBody);
            entity.setCertChain(certChain);
            entity.setCertPath(certPath);
            entity.setPrivateKey(encPk);
            entity.setSessionKey(sessionKey);
            entity.setCertId(certId);
            Entities.persist((Object)((Object)entity));
            db.commit();
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to persist server certificate entity", (Throwable)ex);
            throw Exceptions.toUndeclared((Throwable)ex);
        }
        return ServerCertificates.ToServerCertificate.INSTANCE.apply(entity);
    }

    public ServerCertificate deleteServerCertificate(String certName) throws AuthException {
        ServerCertificateEntity found = null;
        try (TransactionResource db = Entities.transactionFor(ServerCertificateEntity.class);){
            found = (ServerCertificateEntity)((Object)Entities.uniqueResult((Object)((Object)ServerCertificateEntity.named((OwnerFullName)UserFullName.getInstance((User)this.lookupAdmin(), (String[])new String[0]), certName))));
            Entities.delete((Object)((Object)found));
            db.commit();
        }
        catch (NoSuchElementException ex) {
            throw new AuthException("No server certificate with the requested name exist");
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
        if (found != null) {
            return ServerCertificates.ToServerCertificate.INSTANCE.apply(found);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServerCertificate lookupServerCertificate(String certName) throws AuthException {
        ServerCertificateEntity found = null;
        try (TransactionResource db = Entities.transactionFor(ServerCertificateEntity.class);){
            List result = Entities.query((Object)((Object)ServerCertificateEntity.named((OwnerFullName)UserFullName.getInstance((User)this.lookupAdmin(), (String[])new String[0]), certName)), (boolean)true);
            if (result == null) throw new AuthException("No server certificate with the requested name exist");
            if (result.size() <= 0) {
                throw new AuthException("No server certificate with the requested name exist");
            }
            found = (ServerCertificateEntity)((Object)result.get(0));
            db.rollback();
            ServerCertificate serverCertificate = ServerCertificates.ToServerCertificate.INSTANCE.apply(found);
            return serverCertificate;
        }
        catch (NoSuchElementException ex) {
            throw new AuthException("No server certificate with the requested name exist");
        }
        catch (AuthException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
    }

    public List<ServerCertificate> listServerCertificates(String pathPrefix) throws AuthException {
        List result = null;
        try (TransactionResource db = Entities.transactionFor(ServerCertificateEntity.class);){
            result = Entities.query((Object)((Object)ServerCertificateEntity.named((OwnerFullName)UserFullName.getInstance((User)this.lookupAdmin(), (String[])new String[0]))), (boolean)true);
            db.rollback();
        }
        catch (Exception ex) {
            throw Exceptions.toUndeclared((Throwable)ex);
        }
        final String prefix = pathPrefix.length() > 1 && pathPrefix.endsWith("/") ? pathPrefix.substring(0, pathPrefix.length() - 1) : pathPrefix;
        List filtered = null;
        filtered = prefix.equals("/") ? result : Lists.newArrayList((Iterable)Collections2.filter((Collection)result, (Predicate)new Predicate<ServerCertificateEntity>(){

            public boolean apply(ServerCertificateEntity entity) {
                String path = entity.getCertPath();
                return path.startsWith(prefix) && (path.length() == prefix.length() || path.charAt(prefix.length()) == '/');
            }
        }));
        return Lists.transform((List)filtered, (Function)new Function<ServerCertificateEntity, ServerCertificate>(){

            public ServerCertificate apply(ServerCertificateEntity entity) {
                return ServerCertificates.ToServerCertificate.INSTANCE.apply(entity);
            }
        });
    }

    public void updateServerCeritificate(String certName, String newCertName, String newPath) throws AuthException {
        try {
            ServerCertificate cert = this.lookupServerCertificate(certName);
            try {
                cert = this.lookupServerCertificate(newCertName);
                if (cert != null) {
                    throw new AuthException("Server certificate with the same name already exists");
                }
            }
            catch (AuthException authException) {
                // empty catch block
            }
            ServerCertificates.updateServerCertificate((OwnerFullName)UserFullName.getInstance((User)this.lookupAdmin(), (String[])new String[0]), certName, newCertName, newPath);
        }
        catch (AuthException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
    }
}

