/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.DatabaseAuthUtils;
import com.eucalyptus.auth.DatabaseUserProxy;
import com.eucalyptus.auth.Debugging;
import com.eucalyptus.auth.entities.AccessKeyEntity;
import com.eucalyptus.auth.principal.AccessKey;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.util.Tx;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;

public class DatabaseAccessKeyProxy
implements AccessKey {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(DatabaseAccessKeyProxy.class);
    private AccessKeyEntity delegate;

    public DatabaseAccessKeyProxy(AccessKeyEntity delegate) {
        this.delegate = delegate;
    }

    public Boolean isActive() {
        return this.delegate.isActive();
    }

    public void setActive(final Boolean active) throws AuthException {
        try {
            DatabaseAuthUtils.invokeUnique(AccessKeyEntity.class, "accessKey", this.delegate.getAccessKey(), new Tx<AccessKeyEntity>(){

                public void fire(AccessKeyEntity t) {
                    t.setActive(active);
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to setActive for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
    }

    public String getSecretKey() {
        return this.delegate.getSecretKey();
    }

    public void setSecretKey(final String key) throws AuthException {
        try {
            DatabaseAuthUtils.invokeUnique(AccessKeyEntity.class, "accessKey", this.delegate.getAccessKey(), new Tx<AccessKeyEntity>(){

                public void fire(AccessKeyEntity t) {
                    t.setSecretKey(key);
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to setKey for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
    }

    public Date getCreateDate() {
        return this.delegate.getCreateDate();
    }

    public User getUser() throws AuthException {
        final ArrayList results = Lists.newArrayList();
        try {
            DatabaseAuthUtils.invokeUnique(AccessKeyEntity.class, "accessKey", this.delegate.getAccessKey(), new Tx<AccessKeyEntity>(){

                public void fire(AccessKeyEntity t) {
                    Entities.initialize((Object)t.getUser());
                    results.add(new DatabaseUserProxy(t.getUser()));
                }
            });
        }
        catch (ExecutionException e) {
            Debugging.logError(LOG, e, "Failed to getUser for " + this.delegate);
            throw new AuthException((Throwable)e);
        }
        return (User)results.get(0);
    }

    public String getAccessKey() {
        return this.delegate.getAccessKey();
    }
}

