/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.auth;

import com.eucalyptus.auth.AuthenticationLimitProvider;
import com.eucalyptus.auth.LicParseException;
import com.eucalyptus.auth.ldap.LdapIntegrationConfiguration;
import com.eucalyptus.auth.ldap.LdapSync;
import com.eucalyptus.auth.ldap.LicParser;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.configurable.PropertyChangeListeners;
import com.eucalyptus.configurable.StaticDatabasePropertyEntry;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.upgrade.Upgrades;
import com.eucalyptus.util.Cidr;
import com.eucalyptus.util.Intervals;
import com.google.common.base.Enums;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

@ConfigurableClass(root="authentication", description="Parameters for authentication.")
public class AuthenticationProperties {
    private static final Logger LOG = Logger.getLogger(AuthenticationProperties.class);
    private static final String LDAP_SYNC_DISABLED = "{ 'sync': { 'enable':'false' } }";
    private static final String DEFAULT_CREDENTIAL_DOWNLOAD_GENERATE_CERTIFICATE = "Absent";
    @ConfigurableField(description="LDAP integration configuration, in JSON", initial="{ 'sync': { 'enable':'false' } }", changeListener=LicChangeListener.class, displayName="lic")
    public static volatile String LDAP_INTEGRATION_CONFIGURATION;
    @ConfigurableField(description="CIDR to match against for host address selection", initial="", changeListener=CidrChangeListener.class)
    public static volatile String CREDENTIAL_DOWNLOAD_HOST_MATCH;
    @ConfigurableField(description="Port to use in service URLs when 'bootstrap.webservices.port' is not appropriate.", changeListener=PortChangeListener.class)
    public static volatile String CREDENTIAL_DOWNLOAD_PORT;
    @ConfigurableField(description="Strategy for generation of certificates on credential download ( Never | Absent | Limited )", initial="Absent", changeListener=CredentialDownloadGenerateCertificateChangeListener.class)
    public static volatile String CREDENTIAL_DOWNLOAD_GENERATE_CERTIFICATE;
    @ConfigurableField(description="Limit for access keys per user", initial="2", changeListener=PropertyChangeListeners.IsPositiveInteger.class)
    public static volatile Integer ACCESS_KEYS_LIMIT;
    @ConfigurableField(description="Limit for signing certificates per user", initial="2", changeListener=PropertyChangeListeners.IsPositiveInteger.class)
    public static volatile Integer SIGNING_CERTIFICATES_LIMIT;
    @ConfigurableField(description="Process quotas for system accounts", initial="true")
    public static volatile Boolean SYSTEM_ACCOUNT_QUOTA_ENABLED;
    @ConfigurableField(description="Default password expiry time", initial="60d", changeListener=AuthenticationIntervalPropertyChangeListener.class)
    public static String DEFAULT_PASSWORD_EXPIRY;
    private static AtomicLong DEFAULT_PASSWORD_EXPIRY_MILLIS;
    private static volatile CredentialDownloadGenerateCertificateStrategy credentialDownloadGenerateCertificateStrategy;

    @Nonnull
    public static CredentialDownloadGenerateCertificateStrategy getCredentialDownloadGenerateCertificateStrategy() {
        return (CredentialDownloadGenerateCertificateStrategy)((Object)com.google.common.base.Objects.firstNonNull((Object)((Object)credentialDownloadGenerateCertificateStrategy), (Object)((Object)CredentialDownloadGenerateCertificateStrategy.Never)));
    }

    static {
        CREDENTIAL_DOWNLOAD_HOST_MATCH = "";
        CREDENTIAL_DOWNLOAD_GENERATE_CERTIFICATE = DEFAULT_CREDENTIAL_DOWNLOAD_GENERATE_CERTIFICATE;
        ACCESS_KEYS_LIMIT = 2;
        SIGNING_CERTIFICATES_LIMIT = 2;
        SYSTEM_ACCOUNT_QUOTA_ENABLED = true;
        DEFAULT_PASSWORD_EXPIRY = "60d";
        DEFAULT_PASSWORD_EXPIRY_MILLIS = new AtomicLong(TimeUnit.DAYS.toMillis(60L));
        credentialDownloadGenerateCertificateStrategy = (CredentialDownloadGenerateCertificateStrategy)((Object)Enums.getIfPresent(CredentialDownloadGenerateCertificateStrategy.class, (String)DEFAULT_CREDENTIAL_DOWNLOAD_GENERATE_CERTIFICATE).orNull());
    }

    @Upgrades.EntityUpgrade(entities={StaticDatabasePropertyEntry.class}, since=Upgrades.Version.v4_1_0, value=Empyrean.class)
    public static enum RaiseCredentialLimitPropertyUpgrade implements Predicate<Class>
    {
        INSTANCE;

        private static Logger LOG;
        private static final String CREDENTIAL_LIMIT = "1000000";
        private static final String CERTIFICATE_STRATEGY;

        public boolean apply(Class arg0) {
            try {
                LOG.info((Object)("Setting authentication.credential_download_generate_certificate to " + CERTIFICATE_STRATEGY));
                StaticDatabasePropertyEntry.update((String)(AuthenticationProperties.class.getName() + ".credential_download_generate_certificate"), (String)"authentication.credential_download_generate_certificate", (String)CERTIFICATE_STRATEGY);
                LOG.info((Object)"Setting authentication.access_keys_limit to 1000000");
                StaticDatabasePropertyEntry.update((String)(AuthenticationProperties.class.getName() + ".access_keys_limit"), (String)"authentication.access_keys_limit", (String)CREDENTIAL_LIMIT);
                LOG.info((Object)"Setting authentication.signing_certificates_limit to 1000000");
                StaticDatabasePropertyEntry.update((String)(AuthenticationProperties.class.getName() + ".signing_certificates_limit"), (String)"authentication.signing_certificates_limit", (String)CREDENTIAL_LIMIT);
                return true;
            }
            catch (Exception ex) {
                LOG.error((Object)"Error raising credential limits", (Throwable)ex);
                return true;
            }
        }

        static {
            LOG = Logger.getLogger(RaiseCredentialLimitPropertyUpgrade.class);
            CERTIFICATE_STRATEGY = CredentialDownloadGenerateCertificateStrategy.Limited.name();
        }
    }

    public static final class AuthenticationIntervalPropertyChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty configurableProperty, Object newValue) throws ConfigurablePropertyException {
            try {
                String fieldName = configurableProperty.getField().getName() + "_MILLIS";
                Field field = AuthenticationProperties.class.getDeclaredField(fieldName);
                long value = Intervals.parse((String)String.valueOf(newValue), (TimeUnit)TimeUnit.MILLISECONDS);
                field.setAccessible(true);
                LOG.info((Object)("Authentication configuration updated " + field.getName() + ": " + value + "ms"));
                ((AtomicLong)field.get(null)).set(value);
            }
            catch (ParseException e) {
                throw new ConfigurablePropertyException(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
    }

    public static class PropertiesAuthenticationLimitProvider
    implements AuthenticationLimitProvider {
        public long getDefaultPasswordExpirySpi() {
            return DEFAULT_PASSWORD_EXPIRY_MILLIS.get();
        }

        public int getAccessKeyLimitSpi() {
            return ACCESS_KEYS_LIMIT;
        }

        public int getSigningCertificateLimitSpi() {
            return SIGNING_CERTIFICATES_LIMIT;
        }
    }

    public static class CredentialDownloadGenerateCertificateChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty configurableProperty, Object newValue) throws ConfigurablePropertyException {
            Optional strategy = Enums.getIfPresent(CredentialDownloadGenerateCertificateStrategy.class, (String)String.valueOf(newValue));
            if (!strategy.isPresent()) {
                credentialDownloadGenerateCertificateStrategy = Enum.valueOf(CredentialDownloadGenerateCertificateStrategy.class, AuthenticationProperties.DEFAULT_CREDENTIAL_DOWNLOAD_GENERATE_CERTIFICATE);
                throw new ConfigurablePropertyException("Invalid certificate download value: " + newValue);
            }
            credentialDownloadGenerateCertificateStrategy = (CredentialDownloadGenerateCertificateStrategy)((Object)strategy.get());
        }
    }

    public static class PortChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            Integer value;
            String strValue = Strings.emptyToNull((String)Objects.toString(newValue, ""));
            if (strValue != null && ((value = Ints.tryParse((String)strValue)) == null || value < 1 || value > 65535)) {
                throw new ConfigurablePropertyException("Invalid value: " + newValue);
            }
        }
    }

    public static final class CidrChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            try {
                Optional.fromNullable((Object)Strings.emptyToNull((String)Objects.toString(newValue, null))).transform((Function)Cidr.parseUnsafe());
            }
            catch (Exception e) {
                throw new ConfigurablePropertyException(e.getMessage());
            }
        }
    }

    public static class LicChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            LOG.debug((Object)("LDAP integration configuration changed to " + newValue));
            String licText = (String)newValue;
            try {
                LdapIntegrationConfiguration lic = LicParser.getInstance().parse(licText);
                LdapSync.setLic(lic);
            }
            catch (LicParseException e) {
                LOG.error((Object)e, (Throwable)e);
                throw new ConfigurablePropertyException("Failed to parse LDAP integration configuration: " + licText + " due to " + (Object)((Object)e), (Throwable)e);
            }
        }
    }

    public static enum CredentialDownloadGenerateCertificateStrategy {
        Absent,
        Limited,
        Never;

    }
}

