/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.util;

import com.eucalyptus.system.Threads;
import java.util.concurrent.ThreadFactory;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;

public class ChannelUtil {
    private static Logger LOG = Logger.getLogger(ChannelUtil.class);

    public static ChannelFutureListener DISPATCH(Object o) {
        return new DeferedWriter(o, ChannelFutureListener.CLOSE);
    }

    public static ChannelFutureListener WRITE_AND_CALLBACK(Object o, ChannelFutureListener callback) {
        return new DeferedWriter(o, callback);
    }

    public static ChannelFutureListener WRITE(Object o) {
        return new DeferedWriter(o, new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
            }
        });
    }

    private static class DeferedWriter
    implements ChannelFutureListener {
        private Object request;
        private ChannelFutureListener callback;

        DeferedWriter(Object request, ChannelFutureListener callback) {
            this.callback = callback;
            this.request = request;
        }

        public void operationComplete(ChannelFuture channelFuture) {
            if (channelFuture.isSuccess()) {
                channelFuture.getChannel().write(this.request).addListener(this.callback);
            } else {
                LOG.debug((Object)channelFuture.getCause(), channelFuture.getCause());
                try {
                    this.callback.operationComplete(channelFuture);
                }
                catch (Exception e) {
                    LOG.debug((Object)e, (Throwable)e);
                }
            }
        }
    }

    static class SystemThreadFactory
    implements ThreadFactory {
        SystemThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return Threads.newThread((Runnable)r, (String)"channels");
        }
    }
}

