/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.server;

import com.eucalyptus.binding.BindingManager;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.util.Strings;
import com.eucalyptus.ws.WebServices;
import com.eucalyptus.ws.WebServicesException;
import com.eucalyptus.ws.handlers.BindingHandler;
import com.eucalyptus.ws.handlers.MessageStackHandler;
import com.eucalyptus.ws.server.FilteredPipeline;
import com.eucalyptus.ws.stages.SoapUserAuthenticationStage;
import com.eucalyptus.ws.stages.UnrollableStage;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import java.util.regex.Pattern;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpRequest;

public abstract class SoapPipeline
extends FilteredPipeline {
    private final String name;
    private final Class<? extends ComponentId> component;
    private final Set<String> servicePaths;
    private final String defaultNamespace;
    private final String namespacePattern;
    private final UnrollableStage auth = new SoapUserAuthenticationStage();

    protected SoapPipeline(String name, Class<? extends ComponentId> component, Set<String> servicePaths, String defaultNamespace, String namespacePattern) {
        this.name = name;
        this.component = component;
        this.servicePaths = ImmutableSet.copyOf(servicePaths);
        this.defaultNamespace = defaultNamespace;
        this.namespacePattern = namespacePattern;
    }

    protected SoapPipeline(String name, Class<? extends ComponentId> component, String servicePath, String defaultNamespace, String namespacePattern) {
        this(name, component, (Set<String>)ImmutableSet.of((Object)servicePath), defaultNamespace, namespacePattern);
    }

    public boolean checkAccepts(HttpRequest message) {
        boolean usesServicePath = Iterables.any(this.servicePaths, (Predicate)Strings.isSuffixOf((String)message.getUri()));
        boolean noPath = message.getUri().isEmpty() || message.getUri().equals("/") || message.getUri().startsWith("/?");
        return message.getHeaderNames().contains("SOAPAction") && (usesServicePath || noPath && this.resolvesByHost(message.getHeader("Host")));
    }

    public String getName() {
        return this.name;
    }

    public ChannelPipeline addHandlers(ChannelPipeline pipeline) {
        if (!WebServices.isSoapEnabled(this.component)) {
            pipeline.addLast("disabled-soap-fault", (ChannelHandler)new MessageStackHandler(){

                public void incomingMessage(MessageEvent event) throws Exception {
                    throw new WebServicesException("Service not available");
                }
            });
        }
        this.getAuthenticationStage().unrollStage(pipeline);
        pipeline.addLast("binding", (ChannelHandler)new BindingHandler(BindingManager.getBinding((String)this.defaultNamespace, this.component), Pattern.compile(this.namespacePattern), this.component));
        return pipeline;
    }

    protected UnrollableStage getAuthenticationStage() {
        return this.auth;
    }
}

