/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.server;

import com.eucalyptus.auth.principal.TemporaryAccessKey;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.util.Strings;
import com.eucalyptus.ws.protocol.RequiredQueryParams;
import com.eucalyptus.ws.server.FilteredPipeline;
import com.eucalyptus.ws.stages.HmacUserAuthenticationStage;
import com.eucalyptus.ws.stages.UnrollableStage;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;

public abstract class QueryPipeline
extends FilteredPipeline {
    private final HmacUserAuthenticationStage auth;
    private final String name;
    private final Set<String> servicePathPrefixes;
    private final Set<RequiredQueryParams> requiredQueryParams;

    protected QueryPipeline(String name, String servicePathPrefix, Set<TemporaryAccessKey.TemporaryKeyType> allowedTemporaryCredentials) {
        this(name, (Set<String>)ImmutableSet.of((Object)servicePathPrefix), allowedTemporaryCredentials, EnumSet.allOf(RequiredQueryParams.class));
    }

    protected QueryPipeline(String name, String servicePathPrefix, Set<TemporaryAccessKey.TemporaryKeyType> allowedTemporaryCredentials, Set<RequiredQueryParams> requiredQueryParams) {
        this(name, (Set<String>)ImmutableSet.of((Object)servicePathPrefix), allowedTemporaryCredentials, requiredQueryParams);
    }

    protected QueryPipeline(String name, Set<String> servicePathPrefixes, Set<TemporaryAccessKey.TemporaryKeyType> allowedTemporaryCredentials, Set<RequiredQueryParams> requiredQueryParams) {
        this.auth = new HmacUserAuthenticationStage(allowedTemporaryCredentials);
        this.name = name;
        this.servicePathPrefixes = ImmutableSet.copyOf(servicePathPrefixes);
        this.requiredQueryParams = ImmutableSet.copyOf(requiredQueryParams);
    }

    protected UnrollableStage getAuthenticationStage() {
        return this.auth;
    }

    public ChannelPipeline addHandlers(ChannelPipeline pipeline) {
        this.getAuthenticationStage().unrollStage(pipeline);
        return null;
    }

    public boolean checkAccepts(HttpRequest message) {
        if (message instanceof MappingHttpRequest) {
            MappingHttpRequest httpRequest = (MappingHttpRequest)message;
            if (httpRequest.getMethod().equals((Object)HttpMethod.POST)) {
                HashMap<String, String> parameters = new HashMap<String, String>(httpRequest.getParameters());
                HashSet nonQueryParameters = Sets.newHashSet();
                ChannelBuffer buffer = httpRequest.getContent();
                buffer.markReaderIndex();
                byte[] read = new byte[buffer.readableBytes()];
                buffer.readBytes(read);
                String query = new String(read);
                buffer.resetReaderIndex();
                for (String p : query.split("&")) {
                    String[] splitParam = p.split("=");
                    String lhs = splitParam[0];
                    String rhs = splitParam.length == 2 ? splitParam[1] : null;
                    try {
                        if (lhs != null) {
                            lhs = new URLCodec().decode(lhs);
                        }
                    }
                    catch (DecoderException decoderException) {
                        // empty catch block
                    }
                    try {
                        if (rhs != null) {
                            rhs = new URLCodec().decode(rhs);
                        }
                    }
                    catch (DecoderException decoderException) {
                        // empty catch block
                    }
                    parameters.put(lhs, rhs);
                    nonQueryParameters.add(lhs);
                }
                for (RequiredQueryParams p : this.requiredQueryParams) {
                    if (parameters.containsKey(p.toString())) continue;
                    return false;
                }
                httpRequest.getParameters().putAll(parameters);
                httpRequest.addNonQueryParameterKeys((Set)nonQueryParameters);
            } else {
                for (RequiredQueryParams p : this.requiredQueryParams) {
                    if (httpRequest.getParameters().containsKey(p.toString())) continue;
                    return false;
                }
            }
            boolean usesServicePath = Iterables.any(this.servicePathPrefixes, (Predicate)Strings.isPrefixOf((String)message.getUri()));
            boolean noPath = message.getUri().isEmpty() || message.getUri().equals("/") || message.getUri().startsWith("/?");
            return usesServicePath || noPath && this.resolvesByHost(message.getHeader("Host"));
        }
        return false;
    }

    public String getName() {
        return this.name;
    }
}

