/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.handlers.wssecurity;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Partitions;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.crypto.util.WSSecurity;
import com.eucalyptus.http.MappingHttpMessage;
import com.eucalyptus.ws.handlers.MessageStackHandler;
import java.security.cert.X509Certificate;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.soap.SOAPEnvelope;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.MessageEvent;

public class BrokerWsSecHandler
extends MessageStackHandler
implements ChannelHandler {
    public void incomingMessage(MessageEvent event) throws Exception {
        Object o = event.getMessage();
        if (o instanceof MappingHttpMessage) {
            MappingHttpMessage httpRequest = (MappingHttpMessage)o;
            SOAPEnvelope envelope = httpRequest.getSoapEnvelope();
            X509Certificate cert = WSSecurity.verifyWSSec((SOAPEnvelope)envelope);
            boolean found = false;
            for (Partition part : Partitions.list()) {
                if (!cert.equals(part.getCertificate())) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new WebServiceException("Authentication failure: cert is not trusted");
            }
            User admin = Accounts.lookupSystemAdmin();
            Contexts.lookup((String)((MappingHttpMessage)o).getCorrelationId()).setUser(admin);
        }
    }
}

