/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.handlers;

import com.eucalyptus.http.MappingHttpMessage;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;

public class ChannelStateMonitor
extends SimpleChannelHandler {
    private static Logger LOG = Logger.getLogger(ChannelStateMonitor.class);
    private final AtomicLong readBytes = new AtomicLong(0L);
    private final AtomicLong writeBytes = new AtomicLong(0L);
    private AtomicLong openTime = new AtomicLong();
    private String eventUserId = "unknown";
    private String correlationId = "unknown";

    public void split(ChannelHandlerContext ctx) {
        Long rb = this.readBytes.getAndSet(0L);
        Long wb = this.writeBytes.getAndSet(0L);
        Long roundTime = System.currentTimeMillis() - this.openTime.getAndSet(0L);
        LOG.trace((Object)EventRecord.here(ctx.getPipeline().getLast().getClass(), (EventType)EventType.SOCKET_CLOSE, (String[])new String[]{"" + roundTime.toString(), "" + ctx.getChannel().getLocalAddress(), "" + ctx.getChannel().getRemoteAddress()}));
        if (rb != null) {
            LOG.trace((Object)EventRecord.here(ctx.getPipeline().getLast().getClass(), (EventType)EventType.SOCKET_BYTES_READ, (String[])new String[]{"" + rb, Float.toString((float)wb.longValue() * 1024.0f / ((float)roundTime.longValue() * 1024.0f))}));
        }
        if (wb != null) {
            LOG.trace((Object)EventRecord.here(ctx.getPipeline().getLast().getClass(), (EventType)EventType.SOCKET_BYTES_WRITE, (String[])new String[]{"" + wb, Float.toString((float)wb.longValue() * 1024.0f / ((float)roundTime.longValue() * 1024.0f))}));
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.split(ctx);
        super.channelClosed(ctx, e);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.openTime.getAndSet(System.currentTimeMillis());
        EventRecord.here(ctx.getPipeline().getLast().getClass(), (EventType)EventType.SOCKET_OPEN, (String[])new String[]{ctx.getChannel().getLocalAddress().toString(), ctx.getChannel().getRemoteAddress().toString()}).trace();
        super.channelConnected(ctx, e);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (e.getMessage() instanceof MappingHttpMessage) {
            MappingHttpMessage msg = (MappingHttpMessage)e.getMessage();
            this.readBytes.addAndGet(msg.getContent().readableBytes());
        } else if (e.getMessage() instanceof ChannelBuffer) {
            ChannelBuffer msg = (ChannelBuffer)e.getMessage();
            this.readBytes.addAndGet(msg.readableBytes());
        }
        super.messageReceived(ctx, e);
    }

    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (e.getMessage() instanceof MappingHttpMessage) {
            MappingHttpMessage msg = (MappingHttpMessage)e.getMessage();
            this.writeBytes.addAndGet(msg.getContent().readableBytes());
            if (msg.getMessage() != null && msg.getMessage() instanceof BaseMessage) {
                this.correlationId = ((BaseMessage)msg.getMessage()).getCorrelationId();
                this.eventUserId = ((BaseMessage)msg.getMessage()).getUserId();
            }
        } else if (e.getMessage() instanceof ChannelBuffer) {
            ChannelBuffer msg = (ChannelBuffer)e.getMessage();
            this.writeBytes.addAndGet(msg.readableBytes());
        }
        super.writeRequested(ctx, e);
    }
}

