/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.handlers;

import com.eucalyptus.binding.Binding;
import com.eucalyptus.binding.BindingManager;
import com.eucalyptus.http.MappingHttpMessage;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.ws.WebServicesException;
import com.eucalyptus.ws.handlers.MessageStackHandler;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.EucalyptusErrorMessageType;
import edu.ucsb.eucalyptus.msgs.ExceptionResponseType;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;

@ChannelHandler.Sharable
public class BrokerBindingHandler
extends MessageStackHandler {
    private static Logger LOG = Logger.getLogger(BrokerBindingHandler.class);
    private Binding binding;

    public BrokerBindingHandler() {
    }

    public BrokerBindingHandler(Binding binding) {
        this.binding = binding;
    }

    public void incomingMessage(MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpMessage) {
            MappingHttpMessage httpMessage = (MappingHttpMessage)event.getMessage();
            BaseMessage msg = null;
            OMElement elem = httpMessage.getOmMessage();
            OMNamespace omNs = elem.getNamespace();
            String namespace = omNs.getNamespaceURI();
            Class msgType = null;
            try {
                this.binding = BindingManager.getBinding((String)namespace);
                msgType = this.binding.getElementClass(httpMessage.getOmMessage().getLocalName());
            }
            catch (Exception e1) {
                if (this.binding == null) {
                    throw new WebServicesException((Throwable)e1);
                }
                throw new WebServicesException("Failed to find binding for namespace: " + namespace + " due to: " + e1.getMessage(), (Throwable)e1);
            }
            try {
                msg = httpMessage instanceof MappingHttpRequest ? (msgType != null ? (BaseMessage)this.binding.fromOM(httpMessage.getOmMessage(), msgType) : (BaseMessage)this.binding.fromOM(httpMessage.getOmMessage())) : (BaseMessage)this.binding.fromOM(httpMessage.getOmMessage());
            }
            catch (Exception e1) {
                LOG.fatal((Object)("FAILED TO PARSE:\n" + httpMessage.getMessageString()));
                throw new WebServicesException((Throwable)e1);
            }
            httpMessage.setMessage((Object)msg);
        }
    }

    public void outgoingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpMessage) {
            MappingHttpMessage httpRequest = (MappingHttpMessage)event.getMessage();
            SOAPEnvelope omElem = null;
            if (httpRequest.getMessage() instanceof EucalyptusErrorMessageType || httpRequest.getMessage() == null) {
                return;
            }
            if (httpRequest.getMessage() instanceof ExceptionResponseType) {
                ExceptionResponseType msg = (ExceptionResponseType)httpRequest.getMessage();
                String createFaultDetails = Logs.isExtrrreeeme() ? Exceptions.string((Throwable)msg.getException()) : msg.getException().getMessage();
                omElem = Binding.createFault((String)msg.getRequestType(), (String)msg.getMessage(), (String)createFaultDetails);
            } else {
                Class<?> targetClass = httpRequest.getMessage().getClass();
                while (!targetClass.getSimpleName().endsWith("Type")) {
                    targetClass = targetClass.getSuperclass();
                }
                Class<?> responseClass = ClassLoader.getSystemClassLoader().loadClass(targetClass.getName());
                ctx.setAttachment(responseClass);
                omElem = this.binding.toOM(httpRequest.getMessage());
            }
            httpRequest.setOmMessage((OMElement)omElem);
        }
    }
}

