/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.client.pipeline;

import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.ws.Handlers;
import com.eucalyptus.ws.StackConfiguration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;

@ComponentPart(value=Empyrean.class)
public class InternalClientPipeline
implements ChannelPipelineFactory {
    private static Logger LOG = Logger.getLogger(InternalClientPipeline.class);

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        for (Map.Entry e : Handlers.channelMonitors((TimeUnit)TimeUnit.SECONDS, (int)StackConfiguration.CLIENT_INTERNAL_TIMEOUT_SECS).entrySet()) {
            pipeline.addLast((String)e.getKey(), (ChannelHandler)e.getValue());
        }
        pipeline.addLast("decoder", Handlers.newHttpResponseDecoder());
        pipeline.addLast("aggregator", Handlers.newHttpChunkAggregator());
        pipeline.addLast("encoder", Handlers.httpRequestEncoder());
        pipeline.addLast("serializer", Handlers.soapMarshalling());
        pipeline.addLast("wssec", Handlers.internalWsSecHandler());
        pipeline.addLast("addressing", Handlers.addressingHandler());
        pipeline.addLast("soap", Handlers.soapHandler());
        pipeline.addLast("binding", Handlers.bindingHandler());
        return pipeline;
    }
}

