/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.client;

import com.eucalyptus.ws.Client;
import com.eucalyptus.ws.client.NioClient;
import com.eucalyptus.ws.client.pipeline.InternalClientPipeline;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.transport.AbstractMessageDispatcher;

public class NioMessageDispatcher
extends AbstractMessageDispatcher {
    private static Logger LOG = Logger.getLogger(NioMessageDispatcher.class);
    private Client client;

    public NioMessageDispatcher(OutboundEndpoint outboundEndpoint) {
        super(outboundEndpoint);
        this.doActivate(outboundEndpoint);
    }

    public void doActivate(OutboundEndpoint outboundEndpoint) {
        if (this.client != null) {
            this.client = null;
        }
        String host = outboundEndpoint.getEndpointURI().getHost();
        int port = outboundEndpoint.getEndpointURI().getPort();
        String servicePath = outboundEndpoint.getEndpointURI().getPath();
        this.client = new NioClient(host, port, servicePath, (ChannelPipelineFactory)new InternalClientPipeline());
    }

    protected void doDispatch(MuleEvent muleEvent) throws Exception {
        this.client.dispatch((BaseMessage)muleEvent.getMessage().getPayload());
    }

    protected MuleMessage doSend(MuleEvent muleEvent) throws Exception {
        MuleMessage muleMsg = muleEvent.getMessage();
        BaseMessage request = (BaseMessage)muleMsg.getPayload();
        BaseMessage response = this.client.send(request);
        return new DefaultMuleMessage((Object)response, muleEvent.getMuleContext());
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }
}

