/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.BootstrapArgs;
import com.eucalyptus.bootstrap.Bootstrapper;
import com.eucalyptus.bootstrap.Hosts;
import com.eucalyptus.bootstrap.Provides;
import com.eucalyptus.bootstrap.RunDuring;
import com.eucalyptus.component.Component;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.Faults;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.ws.WebServices;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

@Provides(value=Empyrean.class)
@RunDuring(value=Bootstrap.Stage.RemoteServicesInit)
public class ServiceBootstrapper
extends Bootstrapper.Simple {
    private static Logger LOG = Logger.getLogger(ServiceBootstrapper.class);
    private static final int NUM_SERVICE_BOOTSTRAP_WORKERS = 40;

    public boolean load() {
        WebServices.restart();
        ServiceBootstrapper.execute(new Predicate<ServiceConfiguration>(){

            public boolean apply(final ServiceConfiguration config) {
                ServiceBootstrapWorker.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Components.lookup((ComponentId)config.getComponentId()).setup(config);
                            if (config.lookupState().ordinal() < Component.State.LOADED.ordinal()) {
                                Topology.transition((Component.State)Component.State.LOADED).apply((Object)config);
                            }
                        }
                        catch (Exception ex) {
                            Faults.failure((ServiceConfiguration)config, (Throwable[])new Throwable[]{ex});
                        }
                    }

                    public String toString() {
                        return "ServiceBootstrap.load(): " + config.getFullName();
                    }
                });
                return true;
            }
        });
        ServiceBootstrapWorker.waitAll();
        return true;
    }

    public boolean start() throws Exception {
        ServiceBootstrapper.execute(new Predicate<ServiceConfiguration>(){

            public boolean apply(final ServiceConfiguration config) {
                ServiceBootstrapWorker.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Topology.transition((Component.State)Component.State.DISABLED).apply((Object)config);
                        }
                        catch (Exception ex) {
                            Exceptions.maybeInterrupted((Throwable)ex);
                        }
                    }

                    public String toString() {
                        return "ServiceBootstrap.start(): " + config.getFullName();
                    }
                });
                return true;
            }
        });
        ServiceBootstrapWorker.markFinished();
        return true;
    }

    private static void execute(Predicate<ServiceConfiguration> predicate) throws NoSuchElementException {
        for (ComponentId compId : ComponentIds.list()) {
            Component comp = Components.lookup((ComponentId)compId);
            if (compId.isRegisterable()) {
                for (ServiceConfiguration config : Iterables.filter((Iterable)ServiceConfigurations.list(compId.getClass()), (Predicate)ShouldLoad.INSTANCE)) {
                    try {
                        predicate.apply((Object)config);
                    }
                    catch (Exception ex) {
                        Exceptions.trace((Throwable)ex);
                    }
                }
                continue;
            }
            if (comp.hasLocalService().booleanValue()) {
                ServiceConfiguration config = comp.getLocalServiceConfiguration();
                if (!config.isVmLocal().booleanValue() && (!BootstrapArgs.isCloudController().booleanValue() || !config.isHostLocal().booleanValue())) continue;
                try {
                    predicate.apply((Object)config);
                }
                catch (Exception ex) {
                    Exceptions.trace((Throwable)ex);
                }
                continue;
            }
            if (!compId.isAlwaysLocal().booleanValue() && BootstrapArgs.isCloudController().booleanValue() && !compId.isCloudLocal().booleanValue()) continue;
        }
    }

    static enum ShouldStart implements Predicate<ServiceConfiguration>
    {
        INSTANCE;


        public boolean apply(ServiceConfiguration config) {
            boolean ret = ShouldLoad.INSTANCE.apply(config) || Eucalyptus.class.equals(config.getComponentId().getClass()) && config.isHostLocal() != false;
            LOG.debug((Object)("ServiceBootstrapper.shouldStart(" + config.toString() + "):" + ret));
            return ret;
        }
    }

    static enum ShouldLoad implements Predicate<ServiceConfiguration>
    {
        INSTANCE;


        public boolean apply(ServiceConfiguration config) {
            boolean ret = config.getComponentId().isAlwaysLocal() != false || config.isVmLocal() != false || BootstrapArgs.isCloudController() != false && config.getComponentId().isCloudLocal() != false || Hosts.isCoordinator();
            LOG.debug((Object)("ServiceBootstrapper.shouldLoad(" + config.toString() + "):" + ret));
            return ret;
        }
    }

    static class ServiceBootstrapWorker {
        private static final ConcurrentMap<Worker, Runnable> workers = Maps.newConcurrentMap();
        private static final Runnable IDLE = new Runnable(){

            public String toString() {
                return "IDLE";
            }

            @Override
            public void run() {
            }
        };
        private static final AtomicBoolean running = new AtomicBoolean(true);
        private static final BlockingQueue<Runnable> msgQueue = new LinkedBlockingQueue<Runnable>();
        private static final ExecutorService executor = Executors.newCachedThreadPool();
        private static final ServiceBootstrapWorker worker = new ServiceBootstrapWorker();

        private ServiceBootstrapWorker() {
            for (int i = 0; i < 40; ++i) {
                executor.submit(new Worker());
            }
        }

        public static void markFinished() {
            running.set(false);
            executor.shutdownNow();
        }

        public static void submit(Runnable run) {
            LOG.info((Object)run);
            if (!running.get()) {
                throw new IllegalStateException("Worker has been stopped: " + ServiceBootstrapWorker.class);
            }
            msgQueue.add(run);
        }

        static void waitAll() {
            try {
                while (true) {
                    if (!msgQueue.isEmpty()) {
                        for (Worker w : workers.keySet()) {
                            LOG.info((Object)("Waiting for" + w));
                        }
                        TimeUnit.MILLISECONDS.sleep(200L);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }

        class Worker
        implements Runnable,
        Comparable<Worker> {
            private final String name = Thread.currentThread().getName();

            Worker() {
                workers.put(this, IDLE);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    worker;
                    if (msgQueue.isEmpty()) {
                        worker;
                        if (!running.get()) break;
                    }
                    try {
                        worker;
                        Runnable event = (Runnable)msgQueue.poll(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                        if (event == null) continue;
                        try {
                            workers.replace(this, event);
                            event.run();
                        }
                        finally {
                            workers.replace(this, IDLE);
                        }
                    }
                    catch (Throwable e) {
                        Exceptions.maybeInterrupted((Throwable)e);
                        Exceptions.trace((Throwable)e);
                    }
                }
                LOG.debug((Object)("Finished servicing bootstrap registration request queue: " + this.toString()));
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append("ServiceBootstrapWorker").append(" ").append(this.name).append(" work: ").append(workers.get(this)).append(" thread=").append(Thread.currentThread().toString());
                return builder.toString();
            }

            @Override
            public int compareTo(Worker o) {
                return this.name.compareTo(o.name);
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + this.getOuterType().hashCode();
                result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Worker other = (Worker)obj;
                if (!this.getOuterType().equals(other.getOuterType())) {
                    return false;
                }
                return !(this.name == null ? other.name != null : !this.name.equals(other.name));
            }

            private ServiceBootstrapWorker getOuterType() {
                return ServiceBootstrapWorker.this;
            }
        }
    }
}

