/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.Bootstrapper;
import com.eucalyptus.bootstrap.Provides;
import com.eucalyptus.bootstrap.RunDuring;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.MultiDatabasePropertyEntry;
import com.eucalyptus.configurable.PropertyDirectory;
import com.eucalyptus.configurable.SingletonDatabasePropertyEntry;
import com.eucalyptus.configurable.StaticPropertyEntry;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Threads;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

@Provides(value=ComponentId.class)
@RunDuring(value=Bootstrap.Stage.RemoteServicesInit)
public class DeferredPropertiesBootstrapper
extends Bootstrapper.Simple {
    private static Logger LOG = Logger.getLogger(DeferredPropertiesBootstrapper.class);

    public boolean load() throws Exception {
        Threads.lookup(Empyrean.class, DeferredPropertiesBootstrapper.class).submit(new Runnable(){

            @Override
            public void run() {
                if (Bootstrap.isShuttingDown().booleanValue()) {
                    return;
                }
                Bootstrap.awaitFinished();
                ArrayList staticProps = Lists.newArrayList();
                for (Map.Entry entry : PropertyDirectory.getPendingPropertyEntries()) {
                    ConfigurableProperty prop = (ConfigurableProperty)entry.getValue();
                    if (prop instanceof StaticPropertyEntry) {
                        staticProps.add(prop);
                        continue;
                    }
                    try {
                        ComponentId compId = ComponentIds.lookup((String)prop.getEntrySetName());
                        for (ServiceConfiguration s : ServiceConfigurations.list(compId.getClass())) {
                            if (!compId.name().equals(prop.getEntrySetName())) continue;
                            if (prop instanceof SingletonDatabasePropertyEntry) {
                                PropertyDirectory.addProperty((ConfigurableProperty)prop);
                                continue;
                            }
                            if (!(prop instanceof MultiDatabasePropertyEntry)) continue;
                            PropertyDirectory.addProperty((ConfigurableProperty)((MultiDatabasePropertyEntry)prop).getClone(s.getPartition()));
                        }
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                }
                for (ConfigurableProperty prop : staticProps) {
                    if (!PropertyDirectory.addProperty((ConfigurableProperty)prop)) continue;
                    try {
                        prop.getValue();
                    }
                    catch (Exception ex) {
                        Logs.extreme().error((Object)ex, (Throwable)ex);
                    }
                }
            }
        });
        return true;
    }
}

