/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.eucalyptus.util;

import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.configurable.PropertyChangeListeners;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import edu.ucsb.eucalyptus.util.StreamConsumer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

@ConfigurableClass(root="system.exec", description="Parameters controlling the usage of system processes.")
public class SystemUtil {
    private static Logger LOG = Logger.getLogger(SystemUtil.class);
    @ConfigurableField(description="Maximum number of concurrent processes which match any of the patterns in system.exec.restricted_concurrent_ops.", initial="2", changeListener=RestrictedOpChangeListener.class)
    public static Integer MAX_RESTRICTED_CONCURRENT_OPS = 2;
    @ConfigurableField(description="Comma-separated list of commands which are restricted by system.exec.max_restricted_concurrent_ops.", initial="dd,gunzip,tar")
    public static String RESTRICTED_CONCURRENT_OPS = "dd,gunzip,tar";
    @ConfigurableField(description="Size of IO chunks for streaming IO", initial="102400", changeListener=PropertyChangeListeners.IsPositiveInteger.class)
    public static Integer IO_CHUNK_SIZE = 102400;
    private static final AtomicBoolean acquiringPermits = new AtomicBoolean(false);
    private static final Semaphore concurrentOps = new Semaphore(MAX_RESTRICTED_CONCURRENT_OPS);
    private static final Supplier<Predicate<CharSequence>> restrictionFilter = Suppliers.memoizeWithExpiration((Supplier)new Supplier<Predicate<CharSequence>>(){

        public Predicate<CharSequence> get() {
            ArrayList restrictionFilter = Lists.newArrayList();
            for (String patternString : Arrays.asList(RESTRICTED_CONCURRENT_OPS.split(","))) {
                Predicate predicate = Predicates.containsPattern((String)patternString.trim());
                restrictionFilter.add(predicate);
            }
            return Predicates.or((Iterable)restrictionFilter);
        }
    }, (long)30L, (TimeUnit)TimeUnit.SECONDS);

    private static boolean maybeRestrictedOp(String ... command) {
        if (Iterables.any(Arrays.asList(command).subList(0, Math.min(command.length, 2)), (Predicate)((Predicate)restrictionFilter.get()))) {
            try {
                concurrentOps.acquire();
                LOG.debug((Object)("Started concurrent op: " + Joiner.on((String)" ").join((Object[])command)));
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    private static void releaseRestrictedOp(String ... command) {
        concurrentOps.release();
        LOG.debug((Object)("Ended concurrent op: " + Joiner.on((String)" ").join((Object[])command)));
    }

    public static String run(String[] command) {
        return SystemUtil.run(command, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String run(String[] command, boolean failurePossible) {
        boolean hasTicket = SystemUtil.maybeRestrictedOp(command);
        try {
            String commandString = "";
            for (String part : command) {
                commandString = commandString + part + " ";
            }
            LOG.debug((Object)("Running command: " + commandString));
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(command);
            StreamConsumer error = new StreamConsumer(proc.getErrorStream());
            StreamConsumer output = new StreamConsumer(proc.getInputStream());
            error.start();
            output.start();
            int returnValue = proc.waitFor();
            output.join();
            if (returnValue != 0) {
                if (failurePossible) {
                    String string = "";
                    return string;
                }
                throw new EucalyptusCloudException(error.getReturnValue());
            }
            String string = output.getReturnValue();
            return string;
        }
        catch (Exception t) {
            LOG.error((Object)t, (Throwable)t);
        }
        finally {
            if (hasTicket) {
                SystemUtil.releaseRestrictedOp(command);
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int runAndGetCode(String[] command) {
        boolean hasTicket = SystemUtil.maybeRestrictedOp(command);
        try {
            int returnValue;
            String commandString = "";
            for (String part : command) {
                commandString = commandString + part + " ";
            }
            LOG.debug((Object)("Running command: " + commandString));
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(command);
            StreamConsumer error = new StreamConsumer(proc.getErrorStream());
            StreamConsumer output = new StreamConsumer(proc.getInputStream());
            error.start();
            output.start();
            int n = returnValue = proc.waitFor();
            return n;
        }
        catch (Exception t) {
            LOG.error((Object)t, (Throwable)t);
        }
        finally {
            if (hasTicket) {
                SystemUtil.releaseRestrictedOp(command);
            }
        }
        return -1;
    }

    public static CommandOutput runWithRawOutput(String[] command) throws Exception {
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec(command);
        StreamConsumer error = new StreamConsumer(proc.getErrorStream());
        StreamConsumer output = new StreamConsumer(proc.getInputStream());
        error.start();
        output.start();
        int returnValue = proc.waitFor();
        output.join();
        error.join();
        return new CommandOutput(returnValue, output.getReturnValue(), error.getReturnValue());
    }

    public static void shutdownWithError(String errorMessage) {
        LOG.fatal((Object)errorMessage);
        throw new IllegalStateException(errorMessage);
    }

    public static void setEucaReadWriteOnly(String filePath) throws EucalyptusCloudException {
        File file = new File(filePath);
        try {
            file.setReadable(false, false);
            file.setWritable(false, false);
            file.setExecutable(false, false);
            file.setReadable(true, true);
            file.setWritable(true, true);
            file.setExecutable(true, true);
        }
        catch (SecurityException ex) {
            LOG.error((Object)ex);
            throw new EucalyptusCloudException((Throwable)ex);
        }
    }

    public static class CommandOutput {
        public int returnValue;
        public String output;
        public String error;

        public CommandOutput(int returnValue, String output, String error) {
            this.returnValue = returnValue;
            this.output = output;
            this.error = error;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[').append(this.returnValue).append(']').append('\n');
            if (this.output != null) {
                sb.append(this.output);
            }
            if (this.error != null) {
                sb.append(this.error);
            }
            return sb.toString();
        }

        public boolean failed() {
            return this.returnValue != 0;
        }
    }

    public static class RestrictedOpChangeListener
    implements PropertyChangeListener<String> {
        public void fireChange(ConfigurableProperty t, String newValueString) throws ConfigurablePropertyException {
            int value = Integer.parseInt(t.getValue());
            int newValue = Integer.parseInt(newValueString);
            if (newValue < 1) {
                throw new ConfigurablePropertyException(t.getDisplayName() + " must be greater than or equal to 1.");
            }
            final int permitDelta = newValue - value;
            LOG.debug((Object)("Adjust number of RESTRICTED_CONCURRENT_OPS to be: " + newValue + " from " + value + "@" + concurrentOps.availablePermits() + "/" + concurrentOps.getQueueLength() + " (" + permitDelta + ")"));
            if (permitDelta > 0) {
                concurrentOps.release(permitDelta);
            } else if (permitDelta != 0 && permitDelta < 0) {
                if (acquiringPermits.compareAndSet(false, true)) {
                    Threads.lookup(Empyrean.class).submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = 0; i < Math.abs(permitDelta); ++i) {
                                try {
                                    concurrentOps.acquire();
                                    continue;
                                }
                                catch (InterruptedException ex) {
                                    Exceptions.maybeInterrupted((Throwable)ex);
                                    break;
                                }
                            }
                            acquiringPermits.set(false);
                        }
                    });
                } else {
                    throw new ConfigurablePropertyException(t.getDisplayName() + " is still draining permits from a previous request to change the settings.  Please wait.");
                }
            }
        }
    }
}

