/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.eucalyptus.util;

import edu.ucsb.eucalyptus.util.SystemUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class StreamConsumer
extends Thread {
    private InputStream is;
    private File file;
    private String returnValue;
    private int chunkSize;

    public StreamConsumer(InputStream is) {
        this.is = is;
        this.returnValue = "";
        this.chunkSize = SystemUtil.IO_CHUNK_SIZE;
    }

    public StreamConsumer(InputStream is, int ioChunkSize) {
        this.is = is;
        this.returnValue = "";
        this.chunkSize = ioChunkSize;
    }

    public StreamConsumer(InputStream is, File file, int ioChunkSize) {
        this(is, ioChunkSize);
        this.file = file;
    }

    public StreamConsumer(InputStream is, File file) {
        this(is);
        this.file = file;
    }

    public String getReturnValue() {
        return this.returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        FilterOutputStream outStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int bytesRead;
            BufferedInputStream inStream = new BufferedInputStream(this.is);
            if (this.file != null) {
                fileOutputStream = new FileOutputStream(this.file);
                outStream = new BufferedOutputStream(fileOutputStream);
            }
            byte[] bytes = new byte[this.chunkSize];
            while ((bytesRead = inStream.read(bytes)) > 0) {
                this.returnValue = this.returnValue + new String(bytes, 0, bytesRead);
                if (outStream == null) continue;
                ((BufferedOutputStream)outStream).write(bytes, 0, bytesRead);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (outStream != null) {
                try {
                    this.is.close();
                    outStream.close();
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

