/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.eucalyptus.util;

import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.EucalyptusErrorMessageType;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class ReplyCoordinator {
    private static Logger LOG = Logger.getLogger(ReplyCoordinator.class);
    private static int MAP_CAPACITY = 64;
    private static int MAP_NUM_CONCURRENT = MAP_CAPACITY / 2;
    private static float MAP_BIN_AVG_THRESHOLD = 1.0f;
    private static long MAP_GET_WAIT_MS;
    private static long MAP_SUBMIT_SLEEP_MS;
    private long MAP_TIMEOUT_MS = 15000L;
    private ConcurrentHashMap<String, BaseMessage> replyMap = new ConcurrentHashMap(MAP_CAPACITY, MAP_BIN_AVG_THRESHOLD, MAP_NUM_CONCURRENT);
    private ConcurrentHashMap<String, String> waitList = new ConcurrentHashMap(MAP_CAPACITY, MAP_BIN_AVG_THRESHOLD, MAP_NUM_CONCURRENT);

    public ReplyCoordinator() {
    }

    public ReplyCoordinator(long user_timeout) {
        this();
        this.MAP_TIMEOUT_MS = user_timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMessage(BaseMessage msg) {
        long startTime = System.currentTimeMillis();
        String msgCorId = msg.getCorrelationId();
        while (!this.waitList.containsKey(msgCorId) && System.currentTimeMillis() - startTime < this.MAP_TIMEOUT_MS) {
            try {
                Thread.sleep(MAP_SUBMIT_SLEEP_MS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.waitList.containsKey(msgCorId)) {
            String corId;
            String string = corId = this.waitList.get(msgCorId);
            synchronized (string) {
                this.replyMap.put(corId, msg);
                corId.notifyAll();
            }
        } else {
            LOG.error((Object)"TIMEOUT: A message was returned by the system but the requesting client cannot be found, most likely timed out. ");
            LOG.error((Object)("TIMEOUT: Waited for msec=" + (System.currentTimeMillis() - startTime)));
            LOG.error((Object)("TIMEOUT: Message:" + msg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseMessage getMessage(String corId) {
        long startTime = System.currentTimeMillis();
        this.waitList.put(corId, corId);
        BaseMessage reply = null;
        String string = corId;
        synchronized (string) {
            while (!this.replyMap.containsKey(corId) && System.currentTimeMillis() - startTime < this.MAP_TIMEOUT_MS) {
                try {
                    corId.wait(MAP_GET_WAIT_MS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.waitList.remove(corId);
            if (!this.replyMap.containsKey(corId)) {
                LOG.error((Object)("TIMEOUT: Requesting client has waited for msec=" + (System.currentTimeMillis() - startTime)));
                LOG.error((Object)"TIMEOUT: Returning a message to indicate that the system hasn't finished processing yet");
                LOG.error((Object)("TIMEOUT: correlationId:" + corId));
                return new EucalyptusErrorMessageType("Looks like you are going to timeout, but we aren't done processing your request yet. Might be a slow network -- or a bug :(", "Raise the timeout value used by your client software.");
            }
            reply = this.replyMap.remove(corId);
        }
        return reply;
    }

    static {
        MAP_SUBMIT_SLEEP_MS = MAP_GET_WAIT_MS = 10L;
    }
}

