/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.eucalyptus.ic;

import com.eucalyptus.binding.BindingManager;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.EucalyptusErrorMessageType;
import edu.ucsb.eucalyptus.util.ReplyCoordinator;
import org.apache.log4j.Logger;
import org.mule.message.ExceptionMessage;

public class DNSReplyQueue {
    private static Logger LOG = Logger.getLogger(DNSReplyQueue.class);
    private static ReplyCoordinator replies = new ReplyCoordinator(3600000L);

    public void handle(BaseMessage msg) {
        Logger.getLogger(DNSReplyQueue.class).warn((Object)("storage queueing reply to " + msg.getCorrelationId()));
        replies.putMessage(msg);
    }

    public void handle(ExceptionMessage muleMsg) {
        try {
            Object requestMsg = muleMsg.getPayload();
            String requestString = requestMsg.toString();
            BaseMessage msg = (BaseMessage)BindingManager.getDefaultBinding().fromOM(requestString);
            Throwable ex = muleMsg.getException().getCause();
            EucalyptusErrorMessageType errMsg = new EucalyptusErrorMessageType(muleMsg.getComponentName(), msg, ex.getMessage());
            replies.putMessage((BaseMessage)errMsg);
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    public static BaseMessage getReply(String msgId) {
        Logger.getLogger(DNSReplyQueue.class).warn((Object)("dns request for reply to " + msgId));
        BaseMessage msg = replies.getMessage(msgId);
        Logger.getLogger(DNSReplyQueue.class).warn((Object)("dns obtained reply to " + msgId));
        return msg;
    }
}

