/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.eucalyptus.cloud.entities;

import com.eucalyptus.entities.AbstractPersistent;
import edu.ucsb.eucalyptus.cloud.entities.ARecordAddressInfo;
import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_dns")
@Table(name="ARecordNames")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class ARecordNameInfo
extends AbstractPersistent {
    @Transient
    private static final long serialVersionUID = 1L;
    @Column(name="name")
    private String name;
    @Column(name="zone")
    private String zone;
    @Column(name="recordclass")
    private Integer recordclass;
    @Column(name="ttl")
    private Long ttl;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="nameinfo")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Collection<ARecordAddressInfo> addresses = null;

    public static ARecordNameInfo newInstance(String name, String zone, Integer recordClass, Long ttl) {
        ARecordNameInfo newInstance = new ARecordNameInfo();
        newInstance.setName(name);
        newInstance.setZone(zone);
        newInstance.setRecordclass(recordClass);
        newInstance.setTtl(ttl);
        return newInstance;
    }

    public static ARecordNameInfo named(String name, String zone) {
        ARecordNameInfo newInstance = new ARecordNameInfo();
        newInstance.setName(name);
        newInstance.setZone(zone);
        return newInstance;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public Long getTtl() {
        return this.ttl;
    }

    public void setTtl(Long ttl) {
        this.ttl = ttl;
    }

    public Integer getRecordclass() {
        return this.recordclass;
    }

    public void setRecordclass(Integer recordclass) {
        this.recordclass = recordclass;
    }

    public Collection<ARecordAddressInfo> getAddresses() {
        return this.addresses;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.zone == null ? 0 : this.zone.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ARecordNameInfo other = (ARecordNameInfo)((Object)obj);
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.zone == null ? other.zone != null : !this.zone.equals(other.zone));
    }

    public String toString() {
        return String.format("A record %s", this.name);
    }
}

