/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.eucalyptus.cloud.entities;

import com.eucalyptus.entities.AbstractPersistent;
import edu.ucsb.eucalyptus.cloud.entities.ARecordNameInfo;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_dns")
@Table(name="ARecordAddresses")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class ARecordAddressInfo
extends AbstractPersistent {
    @Transient
    private static final long serialVersionUID = 1L;
    @ManyToOne
    @JoinColumn(name="metadata_name_fk", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private ARecordNameInfo nameinfo = null;
    @Column(name="address")
    private String address;
    @Column(name="unique_name", unique=true, nullable=false)
    private String uniqueName;

    private ARecordAddressInfo() {
    }

    private ARecordAddressInfo(ARecordNameInfo name, String address) {
        this.nameinfo = name;
        this.address = address;
        this.uniqueName = this.createUniqueName();
    }

    public static ARecordAddressInfo newInstance(ARecordNameInfo name, String address) {
        ARecordAddressInfo newRec = new ARecordAddressInfo(name, address);
        return newRec;
    }

    public static ARecordAddressInfo named(ARecordNameInfo name, String address) {
        return ARecordAddressInfo.newInstance(name, address);
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @PrePersist
    private void generateOnCommit() {
        if (this.uniqueName == null) {
            this.uniqueName = this.createUniqueName();
        }
    }

    protected String createUniqueName() {
        return String.format("arecord-%s-%s", this.nameinfo.getName(), this.address);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.nameinfo == null ? 0 : this.nameinfo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ARecordAddressInfo other = (ARecordAddressInfo)((Object)obj);
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        return !(this.nameinfo == null ? other.nameinfo != null : !this.nameinfo.equals((Object)other.nameinfo));
    }

    public String toString() {
        return String.format("A record address (%s-%s)", this.nameinfo != null ? this.nameinfo.getName() : "unassigned", this.address);
    }
}

