/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.upgrade;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.DatabaseAuthProvider;
import com.eucalyptus.auth.api.AccountProvider;
import com.eucalyptus.component.auth.SystemCredentials;
import com.eucalyptus.upgrade.DatabaseDestination;
import java.io.File;
import java.security.Provider;
import java.security.Security;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class StandalonePersistence {
    private static Logger LOG;
    public static String eucaHome;
    public static String eucaOld;
    public static String eucaSource;
    public static String eucaDest;
    public static File oldLibDir;
    public static File newLibDir;
    @Nonnull
    private static DatabaseDestination dest;

    public static void setupProviders() {
        DatabaseAuthProvider dbAuth = new DatabaseAuthProvider();
        Accounts.setAccountProvider((AccountProvider)dbAuth);
    }

    public static void setupNewDatabase() throws Exception {
        dest = (DatabaseDestination)ClassLoader.getSystemClassLoader().loadClass(eucaDest).newInstance();
        dest.initialize();
    }

    public static void setupInitProviders() throws Exception {
        if (!new File(SystemCredentials.getKeyStore().getFileName()).exists()) {
            throw new RuntimeException("Database upgrade must be preceded by a key upgrade.");
        }
        SystemCredentials.initialize();
        LOG.debug((Object)("Initializing SSL just in case: " + ClassLoader.getSystemClassLoader().loadClass("com.eucalyptus.crypto.util.SslSetup")));
        LOG.debug((Object)("Initializing db password: " + ClassLoader.getSystemClassLoader().loadClass("com.eucalyptus.auth.util.Hashes")));
    }

    static void setupSystemProperties() {
        System.setProperty("euca.home", eucaHome);
        System.setProperty("euca.log.appender", "upgrade");
        System.setProperty("euca.log.exhaustive.cc", "FATAL");
        System.setProperty("euca.log.exhaustive.db", "FATAL");
        System.setProperty("euca.log.exhaustive.external", "FATAL");
        System.setProperty("euca.log.exhaustive.user", "FATAL");
        System.setProperty("euca.var.dir", eucaHome + "/var/lib/eucalyptus/");
        System.setProperty("euca.conf.dir", eucaHome + "/etc/eucalyptus/cloud.d/");
        System.setProperty("euca.log.dir", eucaHome + "/var/log/eucalyptus/");
        System.setProperty("euca.lib.dir", eucaHome + "/usr/share/eucalyptus/");
        LOG = Logger.getLogger(StandalonePersistence.class);
        LOG.info((Object)String.format("%-20.20s %s", "New install directory:", eucaHome));
        LOG.info((Object)String.format("%-20.20s %s", "Old install directory:", eucaOld));
        LOG.info((Object)String.format("%-20.20s %s", "Upgrade data source:", eucaSource));
        LOG.info((Object)String.format("%-20.20s %s", "Upgrade data destination:", eucaDest));
        oldLibDir = StandalonePersistence.getAndCheckLibDirectory(eucaOld);
        newLibDir = StandalonePersistence.getAndCheckLibDirectory(eucaHome);
    }

    private static File getAndCheckLibDirectory(String eucaHome) {
        if (eucaHome == null) {
            throw new RuntimeException("The source directory has not been specified.");
        }
        File eucaLibDir = new File(eucaHome, "usr/share/eucalyptus");
        if (!eucaLibDir.exists()) {
            throw new RuntimeException("The source directory does not exist: " + eucaLibDir.getPath());
        }
        return eucaLibDir;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

