/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.upgrade;

import com.eucalyptus.bootstrap.DatabaseBootstrapper;
import com.eucalyptus.component.Component;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.ServiceUris;
import com.eucalyptus.component.id.Database;
import com.eucalyptus.entities.PersistenceContexts;
import com.eucalyptus.scripting.Groovyness;
import com.eucalyptus.upgrade.DatabaseDestination;
import com.eucalyptus.util.Exceptions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.hibernate.ejb.Ejb3Configuration;

public class PostgresqlDestination
implements DatabaseDestination {
    private static Logger LOG = Logger.getLogger(PostgresqlDestination.class);
    private DatabaseBootstrapper db;

    @Override
    public DatabaseBootstrapper getDb() throws Exception {
        return this.db;
    }

    @Override
    public void initialize() throws Exception {
        Component dbComp = Components.lookup(Database.class);
        this.db = (DatabaseBootstrapper)Groovyness.newInstance((String)"setup_db");
        try {
            this.db.load();
            ImmutableMap props = ImmutableMap.builder().put((Object)"hibernate.show_sql", (Object)"false").put((Object)"hibernate.format_sql", (Object)"false").put((Object)"hibernate.connection.autocommit", (Object)"false").put((Object)"hibernate.hbm2ddl.auto", (Object)"update").put((Object)"hibernate.generate_statistics", (Object)"false").put((Object)"hibernate.connection.driver_class", (Object)this.db.getDriverName()).put((Object)"hibernate.connection.username", (Object)this.db.getUserName()).put((Object)"hibernate.connection.password", (Object)this.db.getPassword()).put((Object)"hibernate.bytecode.use_reflection_optimizer", (Object)"true").put((Object)"hibernate.cglib.use_reflection_optimizer", (Object)"true").put((Object)"hibernate.dialect", (Object)this.db.getHibernateDialect()).put((Object)"hibernate.cache.use_second_level_cache", (Object)"false").put((Object)"hibernate.cache.use_query_cache", (Object)"false").build();
            for (String ctx : PersistenceContexts.list()) {
                Properties p = new Properties();
                p.putAll((Map<?, ?>)props);
                String ctxUrl = String.format("jdbc:%s", ServiceUris.remote((Component)dbComp, (String[])new String[]{ctx}));
                p.put("hibernate.connection.url", ctxUrl);
                Ejb3Configuration config = new Ejb3Configuration();
                config.setProperties(p);
                for (Class c : PersistenceContexts.listEntities((String)ctx)) {
                    config.addAnnotatedClass(c);
                }
                PersistenceContexts.registerPersistenceContext((String)ctx, (Ejb3Configuration)config);
            }
        }
        catch (Exception e) {
            LOG.fatal((Object)e, (Throwable)e);
            LOG.fatal((Object)"Failed to initialize the persistence layer.");
            throw Exceptions.toUndeclared((Throwable)e);
        }
    }
}

