/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.eucalyptus.msgs;

import com.eucalyptus.system.Ats;
import com.eucalyptus.util.MessageValidation;
import com.eucalyptus.util.Pair;
import edu.ucsb.eucalyptus.msgs.EucalyptusData;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.regex.Pattern;

public class ComputeMessageValidation {

    public static enum FieldRegexValue {
        STRING_128("(?s).{1,128}"),
        STRING_255("(?s).{1,255}"),
        CIDR("(?:(?:[0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}(?:[0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])/(?:[0-9]|[12][0-9]|3[0-2])"),
        IP_ADDRESS("(?:(?:[0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}(?:[0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])"),
        EC2_PROTOCOL("icmp|tcp|udp|-1|[0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]"),
        EC2_ACL_ACTION("allow|deny"),
        EC2_ACCOUNT_OR_CIDR("[0-9]{12}|(?:(?:[0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}(?:[0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])/(?:[0-9]|[12][0-9]|3[0-2])");

        private final Pattern pattern;

        private FieldRegexValue(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        public Pattern pattern() {
            return this.pattern;
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface FieldRange {
        public long min() default 0L;

        public long max() default 0x7FFFFFFFFFFFFFFFL;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface FieldRegex {
        public FieldRegexValue value();
    }

    public static class ComputeMessageValidationAssistant
    implements MessageValidation.ValidationAssistant {
        @Override
        public boolean validate(Object object) {
            return object instanceof EucalyptusData;
        }

        @Override
        public Pair<Long, Long> range(Ats ats) {
            FieldRange range = ats.get(FieldRange.class);
            return range == null ? null : Pair.pair(range.min(), range.max());
        }

        @Override
        public Pattern regex(Ats ats) {
            FieldRegex regex = ats.get(FieldRegex.class);
            return regex == null ? null : regex.value().pattern();
        }
    }
}

