/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.eucalyptus.msgs;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.RoleUser;
import com.eucalyptus.context.Context;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import edu.ucsb.eucalyptus.msgs.BaseCallerContext;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.EvaluatedIamConditionKey;
import java.util.Map;

public class CallerContext {
    private final String identity;
    private final boolean privileged;
    private final Map<String, String> evaluatedKeys;

    public CallerContext(Context context) throws AuthException {
        this.identity = context.getUser() instanceof RoleUser ? ((RoleUser)context.getUser()).getRoleId() : context.getUser().getUserId();
        this.privileged = context.isPrivileged();
        this.evaluatedKeys = context.evaluateKeys();
    }

    public void apply(BaseMessage message) {
        message.setUserId(this.identity);
        if (this.privileged) {
            message.markPrivileged();
        }
        message.setCallerContext(new BaseCallerContext(Lists.newArrayList((Iterable)Iterables.transform(this.evaluatedKeys.entrySet(), (Function)MapEntryToEvaluatedIamConditionKey.INSTANCE))));
    }

    private static enum MapEntryToEvaluatedIamConditionKey implements Function<Map.Entry<String, String>, EvaluatedIamConditionKey>
    {
        INSTANCE;


        public EvaluatedIamConditionKey apply(Map.Entry<String, String> entry) {
            return new EvaluatedIamConditionKey(entry.getKey(), entry.getValue());
        }
    }
}

