/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.eucalyptus.msgs;

import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.io.IOException;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

public class BaseMessages {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static <T extends BaseMessage> T deepCopy(T message) throws IOException {
        return (T)BaseMessages.deepCopy(message, message.getClass());
    }

    public static <T extends BaseMessage, R extends BaseMessage> R deepCopy(T message, Class<R> resultType) throws IOException {
        return (R)((BaseMessage)mapper.readValue(mapper.valueToTree(message), resultType));
    }

    static {
        mapper.getSerializationConfig().addMixInAnnotations(BaseMessage.class, BaseMessageMixIn.class);
        mapper.getDeserializationConfig().addMixInAnnotations(BaseMessage.class, BaseMessageMixIn.class);
        mapper.getSerializationConfig().set(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
    }

    @JsonIgnoreProperties(value={"correlationId", "effectiveUserId", "reply", "statusMessage", "userId"})
    private static final class BaseMessageMixIn {
        private BaseMessageMixIn() {
        }
    }
}

