/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.eucalyptus.msgs;

import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.binding.BindingManager;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.empyrean.ServiceId;
import com.eucalyptus.http.MappingHttpMessage;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.Classes;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import edu.ucsb.eucalyptus.msgs.BaseCallerContext;
import edu.ucsb.eucalyptus.msgs.BaseMessageMarker;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.UUID;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.JiBXException;

public class BaseMessage
implements BaseMessageMarker {
    @Transient
    private static Logger LOG = Logger.getLogger(BaseMessage.class);
    private String correlationId;
    private String userId;
    private String effectiveUserId;
    private BaseCallerContext callerContext;
    private Boolean _return = true;
    private String statusMessage;
    private Integer _epoch;
    private ArrayList<ServiceId> _services = Lists.newArrayList();
    private ArrayList<ServiceId> _disabledServices = Lists.newArrayList();
    private ArrayList<ServiceId> _notreadyServices = Lists.newArrayList();
    private ArrayList<ServiceId> _stoppedServices = Lists.newArrayList();

    public BaseMessage() {
        this.correlationId = UUID.randomUUID().toString();
    }

    public BaseMessage(String userId) {
        this();
        this.userId = userId;
        this.effectiveUserId = userId;
        this.statusMessage = null;
    }

    public BaseMessage(BaseMessage copy) {
        this();
        this.effectiveUserId = copy != null ? copy.getEffectiveUserId() : null;
        this.correlationId = copy != null ? copy.getCorrelationId() : null;
    }

    public String getCorrelationId() {
        if (this.correlationId == null) {
            Logger.getLogger((String)"EXHAUST").error((Object)Exceptions.filterStackTrace(new RuntimeException("Creating UUID for message which did not have it set correctly: " + this.getClass())));
            this.correlationId = UUID.randomUUID().toString();
            return this.correlationId;
        }
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    @Deprecated
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Deprecated
    public String getUserId() {
        return this.userId;
    }

    public Boolean get_return() {
        return this._return;
    }

    public <TYPE extends BaseMessage> TYPE markWinning() {
        this._return = true;
        return (TYPE)this;
    }

    public <TYPE extends BaseMessage> TYPE markFailed() {
        this._return = false;
        return (TYPE)this;
    }

    public <TYPE extends BaseMessage> TYPE markPrivileged() {
        this.effectiveUserId = Principals.systemUser().getName();
        return (TYPE)this;
    }

    public <TYPE extends BaseMessage> TYPE markUnprivileged() {
        this.effectiveUserId = this.userId;
        return (TYPE)this;
    }

    public void set_return(Boolean return1) {
        this._return = return1;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    @Deprecated
    public void setEffectiveUserId(String effectiveUserId) {
        this.effectiveUserId = effectiveUserId;
    }

    public String getEffectiveUserId() {
        return this.effectiveUserId;
    }

    public BaseCallerContext getCallerContext() {
        return this.callerContext;
    }

    public void setCallerContext(BaseCallerContext callerContext) {
        this.callerContext = callerContext;
    }

    public <TYPE extends BaseMessage> TYPE regarding() {
        this.regarding(null);
        return (TYPE)this;
    }

    public <TYPE extends BaseMessage> TYPE regarding(BaseMessage msg) {
        this.correlationId = UUID.randomUUID().toString();
        this.userId = Principals.systemFullName().getUserName();
        this.effectiveUserId = Principals.systemFullName().getUserName();
        return (TYPE)this;
    }

    public <TYPE extends BaseMessage> TYPE regardingUserRequest(BaseMessage msg) {
        this.userId = msg.userId;
        return (TYPE)this;
    }

    public <TYPE extends BaseMessage> TYPE lookupAndSetCorrelationId() {
        String corrId = null;
        try {
            corrId = Contexts.lookup().getCorrelationId();
        }
        catch (Exception ex) {
            corrId = Threads.getCorrelationId();
        }
        if (corrId != null && corrId.length() >= 36) {
            return this.regardingRequestId(corrId);
        }
        return (TYPE)this;
    }

    public <TYPE extends BaseMessage> TYPE regardingRequestId(String msgId) {
        if (msgId != null) {
            String requestId = null;
            String postfix = null;
            if (!msgId.contains("::")) {
                postfix = requestId = msgId;
            } else {
                requestId = msgId.substring(0, msgId.indexOf("::"));
                postfix = msgId.substring(msgId.indexOf("::") + 2);
            }
            String uuid = null;
            try {
                String baseHex = postfix.substring(9, 13);
                Integer baseHexInt = Integer.parseInt(baseHex, 16);
                Integer newHexInt = (baseHexInt + 1) % 65536;
                String newHex = Integer.toHexString(newHexInt);
                while (newHex.length() < 4) {
                    newHex = "0" + newHex;
                }
                uuid = UUID.randomUUID().toString();
                uuid = uuid.substring(0, 9) + newHex + uuid.substring(13);
            }
            catch (Exception ex) {
                uuid = UUID.randomUUID().toString();
            }
            this.correlationId = String.format("%s::%s", requestId, uuid);
        }
        return (TYPE)this;
    }

    public boolean hasRequestId() {
        return this.correlationId != null && this.correlationId.indexOf("::") > 0;
    }

    public String toString() {
        String str = this.toString(BindingManager.defaultBindingName());
        str = str != null ? str : this.toString("eucalyptus_ucsb_edu");
        str = str != null ? str : "Failed to bind message of type: " + this.getClass().getName() + " at " + Thread.currentThread().getStackTrace()[1].toString();
        return str;
    }

    public String toString(String namespace) {
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        Class targetClass = (Class)Iterables.find(Classes.classAncestors(this), (Predicate)new Predicate<Class>(){

            public boolean apply(Class arg0) {
                return !arg0.isAnonymousClass();
            }
        });
        try {
            IBindingFactory bindingFactory = BindingDirectory.getFactory((String)namespace, (Class)targetClass);
            IMarshallingContext mctx = bindingFactory.createMarshallingContext();
            mctx.setIndent(2);
            mctx.marshalDocument((Object)this, "UTF-8", null, (OutputStream)temp);
        }
        catch (JiBXException e) {
            Logger.getLogger(BaseMessage.class).debug((Object)e, (Throwable)e);
        }
        catch (Exception e) {
            Logger.getLogger(BaseMessage.class).error((Object)e, (Throwable)e);
        }
        return temp.toString();
    }

    public <TYPE extends BaseMessage> TYPE getReply() {
        Class<?> msgClass = this.getClass();
        while (!msgClass.getSimpleName().endsWith("Type")) {
            msgClass = msgClass.getSuperclass();
        }
        String replyType = msgClass.getName().replaceAll("Type$", "") + "ResponseType";
        try {
            Class<?> responseClass = ClassLoader.getSystemClassLoader().loadClass(replyType);
            return (TYPE)this.reply((BaseMessage)responseClass.newInstance());
        }
        catch (Exception e) {
            Logger.getLogger(BaseMessage.class).debug((Object)e, (Throwable)e);
            throw new TypeNotPresentException(this.correlationId, e);
        }
    }

    protected <TYPE extends BaseMessage> TYPE reply(TYPE reply) {
        reply.setCorrelationId(this.correlationId);
        return reply;
    }

    public String toSimpleString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName()).append(":").append(this.correlationId).append(":return=").append(this.get_return()).append(":epoch=").append(this.get_epoch()).append(":status=").append(this.getStatusMessage());
        return buf.toString();
    }

    public Integer get_epoch() {
        return this._epoch;
    }

    public void set_epoch(Integer epoch) {
        this._epoch = epoch;
    }

    public ArrayList<ServiceId> get_services() {
        return this._services;
    }

    public void set_services(ArrayList<ServiceId> services) {
        this._services = services;
    }

    public static <T extends BaseMessage> T extractMessage(ChannelEvent e) {
        if (e instanceof MessageEvent) {
            MessageEvent msge = (MessageEvent)e;
            MappingHttpMessage msgHttp = null;
            if (msge.getMessage() instanceof BaseMessage) {
                return (T)((BaseMessage)msge.getMessage());
            }
            if (msge.getMessage() instanceof MappingHttpMessage && (msgHttp = (MappingHttpMessage)((Object)msge.getMessage())).getMessage() instanceof BaseMessage) {
                return (T)((BaseMessage)msgHttp.getMessage());
            }
            if (msge.getMessage() instanceof Supplier && ((Supplier)msge.getMessage()).get() instanceof BaseMessage) {
                return (T)((BaseMessage)((Supplier)msge.getMessage()).get());
            }
            return null;
        }
        return null;
    }

    public BaseMessage setUser(User user) {
        if (user == null) {
            this.setUser(Principals.nobodyUser());
        } else {
            this.userId = user.getName();
            this.effectiveUserId = user.isSystemAdmin() ? Principals.systemUser().getName() : user.getName();
        }
        return this;
    }

    public ArrayList<ServiceId> get_disabledServices() {
        return this._disabledServices;
    }

    public void set_disabledServices(ArrayList<ServiceId> _disabledServices) {
        this._disabledServices = _disabledServices;
    }

    public ArrayList<ServiceId> get_notreadyServices() {
        return this._notreadyServices;
    }

    public void set_notreadyServices(ArrayList<ServiceId> _notreadyServices) {
        this._notreadyServices = _notreadyServices;
    }

    public ArrayList<ServiceId> get_stoppedServices() {
        return this._stoppedServices;
    }

    public void set_stoppedServices(ArrayList<ServiceId> _stoppedServices) {
        this._stoppedServices = _stoppedServices;
    }
}

