/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.eucalyptus.msgs;

import com.eucalyptus.ws.StackConfiguration;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.DynamicChannelBuffer;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunk;

public class BaseDataChunk
extends DefaultHttpChunk {
    @Transient
    private static Logger LOG = Logger.getLogger(BaseDataChunk.class);
    private String correlationId;

    public BaseDataChunk() {
        super((ChannelBuffer)new DynamicChannelBuffer(StackConfiguration.HTTP_MAX_CHUNK_BYTES.intValue()));
    }

    public BaseDataChunk(BaseDataChunk copy) {
        super(copy.getContent());
        this.correlationId = copy != null ? copy.getCorrelationId() : null;
    }

    public BaseDataChunk(HttpChunk copy, String correlationId) {
        super(copy.getContent());
        this.correlationId = correlationId;
    }

    public BaseDataChunk(ChannelBuffer readBytes) {
        super(readBytes);
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String toSimpleString() {
        StringBuilder buf = new StringBuilder();
        buf.append(((Object)((Object)this)).getClass().getSimpleName()).append(":").append(this.correlationId).append(":capacity").append(this.getContent().capacity()).append(":islast=").append(this.isLast());
        return buf.toString();
    }

    public static <T extends BaseDataChunk> T extractChunk(ChannelEvent e) {
        if (e instanceof MessageEvent) {
            MessageEvent msge = (MessageEvent)e;
            if (msge.getMessage() instanceof BaseDataChunk) {
                BaseDataChunk chunk = (BaseDataChunk)((Object)msge.getMessage());
                return (T)((Object)chunk);
            }
            return null;
        }
        return null;
    }
}

