/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.eucalyptus.cloud.entities;

import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.util.DNSProperties;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.net.InternetDomainName;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.apache.http.conn.util.InetAddressUtils;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_general")
@Table(name="system_info")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@ConfigurableClass(root="system.dns", description="Basic system configuration.")
@Deprecated
public class SystemConfiguration
extends AbstractPersistent {
    private static Logger LOG = Logger.getLogger(SystemConfiguration.class);
    private static final Supplier<SystemConfiguration> systemConfigurationSupplier = Suppliers.memoizeWithExpiration((Supplier)SystemConfigurationSupplier.INSTANCE, (long)5L, (TimeUnit)TimeUnit.SECONDS);
    @ConfigurableField(description="Unique ID of this cloud installation.", readonly=false)
    @Column(name="system_registration_id")
    private String registrationId;
    @Deprecated
    @ConfigurableField(description="Domain name to use for DNS.", changeListener=DomainNamePropertyChangeListener.class)
    @Column(name="dns_domain")
    private String dnsDomain;
    @Deprecated
    @ConfigurableField(description="Nameserver hostname.")
    @Column(name="nameserver")
    private String nameserver;
    @Deprecated
    @ConfigurableField(description="Nameserver ip address.", changeListener=SystemConfigurationNameServerChangeListener.class)
    @Column(name="ns_address")
    private String nameserverAddress;

    public SystemConfiguration() {
    }

    public SystemConfiguration(String dnsDomain, String nameserver, String nameserverAddress) {
        this.dnsDomain = dnsDomain;
        this.nameserver = nameserver;
        this.nameserverAddress = nameserverAddress;
    }

    public String getRegistrationId() {
        return this.registrationId;
    }

    public void setRegistrationId(String registrationId) {
        this.registrationId = registrationId;
    }

    @Deprecated
    public String getDnsDomain() {
        return this.dnsDomain;
    }

    @Deprecated
    public void setDnsDomain(String dnsDomain) {
        this.dnsDomain = dnsDomain;
    }

    @Deprecated
    public String getNameserver() {
        return this.nameserver;
    }

    @Deprecated
    public void setNameserver(String nameserver) {
        this.nameserver = nameserver;
    }

    @Deprecated
    public String getNameserverAddress() {
        return this.nameserverAddress;
    }

    @Deprecated
    public void setNameserverAddress(String nameserverAddress) {
        this.nameserverAddress = nameserverAddress;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.registrationId == null ? 0 : this.registrationId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SystemConfiguration other = (SystemConfiguration)obj;
        return !(this.registrationId == null ? other.registrationId != null : !this.registrationId.equals(other.registrationId));
    }

    public static SystemConfiguration getSystemConfiguration() {
        return (SystemConfiguration)systemConfigurationSupplier.get();
    }

    private static SystemConfiguration validateSystemConfiguration(SystemConfiguration s) {
        SystemConfiguration sysConf;
        SystemConfiguration systemConfiguration = sysConf = s != null ? s : new SystemConfiguration();
        if (sysConf.getRegistrationId() == null) {
            sysConf.setRegistrationId(UUID.randomUUID().toString());
        }
        if (sysConf.getDnsDomain() == null) {
            sysConf.setDnsDomain(DNSProperties.DOMAIN);
        }
        if (sysConf.getNameserver() == null) {
            sysConf.setNameserver(DNSProperties.NS_HOST);
        }
        if (sysConf.getNameserverAddress() == null) {
            sysConf.setNameserverAddress(DNSProperties.NS_IP);
        }
        return sysConf;
    }

    private static enum SystemConfigurationSupplier implements Supplier<SystemConfiguration>
    {
        INSTANCE;


        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public SystemConfiguration get() {
            try {
                try (TransactionResource db = Entities.transactionFor(SystemConfiguration.class);){
                    SystemConfiguration conf = Entities.uniqueResult(new SystemConfiguration());
                    SystemConfiguration.validateSystemConfiguration(conf);
                    db.commit();
                    SystemConfiguration systemConfiguration = conf;
                    return systemConfiguration;
                }
                catch (NoSuchElementException e) {
                    try (TransactionResource db2 = Entities.transactionFor(SystemConfiguration.class);){
                        LOG.warn((Object)"Failed to get system configuration. Loading defaults.");
                        SystemConfiguration conf = SystemConfiguration.validateSystemConfiguration(null);
                        Entities.persist(conf);
                        db2.commit();
                        SystemConfiguration systemConfiguration = conf;
                        return systemConfiguration;
                    }
                }
            }
            catch (Exception t) {
                LOG.error((Object)"Unable to get system configuration.", (Throwable)t);
                return SystemConfiguration.validateSystemConfiguration(null);
            }
        }
    }

    public static final class DomainNamePropertyChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            if (newValue == null || !InternetDomainName.isValid((String)String.valueOf(newValue))) {
                throw new ConfigurablePropertyException("Invalid name (" + newValue + ")");
            }
        }
    }

    public static class SystemConfigurationNameServerChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            try {
                String value;
                if (newValue instanceof String && !(value = (String)newValue).equals("")) {
                    if (value.contains(",")) {
                        for (String entry : value.split(",")) {
                            if (InetAddressUtils.isIPv4Address((String)entry)) continue;
                            throw new ConfigurablePropertyException("Malformed domain name server list");
                        }
                    } else if (!InetAddressUtils.isIPv4Address((String)value)) {
                        throw new ConfigurablePropertyException("Malformed domain name server list");
                    }
                }
            }
            catch (Exception e) {
                throw new ConfigurablePropertyException("Malformed domain name server list");
            }
        }
    }
}

