/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.util;

import com.eucalyptus.binding.BindingManager;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.system.Ats;
import com.eucalyptus.ws.EucalyptusWebServiceException;
import com.eucalyptus.ws.WebServicesException;
import com.eucalyptus.ws.protocol.QueryBindingInfo;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.ExceptionResponseType;
import edu.ucsb.eucalyptus.msgs.HasRequest;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.mule.RequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleException;
import org.mule.message.ExceptionMessage;

public class ReplyQueue {
    private static Logger LOG = Logger.getLogger(ReplyQueue.class);

    public String handle(BaseMessage responseMessage) {
        Contexts.response(responseMessage);
        return "";
    }

    public void handle(ExceptionMessage exMsg) {
        Throwable cause = exMsg.getException();
        if (cause instanceof MessagingException) {
            MessagingException messagingEx = (MessagingException)cause;
            cause = messagingEx.getCause();
            Object payload = exMsg.getPayload();
            BaseMessage msg = this.convert(payload);
            if (msg != null) {
                if (cause instanceof EucalyptusWebServiceException) {
                    QueryBindingInfo info = Ats.inClassHierarchy(cause.getClass()).get(QueryBindingInfo.class);
                    HttpResponseStatus status = info == null ? HttpResponseStatus.INTERNAL_SERVER_ERROR : new HttpResponseStatus(info.statusCode(), "");
                    Contexts.response(new ExceptionResponseType(msg, ((EucalyptusWebServiceException)cause).getCode(), cause.getMessage(), status, cause));
                } else {
                    Contexts.response(new ExceptionResponseType(msg, cause.getMessage(), HttpResponseStatus.NOT_ACCEPTABLE, cause));
                }
            } else {
                LOG.error((Object)("Failed to identify request context for received error: " + exMsg.toString()));
                cause = new WebServicesException("Failed to identify request context for received error: " + exMsg.toString() + " while handling error: " + cause.getMessage(), cause, HttpResponseStatus.NOT_ACCEPTABLE);
                Contexts.responseError(cause);
            }
        } else if (cause instanceof MuleException) {
            LOG.error((Object)("Error service request: " + cause.getMessage()), cause);
            cause = new WebServicesException(cause.getMessage(), cause, HttpResponseStatus.NOT_FOUND);
            Contexts.responseError(cause);
        } else {
            Contexts.responseError(cause);
        }
    }

    private BaseMessage convert(Object payload) {
        BaseMessage ret = null;
        if (payload instanceof BaseMessage) {
            ret = (BaseMessage)payload;
        } else if (payload instanceof HasRequest) {
            ret = ((HasRequest)payload).getRequest();
        } else if (payload instanceof String) {
            try {
                ret = (BaseMessage)BindingManager.getDefaultBinding().fromOM((String)payload);
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        } else {
            payload = RequestContext.getEvent().getMessage().getPayload();
            if (payload instanceof BaseMessage) {
                ret = (BaseMessage)payload;
            } else if (payload instanceof String) {
                try {
                    ret = (BaseMessage)BindingManager.getDefaultBinding().fromOM((String)payload);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        }
        return ret;
    }
}

