/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.util;

import com.eucalyptus.auth.login.AuthenticationException;
import com.eucalyptus.crypto.Hmac;
import com.eucalyptus.crypto.util.SecurityHeader;
import com.eucalyptus.crypto.util.SecurityParameter;
import com.eucalyptus.crypto.util.Timestamps;
import com.eucalyptus.util.Strings;
import com.eucalyptus.ws.protocol.RequiredQueryParams;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;

public class HmacUtils {
    private static final Logger LOG = Logger.getLogger(HmacUtils.class);
    private static final List<String> PARAMETERS_V1 = ImmutableList.of((Object)RequiredQueryParams.SignatureVersion.toString(), (Object)SecurityParameter.Signature.parameter(), (Object)SecurityParameter.AWSAccessKeyId.parameter());
    private static final List<String> PARAMETERS_V2 = ImmutableList.of((Object)RequiredQueryParams.SignatureVersion.toString(), (Object)SecurityParameter.SignatureMethod.parameter(), (Object)SecurityParameter.Signature.parameter(), (Object)SecurityParameter.AWSAccessKeyId.parameter());
    private static final List<String> PARAMETERS_V4_QUERY = ImmutableList.of((Object)SecurityParameter.X_Amz_Algorithm.parameter(), (Object)SecurityParameter.X_Amz_Algorithm.parameter(), (Object)SecurityParameter.X_Amz_Signature.parameter(), (Object)SecurityParameter.X_Amz_SignedHeaders.parameter());

    public static Function<String, List<String>> headerLookup(Map<String, List<String>> values) {
        return HmacUtils.forMap(values, Strings.lower());
    }

    public static Function<String, List<String>> parameterLookup(Map<String, List<String>> values) {
        return HmacUtils.forMap(values, (Function<String, String>)Functions.identity());
    }

    private static Function<String, List<String>> forMap(Map<String, List<String>> values, Function<String, String> keyConversion) {
        return Functions.compose((Function)Functions.forMap(values, Collections.emptyList()), keyConversion);
    }

    @Nonnull
    public static SignatureVariant detectSignatureVariant(@Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
        SignatureVariant variant;
        if (SecurityHeader.Value.AWS4_HMAC_SHA256.matches(HmacUtils.lookupUnique(headerLookup, "header", "Authorization"))) {
            variant = SignatureVariant.SignatureV4Standard;
        } else if (HmacUtils.lookupUnique(parameterLookup, "parameter", SecurityParameter.X_Amz_Algorithm.parameter()) != null || HmacUtils.lookupUnique(parameterLookup, "parameter", SecurityParameter.X_Amz_Date.parameter()) != null) {
            variant = SignatureVariant.SignatureV4Query;
        } else {
            String signatureVersion = HmacUtils.lookupUnique(parameterLookup, "parameter", RequiredQueryParams.SignatureVersion.toString());
            if ("1".equals(signatureVersion)) {
                variant = SignatureVariant.SignatureV1Standard;
            } else if ("2".equals(signatureVersion) || signatureVersion == null) {
                variant = SignatureVariant.SignatureV2Standard;
            } else {
                throw new AuthenticationException("Unsupported signature version " + signatureVersion);
            }
        }
        return variant;
    }

    public static boolean hasSignatureDate(@Nonnull EnumSet<SignatureVersion> versions, @Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
        return HmacUtils.getSignatureDateInternal(versions, headerLookup, parameterLookup) != null;
    }

    @Nonnull
    public static Date getSignatureDate(@Nonnull EnumSet<SignatureVersion> versions, @Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
        Date signatureDate = HmacUtils.getSignatureDateInternal(versions, headerLookup, parameterLookup);
        if (signatureDate == null) {
            throw new AuthenticationException("Date not found.");
        }
        return signatureDate;
    }

    public static byte[] getSignature(String key, String subject, Hmac mac) throws AuthenticationException {
        SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(Charsets.UTF_8), mac.toString());
        try {
            Mac digest = mac.getInstance();
            digest.init(signingKey);
            return digest.doFinal(subject.getBytes(Charsets.UTF_8));
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new AuthenticationException("Failed to compute signature");
        }
    }

    private static String lookupUnique(Function<String, List<String>> lookup, String type, String name) throws AuthenticationException {
        String result = null;
        Iterable values = (Iterable)lookup.apply((Object)name);
        if (values != null) {
            for (String value : values) {
                if (result == null) {
                    result = value;
                    continue;
                }
                if (value == null || value.equals(result)) continue;
                throw new AuthenticationException("Duplicate " + type + " for " + name + " with incorrect value " + value + ", expected " + result);
            }
        }
        return result;
    }

    private static String lookupUniqueRequired(Function<String, List<String>> lookup, String type, String name) throws AuthenticationException {
        String value = HmacUtils.lookupUnique(lookup, type, name);
        if (value == null) {
            throw new AuthenticationException("Missing required parameter: " + name);
        }
        return value;
    }

    @Nullable
    private static Date getSignatureDateInternal(@Nonnull EnumSet<SignatureVersion> versions, @Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
        SignatureVariant variant = HmacUtils.detectSignatureVariant(headerLookup, parameterLookup);
        if (!versions.contains((Object)variant.getVersion())) {
            return null;
        }
        return variant.getTimestamp(headerLookup, parameterLookup);
    }

    public static class SignatureCredential {
        @Nonnull
        private final String accessKeyId;
        @Nonnull
        private final String date;
        @Nonnull
        private final String region;
        @Nonnull
        private final String serviceName;
        @Nonnull
        private final String terminator;

        public SignatureCredential(@Nonnull String credential) throws AuthenticationException {
            String[] credentialParts = credential.trim().split("/");
            if (credentialParts.length != 5) {
                throw new AuthenticationException("Invalid credential (missing part): [" + credential + "]");
            }
            this.accessKeyId = credentialParts[0];
            this.date = credentialParts[1];
            this.region = credentialParts[2];
            this.serviceName = credentialParts[3];
            this.terminator = credentialParts[4];
        }

        public void verify(@Nonnull Date timestamp, @Nullable String region, @Nullable String serviceName, @Nullable String terminator) throws AuthenticationException {
            String expectedDate = Timestamps.formatShortIso8601Date(timestamp);
            this.internalVerify("date", expectedDate, this.date);
            this.internalVerify("region", region, this.region);
            this.internalVerify("service name", serviceName, this.serviceName);
            this.internalVerify("termination string", terminator, this.terminator);
        }

        private void internalVerify(String what, String expect, String value) throws AuthenticationException {
            if (expect != null && !expect.equals(value)) {
                throw new AuthenticationException("Expected " + what + " does not match credential " + what + " [" + expect + " != " + value + "]");
            }
        }

        @Nonnull
        public String getAccessKeyId() {
            return this.accessKeyId;
        }

        @Nonnull
        public String getDate() {
            return this.date;
        }

        @Nonnull
        public String getRegion() {
            return this.region;
        }

        @Nonnull
        public String getServiceName() {
            return this.serviceName;
        }

        @Nonnull
        public String getTerminator() {
            return this.terminator;
        }

        @Nonnull
        public String getCredentialScope() {
            return this.date + "/" + this.region + "/" + this.serviceName + "/" + this.terminator;
        }
    }

    public static enum SignatureVersion {
        SignatureV1(1),
        SignatureV2(2),
        SignatureV4(4);

        private int value;

        private SignatureVersion(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum SignatureVariant {
        SignatureV1Standard(SignatureVersion.SignatureV1){

            @Override
            protected Date getTimestamp(@Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
                return SignatureVariant.getSignatureDateFrom("parameter", (Function<String, List<String>>)parameterLookup, SecurityParameter.Timestamp.parameter(), Timestamps.Type.ISO_8601);
            }

            @Override
            public Collection<String> getParametersToRemove() {
                return PARAMETERS_V1;
            }

            @Override
            public Collection<String> getDateParametersToRemove() {
                return Collections.singleton(SecurityParameter.Timestamp.parameter());
            }

            @Override
            public String getSignature(@Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
                return HmacUtils.lookupUniqueRequired((Function<String, List<String>>)parameterLookup, "parameter", SecurityParameter.Signature.parameter());
            }

            @Override
            public String getAccessKeyId(@Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
                return HmacUtils.lookupUniqueRequired((Function<String, List<String>>)parameterLookup, "parameter", SecurityParameter.AWSAccessKeyId.parameter());
            }

            @Override
            public Hmac getSignatureMethod(@Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
                return Hmac.HmacSHA1;
            }

            @Override
            public Map<String, String> getAuthorizationParameters(@Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
                throw new AuthenticationException("Authorization parameters not found");
            }

            @Override
            public String getSecurityToken(@Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
                return HmacUtils.lookupUnique((Function<String, List<String>>)parameterLookup, "parameter", SecurityParameter.SecurityToken.parameter());
            }
        }
        ,
        SignatureV2Standard(SignatureVersion.SignatureV2){

            @Override
            protected Date getTimestamp(@Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
                return SignatureV1Standard.getTimestamp(headerLookup, parameterLookup);
            }

            @Override
            public Collection<String> getParametersToRemove() {
                return PARAMETERS_V2;
            }

            @Override
            public Collection<String> getDateParametersToRemove() {
                return SignatureV1Standard.getDateParametersToRemove();
            }

            @Override
            public String getSignature(@Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
                return SignatureV1Standard.getSignature(headerLookup, parameterLookup);
            }

            @Override
            public String getAccessKeyId(@Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
                return SignatureV1Standard.getAccessKeyId(headerLookup, parameterLookup);
            }

            @Override
            public Hmac getSignatureMethod(@Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
                String sigMethod = HmacUtils.lookupUnique((Function<String, List<String>>)parameterLookup, "parameter", SecurityParameter.SignatureMethod.parameter());
                sigMethod = sigMethod == null ? "HMACSHA1" : sigMethod;
                try {
                    return Hmac.valueOf("HmacSHA" + sigMethod.substring(7));
                }
                catch (IllegalArgumentException e) {
                    throw new AuthenticationException("Invalid signature method: " + sigMethod);
                }
            }

            @Override
            public Map<String, String> getAuthorizationParameters(@Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
                return SignatureV1Standard.getAuthorizationParameters(headerLookup, parameterLookup);
            }

            @Override
            public String getSecurityToken(@Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
                return SignatureV1Standard.getSecurityToken(headerLookup, parameterLookup);
            }
        }
        ,
        SignatureV4Standard(SignatureVersion.SignatureV4){
            private final Splitter CSV_SPLITTER = Splitter.onPattern((String)"\\s*,\\s*").trimResults().omitEmptyStrings();
            private final Splitter NVP_SPLITTER = Splitter.onPattern((String)"\\s*=\\s*").limit(2).trimResults().omitEmptyStrings();

            @Override
            protected Date getTimestamp(@Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
                Date timestamp = SignatureVariant.getSignatureDateFrom("header", (Function<String, List<String>>)headerLookup, SecurityHeader.X_Amz_Date.header(), Timestamps.Type.ISO_8601);
                if (timestamp == null) {
                    timestamp = SignatureVariant.getSignatureDateFrom("header", (Function<String, List<String>>)headerLookup, SecurityHeader.Date.header(), Timestamps.Type.RFC_2616);
                }
                return timestamp;
            }

            @Override
            public Collection<String> getParametersToRemove() {
                return Collections.emptyList();
            }

            @Override
            public Collection<String> getDateParametersToRemove() {
                return Collections.emptyList();
            }

            @Override
            public String getSignature(@Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
                return this.getAuthorizationParameters(headerLookup, parameterLookup).get("Signature");
            }

            @Override
            public String getAccessKeyId(@Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
                return this.getSignatureCredential(headerLookup, parameterLookup).getAccessKeyId();
            }

            @Override
            public Hmac getSignatureMethod(@Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
                return Hmac.HmacSHA256;
            }

            @Override
            public Map<String, String> getAuthorizationParameters(@Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
                String auth = HmacUtils.lookupUniqueRequired((Function<String, List<String>>)headerLookup, "header", "Authorization").replaceFirst(SecurityHeader.Value.AWS4_HMAC_SHA256.value(), "").trim();
                Iterable authParts = this.CSV_SPLITTER.split((CharSequence)auth);
                HashMap authParams = Maps.newHashMap();
                for (String nvp : authParts) {
                    Iterable nameAndValue = this.NVP_SPLITTER.split((CharSequence)nvp);
                    String name = (String)Iterables.get((Iterable)nameAndValue, (int)0, (Object)"");
                    String value = (String)Iterables.get((Iterable)nameAndValue, (int)1, (Object)"");
                    if (name.isEmpty() || value.isEmpty()) continue;
                    authParams.put(name, value);
                }
                if (!authParams.keySet().containsAll(Lists.newArrayList((Object[])new String[]{"Credential", "SignedHeaders", "Signature"}))) {
                    throw new AuthenticationException("Invalid authorization header: " + auth);
                }
                return authParams;
            }

            private SignatureCredential getSignatureCredential(@Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
                return new SignatureCredential(this.getAuthorizationParameters(headerLookup, parameterLookup).get("Credential"));
            }

            @Override
            public String getSecurityToken(@Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
                return HmacUtils.lookupUnique((Function<String, List<String>>)headerLookup, "header", SecurityParameter.X_Amz_Security_Token.parameter());
            }
        }
        ,
        SignatureV4Query(SignatureVersion.SignatureV4){

            @Override
            protected Date getTimestamp(@Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
                Date timestamp = SignatureVariant.getSignatureDateFrom("parameter", (Function<String, List<String>>)parameterLookup, SecurityParameter.X_Amz_Date.parameter(), Timestamps.Type.ISO_8601);
                if (timestamp == null) {
                    timestamp = SignatureVariant.getSignatureDateFrom("header", (Function<String, List<String>>)headerLookup, SecurityHeader.Date.header(), Timestamps.Type.RFC_2616);
                }
                return timestamp;
            }

            @Override
            public Collection<String> getParametersToRemove() {
                return PARAMETERS_V4_QUERY;
            }

            @Override
            public Collection<String> getDateParametersToRemove() {
                return Collections.singleton(SecurityParameter.X_Amz_Date.parameter());
            }

            @Override
            public String getSignature(@Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
                return HmacUtils.lookupUniqueRequired((Function<String, List<String>>)parameterLookup, "parameter", SecurityParameter.X_Amz_Signature.parameter());
            }

            @Override
            public String getAccessKeyId(@Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
                return new SignatureCredential(HmacUtils.lookupUniqueRequired((Function<String, List<String>>)parameterLookup, "parameter", SecurityParameter.X_Amz_Signature.parameter())).getAccessKeyId();
            }

            @Override
            public Hmac getSignatureMethod(@Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
                return Hmac.HmacSHA256;
            }

            @Override
            public Map<String, String> getAuthorizationParameters(@Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
                return ImmutableMap.builder().put((Object)"Credential", (Object)HmacUtils.lookupUniqueRequired((Function<String, List<String>>)parameterLookup, "parameter", SecurityParameter.X_Amz_Credential.parameter())).put((Object)"Signature", (Object)this.getSignature(headerLookup, parameterLookup)).put((Object)"SignedHeaders", (Object)HmacUtils.lookupUniqueRequired((Function<String, List<String>>)parameterLookup, "parameter", SecurityParameter.X_Amz_SignedHeaders.parameter())).build();
            }

            @Override
            public String getSecurityToken(@Nonnull Function<String, List<String>> headerLookup, @Nonnull Function<String, List<String>> parameterLookup) throws AuthenticationException {
                return HmacUtils.lookupUnique((Function<String, List<String>>)parameterLookup, "parameter", SecurityParameter.X_Amz_Security_Token.parameter());
            }
        };

        private final SignatureVersion version;

        private SignatureVariant(SignatureVersion version) {
            this.version = version;
        }

        @Nonnull
        public SignatureVersion getVersion() {
            return this.version;
        }

        protected abstract Date getTimestamp(@Nonnull Function<String, List<String>> var1, @Nonnull Function<String, List<String>> var2) throws AuthenticationException;

        @Nullable
        private static Date getSignatureDateFrom(String where, Function<String, List<String>> lookup, String name, Timestamps.Type type) throws AuthenticationException {
            String value = HmacUtils.lookupUnique((Function<String, List<String>>)lookup, where, name);
            if (value != null) {
                return Timestamps.parseTimestamp(value, type);
            }
            return null;
        }

        public abstract Collection<String> getParametersToRemove();

        public abstract Collection<String> getDateParametersToRemove();

        public abstract String getSignature(@Nonnull Function<String, List<String>> var1, @Nonnull Function<String, List<String>> var2) throws AuthenticationException;

        public abstract String getAccessKeyId(@Nonnull Function<String, List<String>> var1, @Nonnull Function<String, List<String>> var2) throws AuthenticationException;

        public abstract Hmac getSignatureMethod(@Nonnull Function<String, List<String>> var1, @Nonnull Function<String, List<String>> var2) throws AuthenticationException;

        public abstract Map<String, String> getAuthorizationParameters(@Nonnull Function<String, List<String>> var1, @Nonnull Function<String, List<String>> var2) throws AuthenticationException;

        public abstract String getSecurityToken(@Nonnull Function<String, List<String>> var1, @Nonnull Function<String, List<String>> var2) throws AuthenticationException;
    }
}

