/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.util;

import com.eucalyptus.binding.BindingManager;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Ats;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.ws.EucalyptusWebServiceException;
import com.eucalyptus.ws.Role;
import com.eucalyptus.ws.protocol.QueryBindingInfo;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.BaseMessageSupplier;
import edu.ucsb.eucalyptus.msgs.ErrorDetail;
import edu.ucsb.eucalyptus.msgs.ErrorResponse;
import edu.ucsb.eucalyptus.msgs.EucalyptusErrorMessageType;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.mule.api.MessagingException;
import org.mule.message.ExceptionMessage;

public abstract class ErrorHandlerSupport {
    private final Logger LOG;
    private final String namespace;
    private final String defaultCode;

    protected ErrorHandlerSupport(Logger logger, String namespace, String defaultCode) {
        this.LOG = logger;
        this.namespace = namespace;
        this.defaultCode = defaultCode;
    }

    public void handle(ExceptionMessage exMsg) {
        EventRecord.here(this.getClass(), EventType.MSG_REPLY, exMsg.getPayload().getClass().getSimpleName()).debug();
        Throwable exception = exMsg.getException();
        if (exception instanceof MessagingException && exception.getCause() instanceof EucalyptusCloudException) {
            try {
                String code;
                Role role;
                EucalyptusCloudException cloudException = (EucalyptusCloudException)exception.getCause();
                BaseMessage payload = this.parsePayload(exMsg.getPayload());
                if (cloudException instanceof EucalyptusWebServiceException) {
                    EucalyptusWebServiceException webServiceException = (EucalyptusWebServiceException)cloudException;
                    role = webServiceException.getRole();
                    code = webServiceException.getCode();
                } else {
                    role = Role.Receiver;
                    code = this.defaultCode;
                }
                QueryBindingInfo info = Ats.inClassHierarchy(cloudException.getClass()).get(QueryBindingInfo.class);
                HttpResponseStatus status = info == null ? HttpResponseStatus.INTERNAL_SERVER_ERROR : new HttpResponseStatus(info.statusCode(), code);
                BaseMessage errorResp = this.buildErrorResponse(payload.getCorrelationId(), role, code, cloudException.getMessage());
                Contexts.response(new BaseMessageSupplier(errorResp, status));
            }
            catch (PayloadParseException e) {
                this.LOG.error((Object)"Failed to parse payload ", e.getCause());
            }
        } else {
            this.LOG.error((Object)"Unable to handle exception", exception);
            BaseMessage errorResp = this.buildFatalResponse(exception);
            Contexts.response(new BaseMessageSupplier(errorResp, HttpResponseStatus.INTERNAL_SERVER_ERROR));
        }
    }

    private BaseMessage buildFatalResponse(Throwable exception) {
        ErrorResponse errorResponse = new ErrorResponse();
        ErrorDetail error = new ErrorDetail();
        error.setCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.getCode());
        error.setMessage(exception.getMessage());
        error.setType(this.defaultCode);
        if (Logs.isDebug()) {
            error.setStackTrace(Exceptions.string(exception));
        }
        return errorResponse;
    }

    protected abstract BaseMessage buildErrorResponse(String var1, Role var2, String var3, String var4);

    private BaseMessage parsePayload(Object payload) throws PayloadParseException {
        if (payload instanceof BaseMessage) {
            return (BaseMessage)payload;
        }
        if (payload instanceof String) {
            try {
                return (BaseMessage)BindingManager.getBinding(this.namespace).fromOM((String)payload);
            }
            catch (Exception e) {
                throw new PayloadParseException(e);
            }
        }
        return new EucalyptusErrorMessageType(this.getClass().getSimpleName(), LogUtil.dumpObject(payload));
    }

    private static final class PayloadParseException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public PayloadParseException(Throwable cause) {
            super(cause);
        }
    }
}

