/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.server;

import com.eucalyptus.auth.principal.User;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.http.MappingHttpMessage;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.util.LogUtil;
import edu.ucsb.eucalyptus.constants.IsData;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.BaseMessageSupplier;
import edu.ucsb.eucalyptus.msgs.StreamedBaseMessage;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.mule.transport.NullPayload;

@ChannelHandler.Sharable
public enum ServiceHackeryHandler implements ChannelUpstreamHandler,
ChannelDownstreamHandler
{
    INSTANCE;

    private static Logger LOG;

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof MessageEvent) {
            MessageEvent msge = (MessageEvent)e;
            if (msge.getMessage() instanceof NullPayload) {
                LOG.error((Object)("Received NULL response: " + ((NullPayload)msge.getMessage()).toString()));
                msge.getFuture().cancel();
            } else if (msge.getMessage() instanceof HttpResponse) {
                ctx.sendDownstream(e);
            } else if (msge.getMessage() instanceof IsData || msge.getMessage() instanceof HttpChunk) {
                ctx.sendDownstream(e);
            } else if (msge.getMessage() instanceof BaseMessage) {
                BaseMessage reply = (BaseMessage)((MessageEvent)e).getMessage();
                if (reply instanceof StreamedBaseMessage && !((StreamedBaseMessage)reply).getHasStreamingData()) {
                    e.getFuture().cancel();
                    return;
                }
                ctx.sendDownstream((ChannelEvent)msge);
            } else if (msge.getMessage() instanceof BaseMessageSupplier) {
                ctx.sendDownstream((ChannelEvent)msge);
            } else if (msge.getMessage() instanceof Throwable) {
                ctx.sendDownstream(e);
            } else {
                e.getFuture().cancel();
                LOG.warn((Object)("Non-specific type being written to the channel. Not dropping this message causes breakage:" + msge.getMessage().getClass()));
            }
            if (e.getFuture().isCancelled()) {
                LOG.trace((Object)("Cancelling send on : " + LogUtil.dumpObject(e)));
            }
        } else {
            ctx.sendDownstream(e);
        }
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        Object request = MappingHttpMessage.extractMessage(e);
        Object msg = BaseMessage.extractMessage(e);
        if (request != null && msg != null) {
            EventRecord.here(ServiceHackeryHandler.class, EventType.MSG_RECEIVED, msg.getClass().getSimpleName()).trace();
            User user = Contexts.lookup(((MappingHttpMessage)((Object)request)).getCorrelationId()).getUser();
            this.mangleCorrelationId(ctx, (BaseMessage)msg);
            this.mangleAdminDescribe((MappingHttpMessage)((Object)request), (BaseMessage)msg, user);
            ctx.sendUpstream(e);
        } else {
            ctx.sendUpstream(e);
        }
    }

    private void mangleCorrelationId(ChannelHandlerContext ctx, BaseMessage msg) {
        if (msg.getCorrelationId() == null) {
            String corrId = null;
            try {
                corrId = Contexts.lookup(ctx.getChannel()).getCorrelationId();
            }
            catch (Exception e1) {
                corrId = UUID.randomUUID().toString();
            }
            msg.setCorrelationId(corrId);
        }
    }

    private void mangleAdminDescribe(MappingHttpMessage request, BaseMessage msg, User user) {
        String userAgent = request.getHeader("User-Agent");
        if (userAgent != null && userAgent.matches(".*EucalyptusAdminAccess") && msg.getClass().getSimpleName().startsWith("Describe")) {
            msg.markUnprivileged();
        }
    }

    static {
        LOG = Logger.getLogger(ServiceHackeryHandler.class);
    }
}

