/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.server;

import com.eucalyptus.component.ServiceOperations;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.NoSuchContextException;
import com.eucalyptus.context.ServiceDispatchException;
import com.eucalyptus.http.MappingHttpMessage;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.http.MappingHttpResponse;
import com.eucalyptus.records.EventClass;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.BaseMessageSupplier;
import edu.ucsb.eucalyptus.msgs.EucalyptusErrorMessageType;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelLocal;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.DownstreamMessageEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.timeout.IdleStateEvent;

public class ServiceContextHandler
implements ChannelUpstreamHandler,
ChannelDownstreamHandler {
    private static Logger LOG = Logger.getLogger(ServiceContextHandler.class);
    private ChannelLocal<Long> startTime = new ChannelLocal();
    private ChannelLocal<Long> openTime = new ChannelLocal();
    private ChannelLocal<BaseMessage> messageType = new ChannelLocal<BaseMessage>(){

        protected BaseMessage initialValue(Channel channel) {
            return new BaseMessage();
        }
    };

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        LOG.debug((Object)ctx.getChannel(), e.getCause());
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        Object reply = BaseMessage.extractMessage(e);
        if (reply != null) {
            MessageEvent newEvent = this.makeDownstreamNewEvent(ctx, e, (BaseMessage)reply);
            ctx.sendDownstream((ChannelEvent)newEvent);
        } else if (e instanceof ExceptionEvent) {
            this.exceptionCaught(ctx, (ExceptionEvent)e);
            ctx.sendDownstream(e);
        } else {
            ctx.sendDownstream(e);
        }
    }

    private MessageEvent makeDownstreamNewEvent(ChannelHandlerContext ctx, ChannelEvent e, BaseMessage reply) {
        MappingHttpRequest request = null;
        Context reqCtx = null;
        try {
            if (reply != null) {
                reqCtx = Contexts.lookup(reply.getCorrelationId());
                request = reqCtx.getHttpRequest();
            }
        }
        catch (NoSuchContextException e1) {
            LOG.debug((Object)e1, (Throwable)e1);
        }
        if (request != null) {
            if (reply == null) {
                LOG.warn((Object)("Received a null response for request: " + request.getMessageString()));
                reply = new EucalyptusErrorMessageType(this.getClass().getSimpleName(), (BaseMessage)request.getMessage(), "Received a NULL reply");
            }
            Long currTime = System.currentTimeMillis();
            try {
                Logs.extreme().debug((Object)EventRecord.here(reply.getClass(), EventClass.MESSAGE, EventType.MSG_SERVICED, "request-ms", Long.toString(currTime - (Long)this.startTime.get(ctx.getChannel()))));
            }
            catch (Exception ex) {
                Logs.extreme().trace((Object)ex, (Throwable)ex);
            }
            MappingHttpResponse response = new MappingHttpResponse(request.getProtocolVersion());
            DownstreamMessageEvent newEvent = new DownstreamMessageEvent(ctx.getChannel(), e.getFuture(), (Object)response, null);
            response.setMessage(reply);
            this.setStatus(response, e);
            return newEvent;
        }
        MappingHttpResponse response = new MappingHttpResponse(HttpVersion.HTTP_1_1);
        response.setMessage(new EucalyptusErrorMessageType(this.getClass().getSimpleName(), "Received a NULL reply"));
        this.setStatus(response, e);
        return new DownstreamMessageEvent(ctx.getChannel(), e.getFuture(), (Object)response, null);
    }

    private void setStatus(MappingHttpResponse response, ChannelEvent e) {
        HttpResponseStatus status;
        MessageEvent msge;
        if (e instanceof MessageEvent && (msge = (MessageEvent)e).getMessage() instanceof BaseMessageSupplier && (status = ((BaseMessageSupplier)msge.getMessage()).getStatus()) != null) {
            response.setStatus(status);
        }
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        Object request = MappingHttpMessage.extractMessage(e);
        Object msg = BaseMessage.extractMessage(e);
        if (Logs.isExtrrreeeme()) {
            LOG.trace((Object)(this.getClass().getSimpleName() + "[incoming]:" + (msg != null ? msg.getClass().getSimpleName() : "") + " " + e));
        }
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent evt = (ChannelStateEvent)e;
            switch (evt.getState()) {
                case OPEN: {
                    if (Boolean.TRUE.equals(evt.getValue())) {
                        this.channelOpened(ctx, evt);
                        break;
                    }
                    this.channelClosed(ctx, evt);
                }
            }
            Logs.extreme().trace((Object)("Channel event: " + evt));
            ctx.sendUpstream(e);
        } else if (e instanceof IdleStateEvent) {
            Logs.extreme().warn((Object)("Closing idle connection: " + e));
            e.getFuture().addListener(ChannelFutureListener.CLOSE);
            ctx.sendUpstream(e);
        } else if (request != null && msg != null) {
            this.messageReceived(ctx, (BaseMessage)msg);
            ctx.sendUpstream(e);
        } else if (e instanceof ExceptionEvent) {
            this.exceptionCaught(ctx, (ExceptionEvent)e);
            ctx.sendUpstream(e);
        } else {
            ctx.sendUpstream(e);
        }
    }

    private void messageReceived(ChannelHandlerContext ctx, BaseMessage msg) throws ServiceDispatchException {
        this.startTime.set(ctx.getChannel(), (Object)System.currentTimeMillis());
        this.messageType.set(ctx.getChannel(), (Object)msg);
        EventRecord.here(ServiceContextHandler.class, EventType.MSG_RECEIVED, msg.getClass().getSimpleName()).trace();
        ServiceOperations.dispatch(msg);
    }

    private void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent evt) {
        if (Contexts.exists(ctx.getChannel())) {
            try {
                Contexts.clear(Contexts.lookup(ctx.getChannel()));
            }
            catch (NoSuchContextException ex) {
                Logs.extreme().debug((Object)"Failed to remove the channel context on connection close.", (Throwable)ex);
            }
        }
        try {
            if (ctx.getChannel() != null) {
                BaseMessage msg = (BaseMessage)this.messageType.get(ctx.getChannel());
                Long openTime = (Long)this.openTime.get(ctx.getChannel());
                if (msg != null && openTime != null) {
                    Logs.extreme().debug((Object)EventRecord.here(msg.getClass(), EventClass.MESSAGE, EventType.MSG_SERVICED, "rtt-ms", Long.toString(System.currentTimeMillis() - openTime)));
                }
            }
        }
        catch (Exception ex) {
            Logs.extreme().trace((Object)ex, (Throwable)ex);
        }
    }

    private void channelOpened(ChannelHandlerContext ctx, ChannelStateEvent evt) {
        this.openTime.set(ctx.getChannel(), (Object)System.currentTimeMillis());
    }
}

