/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.server;

import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.ComponentMessages;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.crypto.util.SecurityParameter;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.http.MappingHttpResponse;
import com.eucalyptus.ws.StackConfiguration;
import com.eucalyptus.ws.protocol.OperationParameter;
import com.eucalyptus.ws.protocol.RequestLoggingFilters;
import com.eucalyptus.ws.protocol.RequiredQueryParams;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpMethod;

@ChannelHandler.Sharable
public enum ServiceAccessLoggingHandler implements ChannelUpstreamHandler,
ChannelDownstreamHandler
{
    INSTANCE;

    public static Set<String> ignoredParameters;
    private static final Predicate<String> ignoredParametersPredicate;
    private static final Function<MappingHttpRequest, Collection<String>> createParameters;
    private static Logger LOG;

    private static void createLogEntry(ChannelHandlerContext ctx, Object replyObject, String ... extra) {
        try {
            Context context = Contexts.lookup(ctx.getChannel());
            ArrayList logEntries = Lists.newArrayList((Object[])new String[]{context.getCorrelationId(), context.getUserFullName().toString(), ctx.getChannel().getRemoteAddress().toString(), ctx.getChannel().getLocalAddress().toString()});
            String componentName = "wsstack";
            if (replyObject instanceof BaseMessage) {
                try {
                    Class<ComponentId> compMsg = ComponentMessages.lookup((BaseMessage)replyObject);
                    ComponentId compId = ComponentIds.lookup(compMsg);
                    componentName = compId.name();
                }
                catch (Exception e) {
                    Logger.getLogger((String)("LoggingError." + ServiceAccessLoggingHandler.class.getCanonicalName())).debug((Object)e);
                }
            }
            logEntries.add(componentName);
            logEntries.add(replyObject.getClass().getSimpleName());
            logEntries.add("[" + Joiner.on((String)",").join(Arrays.asList(extra)) + "]");
            LOG.info((Object)Joiner.on((String)" ").join((Iterable)logEntries));
        }
        catch (Exception e) {
            Logger.getLogger((String)("LoggingError." + ServiceAccessLoggingHandler.class.getCanonicalName())).debug((Object)e);
        }
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (((Boolean)com.google.common.base.Objects.firstNonNull((Object)StackConfiguration.LOG_REQUESTS, (Object)Boolean.TRUE)).booleanValue()) {
            try {
                MessageEvent msge;
                if (e instanceof MessageEvent && (msge = (MessageEvent)e).getMessage() instanceof MappingHttpRequest) {
                    MappingHttpRequest httpMessage = (MappingHttpRequest)((Object)((MessageEvent)e).getMessage());
                    String method = Objects.toString(httpMessage.getMethod(), "HTTP-UNKNOWN");
                    String parameters = Joiner.on((String)",").join((Iterable)createParameters.apply((Object)httpMessage));
                    ServiceAccessLoggingHandler.createLogEntry(ctx, httpMessage.getMessage(), method, parameters);
                }
            }
            catch (Exception e1) {
                Logger.getLogger((String)("LoggingError." + ServiceAccessLoggingHandler.class.getCanonicalName())).debug((Object)e1);
            }
        }
        ctx.sendUpstream(e);
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        block7: {
            if (((Boolean)com.google.common.base.Objects.firstNonNull((Object)StackConfiguration.LOG_REQUESTS, (Object)Boolean.TRUE)).booleanValue()) {
                try {
                    if (e instanceof MessageEvent) {
                        MessageEvent msge = (MessageEvent)e;
                        if (msge.getMessage() instanceof MappingHttpResponse) {
                            MappingHttpResponse httpMessage = (MappingHttpResponse)((MessageEvent)e).getMessage();
                            ServiceAccessLoggingHandler.createLogEntry(ctx, httpMessage.getMessage(), Objects.toString(httpMessage.getStatus(), "UNKNOWN"));
                        }
                        break block7;
                    }
                    if (!(e instanceof ExceptionEvent)) break block7;
                    Throwable reply = ((ExceptionEvent)e).getCause();
                    String[] extra = new String[]{};
                    try {
                        List causalChain = Throwables.getCausalChain((Throwable)reply);
                        extra = (String[])Collections2.transform((Collection)causalChain, (Function)Functions.toStringFunction()).toArray();
                    }
                    catch (Exception e1) {
                        Logger.getLogger((String)("LoggingError." + ServiceAccessLoggingHandler.class.getCanonicalName())).debug((Object)e1);
                    }
                    ServiceAccessLoggingHandler.createLogEntry(ctx, reply, extra);
                }
                catch (Exception e1) {
                    Logger.getLogger((String)("LoggingError." + ServiceAccessLoggingHandler.class.getCanonicalName())).debug((Object)e1);
                }
            }
        }
        ctx.sendDownstream(e);
    }

    static {
        ignoredParameters = new TreeSet<String>(){
            {
                this.addAll(Collections2.transform(Arrays.asList(OperationParameter.values()), (Function)Functions.toStringFunction()));
                this.addAll(Collections2.transform(Arrays.asList(SecurityParameter.values()), (Function)Functions.toStringFunction()));
                this.addAll(Collections2.transform(Arrays.asList(RequiredQueryParams.values()), (Function)Functions.toStringFunction()));
            }
        };
        ignoredParametersPredicate = new Predicate<String>(){

            public boolean apply(String input) {
                try {
                    return !ignoredParameters.contains(input.substring(0, input.indexOf("=")));
                }
                catch (Exception e) {
                    return false;
                }
            }
        };
        createParameters = new Function<MappingHttpRequest, Collection<String>>(){

            public Collection<String> apply(MappingHttpRequest input) {
                try {
                    String query = Objects.toString(input.getQuery(), "");
                    if (HttpMethod.POST.equals((Object)input.getMethod())) {
                        ChannelBuffer buffer = input.getContent();
                        buffer.markReaderIndex();
                        query = new String(buffer.array());
                        buffer.resetReaderIndex();
                    }
                    return Collections2.filter(RequestLoggingFilters.get().apply(Arrays.asList(query.split("&"))), (Predicate)ignoredParametersPredicate);
                }
                catch (Exception e) {
                    return Collections.emptyList();
                }
            }
        };
        LOG = Logger.getLogger(ServiceAccessLoggingHandler.class);
    }
}

