/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.server;

import com.eucalyptus.auth.principal.TemporaryAccessKey;
import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.Bootstrapper;
import com.eucalyptus.bootstrap.Provides;
import com.eucalyptus.bootstrap.RunDuring;
import com.eucalyptus.bootstrap.ServiceJarDiscovery;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.annotation.AwsServiceName;
import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.component.annotation.PublicService;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.http.MappingHttpMessage;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Ats;
import com.eucalyptus.util.Classes;
import com.eucalyptus.ws.Handlers;
import com.eucalyptus.ws.handlers.HmacHandler;
import com.eucalyptus.ws.protocol.BaseQueryBinding;
import com.eucalyptus.ws.protocol.OperationParameter;
import com.eucalyptus.ws.protocol.SoapHandler;
import com.eucalyptus.ws.server.DuplicatePipelineException;
import com.eucalyptus.ws.server.FilteredPipeline;
import com.eucalyptus.ws.server.NoAcceptingPipelineException;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import edu.ucsb.eucalyptus.cloud.entities.SystemConfiguration;
import java.lang.reflect.Modifier;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;

public class Pipelines {
    private static final Logger LOG = Logger.getLogger(Pipelines.class);
    private static final Set<FilteredPipeline> internalPipelines = Sets.newHashSet();
    private static final Set<FilteredPipeline> pipelines = Sets.newHashSet();
    private static final Map<Class<? extends ComponentId>, ChannelPipelineFactory> clientPipelines = Maps.newHashMap();
    private static final Supplier<String> subDomain = new Supplier<String>(){

        public String get() {
            return SystemConfiguration.getSystemConfiguration().getDnsDomain();
        }
    };

    public static ChannelPipelineFactory lookup(Class<? extends ComponentId> compId) {
        return clientPipelines.get(compId);
    }

    static FilteredPipeline find(HttpRequest request) throws DuplicatePipelineException, NoAcceptingPipelineException {
        FilteredPipeline candidate = Pipelines.findAccepting(request);
        if (candidate == null) {
            if (Logs.isExtrrreeeme() && request instanceof MappingHttpMessage) {
                ((MappingHttpMessage)request).logMessage();
                for (FilteredPipeline p : pipelines) {
                    LOG.debug((Object)("PIPELINE: " + p));
                }
                for (FilteredPipeline p : internalPipelines) {
                    LOG.debug((Object)("PIPELINE: " + p));
                }
            }
            throw new NoAcceptingPipelineException();
        }
        if (Logs.isExtrrreeeme()) {
            EventRecord.here(Pipelines.class, EventType.PIPELINE_UNROLL, candidate.toString()).extreme();
        }
        return candidate;
    }

    private static FilteredPipeline findAccepting(HttpRequest request) {
        FilteredPipeline candidate = null;
        for (FilteredPipeline f : pipelines) {
            if (!f.checkAccepts(request)) continue;
            return f;
        }
        if (request.getHeader("Host").contains("amazonaws.com") || request.getHeader("Host").contains((CharSequence)subDomain.get())) {
            String hostHeader = request.getHeader("Host");
            LOG.debug((Object)("Trying to intercept request for " + hostHeader));
            for (FilteredPipeline f : pipelines) {
                if (!Ats.from(f).has(ComponentPart.class)) continue;
                Class<? extends ComponentId> compIdClass = Ats.from(f).get(ComponentPart.class).value();
                ComponentId compId = ComponentIds.lookup(compIdClass);
                if (!Ats.from(compIdClass).has(PublicService.class) || request.getHeaderNames().contains("SOAPAction") && f.addHandlers(Channels.pipeline()).get(SoapHandler.class) == null || !request.getHeaderNames().contains("SOAPAction") && f.addHandlers(Channels.pipeline()).get(SoapHandler.class) != null) continue;
                LOG.debug((Object)("Maybe intercepting: " + hostHeader + " using " + f.getClass()));
                if (Ats.from(compIdClass).has(AwsServiceName.class) && request.getHeader("Host").matches("[\\w\\.-_]*" + compId.getAwsServiceName() + "\\.\\w+\\.amazonaws.com")) {
                    return f;
                }
                if (!request.getHeader("Host").matches("[\\w\\.-_]*" + compId.name() + "\\." + (String)subDomain.get())) continue;
                return f;
            }
        }
        if (candidate == null) {
            for (FilteredPipeline f : internalPipelines) {
                if (!f.checkAccepts(request)) continue;
                return f;
            }
        }
        return candidate;
    }

    static class InternalQueryBinding
    extends BaseQueryBinding<OperationParameter>
    implements ChannelHandler {
        public InternalQueryBinding() {
            super("http://ec2.amazonaws.com/doc/%s/", "2009-04-04", (Enum)OperationParameter.Action, (Enum[])new OperationParameter[]{OperationParameter.Operation});
        }
    }

    private static class InternalQueryPipeline
    extends FilteredPipeline.InternalPipeline {
        private final String servicePath;
        private final String internalServicePath;
        private final String serviceName;

        public InternalQueryPipeline(ComponentId componentId) {
            super(componentId);
            this.servicePath = componentId.getServicePath(new String[0]);
            this.internalServicePath = componentId.getInternalServicePath(new String[0]);
            this.serviceName = componentId.getFullName().toString();
        }

        @Override
        public boolean checkAccepts(HttpRequest message) {
            if (message instanceof MappingHttpRequest) {
                MappingHttpRequest httpRequest = (MappingHttpRequest)message;
                if (httpRequest.getMethod().equals((Object)HttpMethod.POST)) {
                    HashMap<String, String> parameters = new HashMap<String, String>(httpRequest.getParameters());
                    ChannelBuffer buffer = httpRequest.getContent();
                    buffer.markReaderIndex();
                    byte[] read = new byte[buffer.readableBytes()];
                    buffer.readBytes(read);
                    String query = new String(read);
                    buffer.resetReaderIndex();
                    for (String string : query.split("&")) {
                        String[] splitParam = string.split("=");
                        String lhs = splitParam[0];
                        String rhs = splitParam.length == 2 ? splitParam[1] : null;
                        try {
                            if (lhs != null) {
                                lhs = new URLCodec().decode(lhs);
                            }
                        }
                        catch (DecoderException decoderException) {
                            // empty catch block
                        }
                        try {
                            if (rhs != null) {
                                rhs = new URLCodec().decode(rhs);
                            }
                        }
                        catch (DecoderException decoderException) {
                            // empty catch block
                        }
                        parameters.put(lhs, rhs);
                    }
                    for (RequiredQueryParams requiredQueryParams : RequiredQueryParams.values()) {
                        if (parameters.containsKey(requiredQueryParams.toString())) continue;
                        return false;
                    }
                    httpRequest.getParameters().putAll(parameters);
                } else {
                    for (RequiredQueryParams p : RequiredQueryParams.values()) {
                        if (httpRequest.getParameters().containsKey(p.toString())) continue;
                        return false;
                    }
                }
                return message.getUri().startsWith(this.servicePath) || message.getUri().startsWith(this.internalServicePath);
            }
            return false;
        }

        @Override
        public String getName() {
            return "internal-query-pipeline-" + this.serviceName.toLowerCase() + "-" + this.servicePath;
        }

        @Override
        public ChannelPipeline addHandlers(ChannelPipeline pipeline) {
            pipeline.addLast("hmac-v2-verify", (ChannelHandler)new HmacHandler(EnumSet.of(TemporaryAccessKey.TemporaryKeyType.Role)));
            pipeline.addLast("timestamp-verify", Handlers.queryTimestamphandler());
            pipeline.addLast("restful-binding", (ChannelHandler)new InternalQueryBinding());
            return pipeline;
        }

        @Override
        public String toString() {
            return String.format("InternalQueryPipeline:servicePath=%s:serviceName=%s:toString()=%s", this.servicePath, this.serviceName, super.toString());
        }

        public static enum RequiredQueryParams {
            SignatureVersion,
            Version;

        }
    }

    private static class InternalSoapPipeline
    extends FilteredPipeline.InternalPipeline {
        private final String servicePath;
        private final String internalServicePath;
        private final String serviceName;

        public InternalSoapPipeline(ComponentId componentId) {
            super(componentId);
            this.servicePath = componentId.getServicePath(new String[0]);
            this.internalServicePath = componentId.getInternalServicePath(new String[0]);
            this.serviceName = componentId.getFullName().toString();
        }

        @Override
        public boolean checkAccepts(HttpRequest message) {
            return (message.getUri().endsWith(this.servicePath) || message.getUri().endsWith(this.internalServicePath)) && message.getHeaderNames().contains("SOAPAction");
        }

        @Override
        public String getName() {
            return "internal-soap-pipeline-" + this.serviceName.toLowerCase() + "-" + this.servicePath;
        }

        @Override
        public ChannelPipeline addHandlers(ChannelPipeline pipeline) {
            pipeline.addLast("deserialize", Handlers.soapMarshalling());
            pipeline.addLast("ws-security", Handlers.internalWsSecHandler());
            pipeline.addLast("ws-addressing", Handlers.addressingHandler());
            pipeline.addLast("build-soap-envelope", Handlers.soapHandler());
            pipeline.addLast("binding", Handlers.bindingHandler());
            return pipeline;
        }

        @Override
        public String toString() {
            return String.format("InternalSoapPipeline:servicePath=%s:serviceName=%s:toString()=%s", this.servicePath, this.serviceName, super.toString());
        }
    }

    public static class PipelineDiscovery
    extends ServiceJarDiscovery {
        @Override
        public boolean processClass(Class candidate) throws Exception {
            if (FilteredPipeline.class.isAssignableFrom(candidate) && !Modifier.isAbstract(candidate.getModifiers()) && !Modifier.isInterface(candidate.getModifiers()) && Ats.from(candidate).has(ComponentPart.class)) {
                try {
                    ComponentId compId = Ats.from(candidate).get(ComponentPart.class).value().newInstance();
                    Class pipelineClass = candidate;
                    FilteredPipeline pipeline = (FilteredPipeline)Classes.newInstance(pipelineClass, new Object[0]);
                    pipelines.add(pipeline);
                    return true;
                }
                catch (Exception ex) {
                    LOG.trace((Object)ex, (Throwable)ex);
                    return false;
                }
            }
            if (ChannelPipelineFactory.class.isAssignableFrom(candidate) && !Modifier.isAbstract(candidate.getModifiers()) && !Modifier.isInterface(candidate.getModifiers()) && Ats.from(candidate).has(ComponentPart.class)) {
                try {
                    ComponentId compId = Ats.from(candidate).get(ComponentPart.class).value().newInstance();
                    Class pipelineClass = candidate;
                    ChannelPipelineFactory pipeline = (ChannelPipelineFactory)Classes.newInstance(pipelineClass, new Object[0]);
                    clientPipelines.put(compId.getClass(), pipeline);
                    return true;
                }
                catch (Exception ex) {
                    LOG.trace((Object)ex, (Throwable)ex);
                    return false;
                }
            }
            return false;
        }

        @Override
        public Double getPriority() {
            return 0.1;
        }
    }

    @Provides(value=Empyrean.class)
    @RunDuring(value=Bootstrap.Stage.UnprivilegedConfiguration)
    public static class PipelineBootstrapper
    extends Bootstrapper.Simple {
        @Override
        public boolean load() throws Exception {
            for (ComponentId comp : ComponentIds.list()) {
                internalPipelines.add(new InternalQueryPipeline(comp));
                internalPipelines.add(new InternalSoapPipeline(comp));
            }
            return true;
        }
    }
}

